<?php

/**
  * SquirrelMail Reset User Preferences Plugin
  * Copyright (c) 2008 Paul Lesniewski <paul@squirrelmail.org>,
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage reset_prefs
  *
  */



/**
  * Validate that this plugin is configured correctly
  *
  * @return boolean Whether or not there was a
  *                 configuration error for this plugin.
  *
  */
function reset_prefs_check_configuration_do()
{

   // make sure base config is available
   //
   if (!reset_prefs_init())
   {
      do_err('Reset User Preferences plugin is missing its main configuration file', FALSE);
      return TRUE;
   }

}



/**
  * Initialize this plugin (load config values)
  *
  * @return boolean FALSE if no configuration file could be loaded, TRUE otherwise
  *
  */
function reset_prefs_init()
{

   if (!@include_once (SM_PATH . 'config/config_reset_prefs.php'))
      if (!@include_once (SM_PATH . 'plugins/reset_prefs/config.php'))
         if (!@include_once (SM_PATH . 'plugins/reset_prefs/config.sample.php'))
            return FALSE;

   return TRUE;

/* ----------  This is how to do the same thing using the Compatibility plugin
   return load_config('reset_prefs',
                      array('../../config/config_reset_prefs.php',
                            'config.php',
                            'config.sample.php'),
                      TRUE, TRUE);
----------- */

}



/**
  * Show note on main options page after button press
  *
  */
function reset_prefs_saved_options_do()
{

   global $optpage, $optpage_loader, $optpage_file, $optpage_save_error,
          $optpage_title, $optpage_name, $max_refresh;

   sq_change_text_domain('reset_prefs');

   if ($optpage == 'rp_reset_user_prefs')
   {
      $optpage_file = SM_PATH . 'plugins/reset_prefs/functions.php';
      $optpage_loader = 'rp_optpage_no_op';
      $optpage_name = _("Preferences Reset");
      //$optpage_title = _("Options - Personal Information");
      $optpage_title = _("Options");
      $max_refresh = SMOPT_REFRESH_ALL;
   }

   else if ($optpage == 'rp_backup_user_prefs')
   {
      $optpage_file = SM_PATH . 'plugins/reset_prefs/functions.php';
      $optpage_loader = 'rp_optpage_no_op';
      $optpage_name = _("Preferences Backed Up");
      //$optpage_title = _("Options - Personal Information");
      $optpage_title = _("Options");
   }

   else if ($optpage == 'rp_revert_user_prefs')
   {
      $optpage_file = SM_PATH . 'plugins/reset_prefs/functions.php';
      $optpage_loader = 'rp_optpage_no_op';
      $optpage_name = _("Preferences Reverted");
      //$optpage_title = _("Options - Personal Information");
      $optpage_title = _("Options");
      $max_refresh = SMOPT_REFRESH_ALL;
   }

   else if ($optpage == 'rp_revert_user_prefs_none_selected')
   {
      $optpage_file = SM_PATH . 'plugins/reset_prefs/functions.php';
      $optpage_loader = 'rp_optpage_no_op';
      $optpage_save_error = array(_("Preferences not reverted - please select a backup set to revert to"));
      //$optpage_title = _("Options - Personal Information");
      $optpage_title = _("Options");
   }

   sq_change_text_domain('squirrelmail');

}



/**
  * Placeholder function
  *
  * @return array Empty option page data array
  *
  */
function rp_optpage_no_op()
{
   return array('grps' => array(), 'vals' => array());
}



/**
  * Backup, reset or revert user preferences
  *
  */
function rp_reset_prefs_do()
{

   // catch reset button press
   //
   if (sqGetGlobalVar('rp_reset_user_prefs', $rp_reset_user_prefs, SQ_FORM))
   {

      rp_backup_and_replace_prefs();
      header('Location: ' . sqm_baseuri() . 'src/options.php?optpage=rp_reset_user_prefs&optmode=submit');
      exit;

   }


   // just make a backup?
   //
   if (sqGetGlobalVar('rp_backup_user_prefs', $rp_backup_user_prefs, SQ_FORM))
   {

      rp_backup_and_replace_prefs(array(), TRUE);
      header('Location: ' . sqm_baseuri() . 'src/options.php?optpage=rp_backup_user_prefs&optmode=submit');
      exit;

   }


   // revert preferences?
   //
   if (sqGetGlobalVar('rp_revert_user_prefs', $rp_revert_user_prefs, SQ_FORM))
   {

      if (!sqGetGlobalVar('new_rp_backup_times', $new_rp_backup_times, SQ_FORM))
      {
         header('Location: ' . sqm_baseuri() . 'src/options.php?optpage=rp_revert_user_prefs_none_selected&optmode=submit');
         exit;
      }


      // which backup time are we reverting to?
      //
      if (!empty($new_rp_backup_times))
         $backup_time = array_shift($new_rp_backup_times);
      if (empty($backup_time))
         return;


      // need to first retrieve the needed prefs set...
      // first make sure main SM prefs cache is empty
      //
      global $data_dir, $username, $prefs_cache, $prefs_are_cached;
      $prefs_cache = FALSE;
      $prefs_are_cached = FALSE;
      sqsession_unregister('prefs_are_cached');
      sqsession_unregister('prefs_cache');


      // now get a full list of the prefs set being reverted to
      //
      // getPref() should force a reload of the preferences cache,
      // unless some third-party prefs backend works differently
      //
      getPref($data_dir, $username . '-backup_' . $backup_time, 'show_num', 15);
      $replacement_prefs = $prefs_cache;


      // make sure main SM prefs cache is empty again
      //
      $prefs_cache = FALSE;
      $prefs_are_cached = FALSE;
      sqsession_unregister('prefs_are_cached');
      sqsession_unregister('prefs_cache');


      // revert!
      //
      rp_backup_and_replace_prefs($replacement_prefs);
      header('Location: ' . sqm_baseuri() . 'src/options.php?optpage=rp_revert_user_prefs&optmode=submit');
      exit;

   }

}



/**
  * Make backup of user prefs then replace them
  * with those that are given (or reset to default
  * if none are given).
  *
  * @param array   $replacement_prefs The preferences set to use
  *                                   from now on (OPTIONAL; default
  *                                   is to reset prefs to defaults)
  * @param boolean $only_backup       When TRUE, only a preferences
  *                                   backup set is made, the current
  *                                   prefs being used are not changed
  *                                   (OPTIONAL; default FALSE - prefs
  *                                   *will* be reverted or reset)
  *
  */
function rp_backup_and_replace_prefs($replacement_prefs=array(),
                                     $only_backup=FALSE)
{

   global $username, $data_dir, $prefs_cache, $prefs_are_cached,
          $rp_automatic_backup;
   reset_prefs_init();


   // when this hook is called, time zone isn't set up yet
   //
   rp_set_timezone();
   $backup_time = date('Y-m-d H:i');


   // don't lose track of what other prefs backups there are
   // and add on the one we're doing now
   //
   $rp_backup_times = getPref($data_dir, $username, 'rp_backup_times', array());
   if (!empty($rp_backup_times) && is_string($rp_backup_times))
      $rp_backup_times = unserialize($rp_backup_times);


   // first, get a copy of the current prefs cache
   // and save it off to the side, wiping out what
   // was there
   //
   // getPref() should force loading of the preferences cache
   // if needed, unless some third-party prefs backend works
   // differently
   //
   getPref($data_dir, $username, 'show_num', 15);
   $temp_prefs_cache = $prefs_cache;
   $prefs_cache = FALSE;
   $prefs_are_cached = FALSE;
   sqsession_unregister('prefs_are_cached');
   sqsession_unregister('prefs_cache');


   // now, make a backup set by saving the cache under
   // a different username
   //
   if ($only_backup || $rp_automatic_backup)
   {

      $rp_backup_times[] = $backup_time;


      foreach ($temp_prefs_cache as $key => $value)
         setPref($data_dir, $username . '-backup_' . $backup_time, $key, $value);


      // again just make sure main SM prefs cache is empty
      //
      $prefs_cache = FALSE;
      $prefs_are_cached = FALSE;
      sqsession_unregister('prefs_are_cached');
      sqsession_unregister('prefs_cache');


      // if just making a backup, we're done
      //
      if ($only_backup)
      {
         setPref($data_dir, $username, 'rp_backup_times', serialize($rp_backup_times));
         return;
      }

   }


   // next, delete all prefs values for the current user
   //
   foreach ($temp_prefs_cache as $key => $value)
      setPref($data_dir, $username, $key, '');


   // finally, replace (or reset) the prefs and re-save,
   // making sure to preserve our list of backup times
   //
   $prefs_cache = FALSE;
   $prefs_are_cached = FALSE;
   sqsession_unregister('prefs_are_cached');
   sqsession_unregister('prefs_cache');
   foreach ($replacement_prefs as $key => $value)
      setPref($data_dir, $username, $key, $value);
   setPref($data_dir, $username, 'rp_backup_times', serialize($rp_backup_times));


   // make next user of prefs reload them if needed
   //
   $prefs_cache = FALSE;
   $prefs_are_cached = FALSE;
   sqsession_unregister('prefs_are_cached');
   sqsession_unregister('prefs_cache');

}



/**
  * Set correct user timezone
  *
  * This is a copy of the core code (from 1.5.2 as of 2008/6/9,
  * which works in 1.4.x too) that does the same, for use in
  * this plugin at times before the timezone has been set.
  *
  */
function rp_set_timezone()
{

   global $data_dir, $username, $time_zone_type;


   $timeZone = getPref($data_dir, $username, 'timezone');

   /* Check to see if we are allowed to set the TZ environment variable.
    * We are able to do this if ...
    *   safe_mode is disabled OR
    *   safe_mode_allowed_env_vars is empty (you are allowed to set any) OR
    *   safe_mode_allowed_env_vars contains TZ
    */
   $tzChangeAllowed = (!ini_get('safe_mode')) ||
                       !strcmp(ini_get('safe_mode_allowed_env_vars'),'') ||
                       preg_match('/^([\w_]+,)*TZ/', ini_get('safe_mode_allowed_env_vars'));

   if ( $timeZone != SMPREF_NONE && ($timeZone != "")
       && $tzChangeAllowed ) {

       // get time zone key, if strict or custom strict timezones are used
       if (isset($time_zone_type) &&
           ($time_zone_type == 1 || $time_zone_type == 3)) {
           /* load time zone functions */
           require(SM_PATH . 'include/timezones.php');
           $realTimeZone = sq_get_tz_key($timeZone);
       } else {
           $realTimeZone = $timeZone;
       }

       // set time zone
       if ($realTimeZone) {
           putenv("TZ=".$realTimeZone);
       }
   }

}



/**
  * Display user configuration options on personal information page
  *
  */
function reset_prefs_display_options_do()
{

   global $username, $data_dir, $optpage_data;

   $rp_backup_times = getPref($data_dir, $username, 'rp_backup_times', array());
   if (!empty($rp_backup_times) && is_string($rp_backup_times))
      $rp_backup_times = unserialize($rp_backup_times);

   sq_change_text_domain('reset_prefs');

   $my_optpage_values = array();

   if (sizeof($rp_backup_times) > 0)
   {

      $my_optpage_values[] = array(
         'name'           => 'rp_backup_times',
         'caption'        => _("Backup Sets"),
         'type'           => SMOPT_TYPE_EDIT_LIST,
         //'layout_type'  => SMOPT_EDIT_LIST_LAYOUT_SELECT,
         'size'           => SMOPT_SIZE_SMALL,
         'posvals'        => $rp_backup_times,
         'refresh'        => SMOPT_REFRESH_NONE,
         'save'           => 'rp_save_backup_times',
         'use_add_widget' => FALSE,
      );

      $my_optpage_values[] = array(
         'name'          => 'rp_revert_user_prefs',
         'caption'       => '',
         'type'          => SMOPT_TYPE_SUBMIT,
         'refresh'       => SMOPT_REFRESH_NONE,
         'comment'       => _("Revert User Preferences To Selected"),
      );

   }

   $my_optpage_values[] = array(
      'name'          => 'rp_backup_user_prefs',
      'caption'       => '',
      'type'          => SMOPT_TYPE_SUBMIT,
      'refresh'       => SMOPT_REFRESH_NONE,
      'comment'       => _("Backup User Preferences"),
   );


   $my_optpage_values[] = array(
      'name'          => 'rp_reset_user_prefs',
      'caption'       => '',
      'type'          => SMOPT_TYPE_SUBMIT,
      'refresh'       => SMOPT_REFRESH_NONE,
      'comment'       => _("Reset User Preferences"),
   );


   if (!empty($my_optpage_values))
   {  

      // add our own section to the option page
      //
      $optpage_data['grps']['reset_prefs'] = _("Preferences Management");
      $optpage_data['vals']['reset_prefs'] = $my_optpage_values;

   }  
         
   sq_change_text_domain('squirrelmail');

}



/**
  * Save user prefs backup set times - called from
  * within SquirrelMail options save routine.  This
  * function is intended to do ancillary processing
  * and use the internal SquirrelMail facilities to
  * actually save the backup times data.
  *
  * Specifically, when a backup set is removed, the
  * associated saved preferences need to be removed
  * from the preferences backend.
  *
  * @param object $option The option class object representing
  *                       the user prefs backup set data being
  *                       saved.
  *
  */
function rp_save_backup_times($option)
{

   // grab a copy of the list before processing
   //
   $original = $option->possible_values;


   // now call into standard SquirrelMail save function
   // where the list will be correctly processed
   // and saved
   //
   save_option($option);


   // finally, we can compare the saved list with the
   // original one and determine which items were
   // removed and thusly remove the contents of any
   // such prefs sets
   //
   $deleted_pref_sets = array_diff($original, $option->possible_values);
   if (!empty($deleted_pref_sets))
   {

      // remove pref sets one at a time
      //
      global $username, $data_dir, $prefs_cache,
             $prefs_are_cached, $prefs_backend;
      foreach ($deleted_pref_sets as $backup_time)
      {

         // make sure main SM prefs cache is empty
         //      
         $prefs_cache = FALSE;
         $prefs_are_cached = FALSE;
         sqsession_unregister('prefs_are_cached');
         sqsession_unregister('prefs_cache');


         // now get a full list of the prefs set being removed
         //
         // getPref() should force a reload of the preferences cache,
         // unless some third-party prefs backend works differently
         //
         getPref($data_dir, $username . '-backup_' . $backup_time, 'show_num', 15);
         $temp_prefs_cache = $prefs_cache;


         // next, delete the prefs
         //
         foreach ($temp_prefs_cache as $key => $value)
            removePref($data_dir, $username . '-backup_' . $backup_time, $key);
            //setPref($data_dir, $username . '-backup_' . $backup_time, $key, '');


         // for file-based prefs, remove the now empty prefs file
         //
         if ((!isset($prefs_dsn) || empty($prefs_dsn))
          && (!isset($prefs_backend) || empty($prefs_backend)
           || !file_exists(SM_PATH . $prefs_backend)))
         {
            @unlink(getHashedFile($username . '-backup_' . $backup_time, $data_dir, $username . '-backup_' . $backup_time . '.pref'));
         }


         // make sure main SM prefs cache is empty again
         //      
         $prefs_cache = FALSE;
         $prefs_are_cached = FALSE;
         sqsession_unregister('prefs_are_cached');
         sqsession_unregister('prefs_cache');

      }

   }

}



