<?php


/**
  * SquirrelMail Reply Button Plugin
  * Copyright (c) 2005 Paul Lesneiwski <pdontthink@angrynerds.com>
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage reply_buttons
  *
  */



/**
  * Build user options for display on "Display Preferences" page
  *
  */
function rb_show_options_do()
{

   global $data_dir, $username;

   $show_reply_button = getPref($data_dir, $username, 'show_reply_button_on_message_list', 0);
   $show_reply_all_button = getPref($data_dir, $username, 'show_reply_all_button_on_message_list', 0);

   bindtextdomain('reply_buttons', SM_PATH . 'locale');
   textdomain('reply_buttons');

   global $optpage_data;
   $optpage_data['vals'][1][] = array(
      'name'          => 'show_reply_button_on_message_list',
      'caption'       => _("Show Reply Button Above Message List"),
      'type'          => SMOPT_TYPE_BOOLEAN,
      'initial_value' => $show_reply_button,
      'refresh'       => SMOPT_REFRESH_NONE,
   );

   $optpage_data['vals'][1][] = array(
      'name'          => 'show_reply_all_button_on_message_list',
      'caption'       => _("Show Reply All Button Above Message List"),
      'type'          => SMOPT_TYPE_BOOLEAN,
      'initial_value' => $show_reply_all_button,
      'refresh'       => SMOPT_REFRESH_NONE,
   );

   bindtextdomain('squirrelmail', SM_PATH . 'locale');
   textdomain('squirrelmail');

}



/**
  * Adds reply button to mailbox listing
  *
  */
function rb_mailbox_list_buttons_do()
{

   global $username, $data_dir, $compose_new_win, $javascript_on, 
          $mailbox, $startMessage, $base_uri;

   $show_reply_button = getPref($data_dir, $username, 'show_reply_button_on_message_list', 0);
   $show_reply_all_button = getPref($data_dir, $username, 'show_reply_all_button_on_message_list', 0);


   $uri = 'src/compose.php' 
        . '?mailbox=' . urlencode($mailbox) 
        . '&amp;startMessage=' . $startMessage 
        . '&amp;passed_id=';


   if ($javascript_on && $compose_new_win)
   {
      $reply_script = ' onClick="passed_id = \'\'; for (i=0; i<document.forms[0].elements.length; i++) if (document.forms[0].elements[i].type == \'checkbox\' && document.forms[0].elements[i].checked) { passed_id = document.forms[0].elements[i].value; break; } if (passed_id != \'\') comp_in_new(\'' . $base_uri . $uri . '\' + passed_id + \'&amp;smaction=reply\'); return false;"';
      $reply_all_script = ' onClick="passed_id = \'\'; for (i=0; i<document.forms[0].elements.length; i++) if (document.forms[0].elements[i].type == \'checkbox\' && document.forms[0].elements[i].checked) { passed_id = document.forms[0].elements[i].value; break; } if (passed_id != \'\') comp_in_new(\'' . $base_uri . $uri . '\' + passed_id + \'&amp;smaction=reply_all\'); return false;"';
   }
   else
   {
      $reply_script = '';
      $reply_all_script = '';
   }


   if ($show_reply_button || $show_reply_all_button)
      echo ' ';


   // stay in SquirrelMail gettext domain, since these strings are well known
   //
   if ($show_reply_button)
      echo '<input type="submit" name="replybtn" value="' . _("Reply") . '"' . $reply_script . '>';

   if ($show_reply_all_button)
      echo '<input type="submit" name="replyallbtn" value="' . _("Reply All") . '"' . $reply_all_script . '>';

}



/**
  * Redirects to compose page when button was pressed for 
  * SquirrelMail 1.4.x and below
  *
  */
function rb_reply_action_14_do()
{

   if (check_sm_version(1, 5, 0))
      return;

   rb_reply_action();

}



/**
  * Redirects to compose page when button was pressed for
  * SquirrelMail 1.5.x and above
  *
  */
function rb_reply_action_15_do()
{

   if (!check_sm_version(1, 5, 0))
      return;

   rb_reply_action();

}



/**
  * Redirects to compose page when button was pressed
  *
  */
function rb_reply_action()
{

   global $compose_new_win, $javascript_on, $mailbox, $passed_id, 
          $passed_ent_id, $startMessage, $base_uri, $msg;


   sqgetGlobalVar('msg', $msg, SQ_FORM);


   if (empty($msg))
      return;


   $uri = $base_uri . 'src/compose.php' 
        . '?mailbox=' . urlencode($mailbox) 
        . '&startMessage=' . $startMessage 
        . '&passed_id=';


// there's not a good way to do this in pure HTML, so 
// just forget it for now unless someone else can think
// of something
//   if (!$javascript_on && $compose_new_win)
//      $uri = SM_PATH . 'plugins/reply_button/blah.php';


   if (sqgetGlobalVar('replybtn', $replybtn, SQ_FORM) && !empty($replybtn))
   {
      $uri = $uri . array_shift($msg) . '&smaction=reply';
      header('Location: ' . $uri);
      exit;
   }


   else if (sqgetGlobalVar('replyallbtn', $replyallbtn, SQ_FORM) && !empty($replyallbtn))
   {
      $uri = $uri . array_shift($msg) . '&smaction=reply_all';
      header('Location: ' . $uri);
      exit;
   }

}



?>
