<?php
   /*
    *  quota_usage
    *  By Bill Shupp <hostmaster@shupp.org>
    *  (c) 2001 (GNU GPL - see ../../COPYING)
    *
    */





   function squirrelmail_plugin_init_quota_usage() {
       global $squirrelmail_plugin_hooks;
       $squirrelmail_plugin_hooks["left_main_before"]["quota_usage"] = "display_quota_usage_left";
   }

   function display_quota_usage_left() {
      global $username, $key, $imapServerAddress, $imapPort, $imap,
         $imap_general, $filters, $imap_stream, $imapConnection, 
         $UseSeparateImapConnection;

      // Detect if we have already connected to IMAP or not.
      // Also check if we are forced to use a separate IMAP connection
      if ((!isset($imap_stream) && !isset($imapConnection)) ||
          $UseSeparateImapConnection) {
         $stream = sqimap_login($username, $key, $imapServerAddress, 
            $imapPort, 10);
         $previously_connected = false;
      } elseif (isset($imapConnection)) {
         $stream = $imapConnection;
         $previously_connected = true;
      } else {
         $previously_connected = true;
         $stream = $imap_stream;
      }


      $fontsize = "-2";
      $warn_percent = 80;

      $usage = sqimap_get_quota($stream, "INBOX");
      if(!ereg("NOQUOTA", $usage)) {
         $usagearray = explode(":", $usage);
         $taken = $usagearray[0];
         $total = $usagearray[1];
         $percent = number_format(($taken/$total) * 100, 1);
         $quota = number_format((($total *1024) - 1023) / 1000000, 1);

         if($percent >= $warn_percent) $fontcolorstring = " color=#FF0000";
         echo "<center><font size=$fontsize>current usage:<br>\n";
         echo "<table border=0 cellpadding=2>\n";
         echo " <tr bgcolor=#cccccc>\n";
         echo "  <td><font size=$fontsize $fontcolorstring><b>".$percent."% of ".$quota."M</b></font>\n";
         echo " </tr>\n";
         echo "</table>\n";
         echo "</font></center><p>\n";
      }
      
      if (!$previously_connected)
         sqimap_logout($stream);

   }

   /******************************************************************************
    **  Gets current quota usage
    ******************************************************************************/
   function sqimap_get_quota ($imap_stream, $mailbox) {
      if (check_quota_capability($imap_stream, "QUOTA")) {
        fputs ($imap_stream, "a001 GETQUOTAROOT \"$mailbox\"\r\n");
        $read_ary = sqimap_read_data ($imap_stream, 'a001', true, $result, $message);
        for ($i = 0; $i < count($read_ary); $i++) {
            if (ereg("STORAGE", $read_ary[$i])) {
                $tempusage = ereg_replace("^.*[(]STORAGE +(.*)[)].*$", "\\1", $read_ary[$i]);
                $usagearray = explode(" ", $tempusage);
                return $usagearray[0].":".$usagearray[1];
            }
        }
      }
      return "NOQUOTA";
   }

   function check_quota_capability($imap_stream, $capability) {
        global $imap_general_debug;

        fputs ($imap_stream, "a001 CAPABILITY\r\n");
        $read_ary = sqimap_read_data($imap_stream, 'a001', true, $a, $b);

        for($i = 0; $i < count($read_ary); $i++) {
            if (ereg("QUOTA", $read_ary[$i]))
                return TRUE;
        }
        return false;

    }

?>
