<?php

/**
  * SquirrelMail Password Forget Plugin
  * Copyright (c) 2003-2011 Paul Lesniewski <paul@squirrelmail.org>
  * Copyright (c) 2000-2001 Tyler Akins
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage password_forget
  *
  */



/**
  * Register this plugin with SquirrelMail
  *
  */
function squirrelmail_plugin_init_password_forget()
{

   global $squirrelmail_plugin_hooks;


   // inserts obfuscated password field (1.4.x)
   //
   $squirrelmail_plugin_hooks['login_top']['password_forget']
      = 'password_forget_pre_stub';


   // inserts obfuscated password field (1.5.x)
   //
   $squirrelmail_plugin_hooks['template_construct_login.tpl']['password_forget']
      = 'password_forget_pre_stub';


   // changes input tags, adding autocomplete="off" attribute (1.4.x)
   //
   $squirrelmail_plugin_hooks['login_form']['password_forget']
      = 'password_forget_pre_part_2_stub';


   // decyphers obfuscated password field
   //
   $squirrelmail_plugin_hooks['login_before']['password_forget']
      = 'password_forget_post_stub';


   // configuration check
   //
   $squirrelmail_plugin_hooks['configtest']['password_forget']
      = 'password_forget_check_configuration_stub';

}



/**
  * Returns info about this plugin
  *
  */
function password_forget_info()
{

   return array(
                 'english_name' => 'Password Forget',
                 'authors' => array(
                    'Tyler Akins' => array(),
                    'Paul Lesniewski' => array(
                       'email' => 'paul@squirrelmail.org',
                       'sm_site_username' => 'pdontthink',
                    ),
                 ),
                 'version' => '2.3',
                 'required_sm_version' => '1.0.1',
                 'requires_configuration' => 0,
                 'requires_source_patch' => 0,
                 'required_plugins' => array(),
                 'summary' => 'Prevents browsers from remembering input to the username and password fields in order to prevent malicious persons recalling previous login credentials on public terminals.',
                 'details' => 'Many web browsers provide the capability to store all usernames and passwords entered on any web site.  Especially on public-access computers, this could pose the risk of stolen user login credentials.<br /><br />This plugin provides a workaround for this vulnerability, wherein the name of the username and password input fields is changed randomly every time the SquirrelMail login page is displayed.  The browser is also asked specifically not to cache these fields.<br /><br />Please note that in some cases, the browser may still remember user credentials (perhaps on some older or more obscure browsers), however the chances that a same-named username or password field would be displayed again on that computer are very small.<br /><br />The administrator may, if desired, specify a list of "known clients" for which this functionality will be disabled (for the case when some users should be allowed to harness this browser feature to their benefit when at their home computers).',
               );

}



/**
  * Returns version info about this plugin
  *
  */
function password_forget_version()
{
   $info = password_forget_info();
   return $info['version'];
}



/**
  * Inserts obfuscated password field
  *
  */
function password_forget_pre_stub() 
{
   include_once(SM_PATH . 'plugins/password_forget/functions.php');
   return password_forget_pre();
}



/**
  * Changes input tags, adding autocomplete="off" attribute (1.4.x)
  *
  */
function password_forget_pre_part_2_stub() 
{
   include_once(SM_PATH . 'plugins/password_forget/functions.php');
   return password_forget_pre_part_2();
}



/**
  * Decyphers obfuscated password field
  *
  */
function password_forget_post_stub() 
{
   include_once(SM_PATH . 'plugins/password_forget/functions.php');
   password_forget_post();
}



/**
  * Validate that this plugin is configured correctly
  *
  * @return boolean Whether or not there was a
  *                 configuration error for this plugin.
  *
  */
function password_forget_check_configuration_stub()
{
   include_once(SM_PATH . 'plugins/password_forget/functions.php');
   return password_forget_check_configuration();
}



