<?php

/*******************************************************************************

    Author ....... Jonathan S. Earle
    Contact ...... plugins@kronos.honk.org
    Home Site .... http://kronos.honk.org/~earlej/
    Program ...... Ottawa Gas Prices
    Version ...... 1.0.1
    Purpose ...... Displays a graphic from www.ottawagasprices.com listing the current 
				   gas prices in town.  Clicking on the image takes you to the parent site.
    Note ......... This requires the left pane to be 187 pixels wide to avoid a horiz scroll bar.
                   This plugin sets the minimum size to be 187.  You can gain some space by setting
                   leftmargin=0 in the <body> tag of ../../src/left_main.php, and changing 187 to 179
                   (in ottawagasprices_save_options() below).

*******************************************************************************/

function squirrelmail_plugin_init_ottawagasprices()
{
    global $squirrelmail_plugin_hooks;

    $squirrelmail_plugin_hooks["left_main_before"]["ottawagasprices"] = "ottawagasprices_show_above";
    $squirrelmail_plugin_hooks["left_main_after"]["ottawagasprices"] = "ottawagasprices_show_below";
    $squirrelmail_plugin_hooks["options_folder_inside"]["ottawagasprices"] = "ottawagasprices_show_options";
    $squirrelmail_plugin_hooks["options_folder_save"]["ottawagasprices"] = "ottawagasprices_save_options";
    $squirrelmail_plugin_hooks["loading_prefs"]["ottawagasprices"] = "ottawagasprices_load_options";

    return;
}

function show_ottawagasprices()
{
    global $ottawagasprices_position;

    if ($ottawagasprices_position)
    {
        // The OttawaGasPrices.com website has a little watcher javascript applet that displays the latest
        // prices in the city.  Unfortunately, it has links that open in the same browser window (meaning,
        // it would display in your original SM window.) Further, some folks may not have javascript
        // enabled in their browsers.  Let's fix all that!

        $site = "ottawagasprices.com";
        $port = 80;
        $url = "/watcher/watcher.js";

        $httpsock = fsockopen($site, $port);

        if (!$httpsock) return;

        $request  = "GET " . $url . " HTTP/1.0\r\n";
        $request .= "Host: " . $site . "\r\n";
        $request .= "Accept: */*\r\n";
        $request .= "\r\n\r\n";

        fwrite($httpsock, $request);
        $data = "";

        while (!feof($httpsock)) {
            $data .= fread($httpsock, 1024);
        }

        // Get just the data block which starts with "<table ... ".
        $temp = strstr($data, "<table");
        $block = substr($temp, 0, strlen($temp) - 4);   // Lose the `");\n' at the end of the original javascript.

        // Set hrefs to open a new page.
        $block = str_replace("href", "target=\"_new\" href", $block);

        // Convert escaped quotes in the javascript code to regular quotes.
        $block = str_replace("\\\"", "\"", $block);
        $block = str_replace("\\'", "'", $block);

        // Print out the fixed block with a blank line preceeding.
        print "<br>" . $block . "\n";
    }

    return;
}


function ottawagasprices_show_above()
{
	global $ottawagasprices_position;

	if ($ottawagasprices_position == 'above')
		show_ottawagasprices();

	return;
}


function ottawagasprices_show_below()
{
	global $ottawagasprices_position;

	if ($ottawagasprices_position == 'below')
		show_ottawagasprices();

	return;
}

function ottawagasprices_show_options()
{
    global $ottawagasprices_position, $username;

	// Screen position
    print '
         <tr>
            <td align=right>Ottawa Gas Prices Position:</td>
            <td>
               <select name="ottawagasprices_position_in">
    ';

    $sel = '';
    if ($ottawagasprices_position == 'above')
        $sel = ' selected';

    print "<option value=above".$sel.">Above folder list\n";

    $sel = '';
    if ($ottawagasprices_position == 'below' || $ottawagasprices_position == '')
        $sel = ' selected';

    print "<option value=below".$sel.">Below folder list\n";


    print '
               </select>
            </td>
         </tr>
    ';

	print '<tr><td COLSPAN="2">&nbsp;</td></tr>';

    return;
}

function ottawagasprices_save_options()
{
    global $data_dir, $username, $left_size_values;

    setPref($data_dir, $username, 'ottawagasprices_position', $_POST['ottawagasprices_position_in']);

    if ($left_size_values < 187)
        setPref($data_dir, $username, 'left_size', '187');

    return;
}

function ottawagasprices_load_options()
{
    global $ottawagasprices_position, $username, $data_dir;

    $ottawagasprices_position = getPref($data_dir, $username, 'ottawagasprices_position');

    return;
}

?>
