<?php

/**
  * SquirrelMail One-Time Password Plugin
  * Copyright (c) 2008-2009 Paul Lesniewski <paul@squirrelmail.org>
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage otp
  *
  */



/**
  * Register this plugin with SquirrelMail
  *
  */
function squirrelmail_plugin_init_otp()
{

   global $squirrelmail_plugin_hooks;


   // make sure Password Forget fires first; also
   // override any configuration values to restrict
   // users logged in with a temporary password
   //
   $squirrelmail_plugin_hooks['prefs_backend']['otp']
      = 'otp_config_override';


   // allow removal of certain options on
   // various options pages
   //
   $squirrelmail_plugin_hooks['optpage_loadhook_display']['otp']
      = 'otp_remove_options';
   $squirrelmail_plugin_hooks['optpage_loadhook_personal']['otp']
      = 'otp_remove_options';
   $squirrelmail_plugin_hooks['optpage_loadhook_folder']['otp']
      = 'otp_remove_options';
   $squirrelmail_plugin_hooks['optpage_loadhook_highlight']['otp']
      = 'otp_remove_options';
   $squirrelmail_plugin_hooks['optpage_loadhook_order']['otp']
      = 'otp_remove_options';
   $squirrelmail_plugin_hooks['optpage_loadhook_compose']['otp']
      = 'otp_remove_options';


   // check if a OTP is being used to log in
   //
   $squirrelmail_plugin_hooks['login_before']['otp']
      = 'otp_validate_login';


   // put OTP block on options page; also
   // remove other option blocks when needed
   //
   $squirrelmail_plugin_hooks['optpage_register_block']['otp']
      = 'otp_option_block';


   // set up custom options page
   //
   $squirrelmail_plugin_hooks['optpage_set_loadinfo']['otp']
      = 'otp_setup_options_page';


   // configuration check
   //
   $squirrelmail_plugin_hooks['configtest']['otp']
      = 'otp_check_configuration';

}



/**
  * Returns info about this plugin
  *
  */
function otp_info()
{

   return array(
                 'english_name' => 'One-Time Password',
                 'authors' => array(
                    'Paul Lesniewski' => array(
                       'email' => 'paul@squirrelmail.org',
                       'sm_site_username' => 'pdontthink',
                    ),
                 ),
                 'version' => '1.0',
                 'required_sm_version' => '1.4.18',
                 'requires_configuration' => 1,
                 'requires_source_patch' => 0,
                 'required_plugins' => array(
                    'compatibility' => array(
                       'version' => '2.0.9',
                       'activate' => FALSE,
                    )
                 ),
                 'summary' => 'Allows users to create a list of usernames and/or passwords that will work one time only so that if stolen during login, would pose no security risk.',
                 'details' => 'This plugin is intended to decrease the risk of usernames and/or passwords being stolen when users log in to their accounts from untrusted locations.  Users can create a list of usernames and/or passwords that will work one time only so that if stolen (during or after the login process), they would pose no security risk.<br /><br />However, there are certain security tradeoffs associated with this functionality, so please be sure to read and understand the security information in the documentation.<br /><br />Amongst other configurable settings, the administrator can decide to disable certain parts of the SquirrelMail interface when a user is logged in using a one-time password.',
               );

}



/**
  * Returns version info about this plugin
  *
  */
function otp_version()
{
   $info = otp_info();
   return $info['version'];
}



/**
  * Make sure Password Forget fires first;
  * also override any configuration values
  * to restrict users logged in with a temporary
  * password
  *
  */
function otp_config_override()
{
   include_once(SM_PATH . 'plugins/otp/functions.php');
   otp_config_override_do();
}



/**
  * Check if a OTP is being used to log in
  *
  */
function otp_validate_login() 
{
   include_once(SM_PATH . 'plugins/otp/functions.php');
   return otp_validate_login_do();
}



/**
  * Put OTP block on options page; also
  * remove other option blocks when needed
  *
  */
function otp_option_block() 
{
   include_once(SM_PATH . 'plugins/otp/functions.php');
   otp_option_block_do();
}



/**
  * Allow removal of certain options on
  * various options pages
  *
  */
function otp_remove_options()
{
   include_once(SM_PATH . 'plugins/otp/functions.php');
   otp_remove_options_do();
}



/**
  * Set up custom options page
  *
  */
function otp_setup_options_page()
{
   include_once(SM_PATH . 'plugins/otp/functions.php');
   otp_setup_options_page_do();
}



/**
  * Validate that this plugin is configured correctly
  *
  * @return boolean Whether or not there was a
  *                 configuration error for this plugin.
  *
  */
function otp_check_configuration()
{
   include_once(SM_PATH . 'plugins/otp/functions.php');
   return otp_check_configuration_do();
}



