<?php

/**
  * SquirrelMail One-Time Password Plugin
  * Copyright (c) 2008-2009 Paul Lesniewski <paul@squirrelmail.org>
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage otp
  *
  */

   global $otp_password_length, $otp_strict_order, $otp_max_at_once,
          $otp_password_chars, $otp_locked_out_config,
          $otp_locked_out_option_pages, $otp_locked_out_plugins,
          $otp_locked_out_options, $otp_crypto_hash_phrase,
          $otp_crypto_algorithm, $otp_usernames, $otp_username_length,
          $otp_username_chars, $otp_prefix;



   // Although it is STRONGLY RECOMMENED that you specify
   // your cryptographic configuration settings in a more
   // secure manner (see step two in the INSTALL file),
   // if you are not able to do so, you may specify the
   // cryptographic hash phrase and algorithm here.
   //
   // Please read the security documentation in the README file.
   //
   // WARNING: If you do not specify your cryptographic
   //          settings elsewhere, MAKE SURE to change
   //          the hash phrase here!
   //
   $otp_crypto_hash_phrase = 'Llama';
   $otp_crypto_algorithm = 'rc4_builtin';



   // When users log in with a one-time password, you can
   // require that they prefix it with a system-wide string
   // that you have conveyed to them separately.  If users
   // memorize it and don't write it down with their OTP list,
   // an attacker won't be able to use the OTP list to log in.
   //
   // Just like the cryptographic configuration settings, it
   // is STRONGLY RECOMMENDED that (if you use this feature)
   // you specify this value in a more secure manner (see
   // step two in the INSTALL file).
   //
   // Leave this empty to disable the use of password prefixes.
   //
   $otp_prefix = '';



   // In addition to one-time passwords, it is also possible
   // for one-time usernames to be generated as well.
   // Setting this to 1 will enable one-time usernames, setting
   // it to 0 (zero) will indicate that only one-time passwords
   // should be generated.
   //
   $otp_usernames = 0;



   // How long should auto-generated passwords be?
   //
   $otp_password_length = 8;



   // How long should auto-generated usernames be?
   // This is only applicable when $otp_usernames
   // is enabled.
   //
   $otp_username_length = 8;



   // Must users use their passwords in order?  This
   // is more secure, but users who lose, damage
   // or confuse their password list may be unable
   // to log in without using their real password.
   //
   // 0 = users can log in using any of their
   //     one-time passwords at any time
   // 1 = users must use their passwords in
   //     the order given to them
   //
   $otp_strict_order = 1;



   // What is the maximum number of unused passwords
   // a user is allowed to have at once?
   //
   $otp_max_at_once = 10;



   // This is the list of possible characters for use in
   // building temporary passwords.  The default was crafted
   // to eliminate confusion beween certain letters/numbmers
   // such as (number) 1 and (letter) l or (number) 0 and
   // (letter) o and (letter) O.
   //
   // The three characters ; and | and @ are used internally
   // and will be ignored herein.
   //
   $otp_password_chars = 'abcdefghjkmnpqrstuvwxyzABCDEFGHIJKLMNPQRSTUVWXYZ23456789';



   // This is the list of possible characters for use in
   // building temporary usernames.  The default was crafted
   // to eliminate confusion beween certain letters/numbmers
   // such as (number) 1 and (letter) l or (number) 0 and
   // (letter) o and (letter) O.  This is only applicable
   // when $otp_usernames is enabled.
   //
   // The three characters ; and | and @ are used internally
   // and will be ignored herein.
   //
   $otp_username_chars = 'abcdefghjkmnpqrstuvwxyzABCDEFGHIJKLMNPQRSTUVWXYZ23456789';



   // When a user is logged in using a one-time password,
   // what configuration values from the main SquirrelMail
   // configuration file should be changed?  You can create
   // an arbitrary list of configuration variable names
   // and the value that should be used when a user is logged
   // in with a one-time password.
   //
   $otp_locked_out_config = array(
      'edit_identity' => FALSE,
      'edit_name' => FALSE,
   );



   // When a user is logged in using a one-time password,
   // what plugins should be deactivated?  You can create
   // a list of those plugins here.
   //
   // Please send suggestions for improving this list
   // to squirrelmail-plugins@lists.sourceforge.net
   //
   $otp_locked_out_plugins = array(
      'administrator',
      'bug_report',
      'change_password',
      'change_passwd',
      'change_sqlpass',
      'file_manager',
      'info',
      'local_autorespond_forward',
      'login_alias',
      'reset_prefs',
      'vadmin',
   );



   // When a user is logged in using a one-time password,
   // what option page blocks (on the main SquirrelMail Options
   // page) should be removed?  You can create a list of those
   // pages here.
   //
   // In SquirrelMail 1.4.x, these are applicable:
   //
   // 0 = Personal Information
   // 1 = Display Preferences
   // 2 = Message Highlighting
   // 3 = Folder Preferences
   // 4 = Index Order
   // 
   // From 5 onward are plugin blocks - you should use
   // $otp_locked_out_plugins (see above) instead.
   //
   // In SquirrelMail 1.5.x, these are applicable:
   //
   // 0 = Personal Information
   // 1 = Display Preferences
   // 2 = Message Highlighting
   // 3 = Folder Preferences
   // 4 = Index Order
   // 5 = Compose Preferences
   //
   // From 6 onward are plugin blocks - you should use
   // $otp_locked_out_plugins (see above) instead.
   //
   $otp_locked_out_option_pages = array(
      0,
      3,
   );



   // When a user is logged in using a one-time password,
   // what option page elements should be removed?  You can
   // create a list of those here.
   //
   // What follows is a list of most of the core options
   // names that you can disable.  This list may be slightly
   // out of date; please send any updates to
   // squirrelmail-plugins@lists.sourceforge.net
   //
   //   Display Preferences
   //      chosen_theme
   //      custom_css
   //      language
   //      javascript_setting
   //      js_autodetect_results
   //      show_num
   //      alt_index_colors
   //      page_selector
   //      page_selector_max
   //      show_full_date
   //      wrap_at 
   //      editor_size
   //      editor_height
   //      location_of_buttons
   //      use_javascript_addr_book
   //      show_html_default
   //      enable_forward_as_attachment
   //      forward_cc
   //      include_self_reply_all
   //      show_xmailer_default
   //      attachment_common_show_images 
   //      pf_cleandisplay
   //      mdn_user_support
   //      compose_new_win
   //      compose_width
   //      compose_height
   //      sig_first
   //      reply_focus
   //      internal_date_sort
   //      sort_by_ref
   //
   //   Folder Preferences
   //      folder_prefix
   //      trash_folder
   //      sent_folder
   //      draft_folder
   //      location_of_bar 
   //      left_size 
   //      left_refresh
   //      unseen_notify
   //      unseen_type
   //      collapse_folders 
   //      unseen_cum
   //      date_format 
   //      hour_format
   //      search_memory
   //      mailbox_select_style
   //      translate_special_folders (only in 1.5.x)
   //      save_reply_with_orig (only in 1.5.x)
   //      show_only_subscribed_folders (only in 1.5.x)
   //        
   //   Personal Preferences
   //      full_name 
   //      email_address
   //      reply_to
   //      signature
   //      identities_link
   //      timezone
   //      reply_citation_style
   //      reply_citation_start
   //      reply_citation_end
   //      use_signature
   //      prefix_sig
   //
   //
   $otp_locked_out_options = array(
      'full_name',
      'email_address',
      'reply_to',
      'signature',
      'identities_link',
      'timezone',
      'reply_citation_style',
      'reply_citation_start',
      'reply_citation_end',
      'use_signature',
      'prefix_sig',
      'folder_prefix',
      'trash_folder',
      'sent_folder',
      'draft_folder',
      'location_of_bar',
      'left_size',
      'left_refresh',
      'unseen_notify',
      'unseen_type',
      'collapse_folders',
      'unseen_cum',
      'date_format',
      'hour_format',
      'search_memory',
      'mailbox_select_style',
      'translate_special_folders',
      'save_reply_with_orig',
      'show_only_subscribed_folders',
   );



