<?php
/*******************************************************************************

    Author ......... Jimmy Conner
    Contact ........ jimmy@advcs.org
    Home Site ...... http://advcs.org
    Program ........ Notes
    Version ........ 1.0
    Purpose ........ Storing Notes

*******************************************************************************/


$n = new Notes;
/* Path for SquirrelMail required files. */

chdir("..");
if (!defined('SM_PATH'))
   define('SM_PATH','../');

if (file_exists(SM_PATH . 'include/validate.php')) {
   include_once(SM_PATH . 'include/validate.php');
} else {
   if (file_exists(SM_PATH . 'src/validate.php'))
      include_once(SM_PATH . 'src/validate.php');
}

include_once(SM_PATH . "plugins/notes/config.php");

if (function_exists('sqgetGlobalVar')) {
   sqgetGlobalVar('submit', $submit);
   sqgetGlobalVar('title', $title);
   sqgetGlobalVar('note', $note);
   sqgetGlobalVar('view', $view);
   sqgetGlobalVar('edit', $edit);
   sqgetGlobalVar('delete', $delete);
   sqgetGlobalVar('editnote', $editnote);
} else {
   sqextractGlobalVar('submit');
   sqextractGlobalVar('title');
   sqextractGlobalVar('note');
   sqextractGlobalVar('view');
   sqextractGlobalVar('edit');
   sqextractGlobalVar('delete');
   sqextractGlobalVar('editnote');
}

if ($submit != '')
   $submit = strip_tags($submit);
if ($title != '')
   $title = strip_tags($title);
if ($note != '')
   $note = strip_tags($note);
if ($view != '')
   $view = strip_tags($view);
if ($edit != '')
   $edit = strip_tags($edit);
if ($delete != '')
   $delete = strip_tags($delete);
if ($editnote != '')
   $editnote = strip_tags($editnote);

$n->Init();

if ($delete != ""){
   $n->Delete($delete);
   header("Location: notes.php");
}

if ($submit == 'Save Note' && $n->error < 3){
   $n->Save($editnote, $title, $note);
   header("Location: notes.php");
}

if ($submit == 'Submit Note'){
   $n->Add($title, $note);
   header("Location: notes.php");
}

displayPageHeader($color, "None");

if ($edit != '')
   $n->EditNote($edit);

if ($submit == 'Save Note')
   $submit = '';

if ($submit == 'view')
   $n->ShowNote($view);

if ($submit == '') {
   $n->DisplayList();
}  else if ($submit == 'Add a Note'){
   $n->ShowAdd();
}
echo '</body></html>';
exit;

class Notes {

   var $totalnotes = 0;
   var $maxnotescount = 0;
   var $maxnotesize = 0;
   var $maxnotessize = 0;
   var $error = 0;
   var $file = "";
   var $filesize = 0;
   var $rfilesize = 0;
   var $notes = array();
   var $hashed_dir = '';

   function Init() {
      global $data_dir, $username;
      $this->hashed_dir = getHashedDir($username, $data_dir);
      if (!file_exists("$this->hashed_dir/$username.notes")){
         $file = @fopen("$this->hashed_dir/$username.notes",w);
         fclose($file);
      }
      clearstatcache();
      $this->File();
      $this->FileSize();
      $this->GetNotes();
      $this->TotalNotes();
      $this->TotalSize();
      $this->CheckforErrors();
   }

   function Add($title = "(No Title)", $note = "(No Note)") {
      $date = date("F j, Y");
      $title = str_replace("\n","<br>", $title);
      $note = str_replace("\n","<br>", $note);
      $this->notes[$this->notescount]= $date . "|NOTES|" . $title . "|NOTES|" . $note;
      $file = @fopen($this->file,w);
      $this->WriteNotes();
   }

   function Delete($num) {
      $this->notes[$num] = "";
      $this->WriteNotes();
   }

   function Save($editnote, $title = '(No Title)', $note = '(No Note)') {
      $date = date("F j, Y");
      $title = str_replace("|NOTES|","[NOTES]",$title);
      $note = str_replace("|NOTES|","[NOTES]",$note);   
      $title = str_replace("\n","<br>", $title);
      $note = str_replace("\n","<br>", $note);
      $this->notes[$editnote]= $date . "|NOTES|" . $title . "|NOTES|" . $note;
      $this->WriteNotes();
   }

   function File() {
      global $username;
      $this->file = "$this->hashed_dir/$username.notes";
   }

   function FileSize() {
      $this->filesize = @filesize($this->file);
   }

   function GetNotes() {
      $file = @fopen($this->file,r);
      $notes = @fread($file ,$this->filesize);
      @fclose($file);
      $this->notes = explode("\n", $notes);
   }

   function TotalSize() {
      $this->size = $this->filesize - ($this->notescount * 15);
   }

   function TotalNotes() {
      $this->notescount = count($this->notes);
      $this->notescount--;
   }

   function WriteNotes() {
      $this->TotalNotes();
      $file = @fopen($this->file,w);
      $count=-1;
      while ($count < $this->notescount){
         $count++;
         if ($this->notes[$count] != '')
            @fputs($file, $this->notes[$count] . "\n");
      }
      @fclose($file);
   }

   function ShowNote ($view) {
      global $color;
      $note = explode("|NOTES|", $this->notes[$view]);
      $date = $note[0];
      $title = $note[1];
      $text = $note[2];
      print "<br><br><center><table width=\"60%\" border=1 bgcolor='$color[9]'><tr><td>\n";
      print "<table width=\"100%\"><tr><td align=left><a href='notes.php?edit=$view'>Edit</a></td><td align=right><a href='notes.php?delete=$view'>Delete</a></td></tr></table>\n";
      print "<table width=\"100%\" bgcolor='$color[4]'><tr><td>$title</td></tr>\n";
      print "<tr><td>$date</td></tr>\n";
      print "<tr><td><hr width='100%' color='$color[9]'></td></tr>\n";
      print "<tr><td><br>$text</td></tr></table>\n";
      print "</td></tr></table></center>\n";
   }

   function DisplayError () {
      if ($this->error == 5)
         print "<center>Note exceeds the maximum overall size!!</center>\n";
      if ($this->error == 6)
         print "<center>Note exceeds the maximum note size!!</center>\n";
      if ($this->error == 7)
         print "<center>Note exceeds the maximum overall size!!</center>\n";
   }

   function CheckforErrors() {
      global $submit, $title, $note, $edit, $editnote;
      $date = date("F j, Y");
         $olddate = '';
         $oldtitle = '';
         $oldtext = '';
      if (isset($edit)) {
         $oldnote = explode("|NOTES|", $this->notes[$edit]);
         $olddate = $oldnote[0];
         $oldtitle = $oldnote[1];
         $oldtext = $oldnote[2];
      }
      if ($this->maxnotescount > 0 && $this->notescount > $this->maxnotescount-1)
         $this->error=2;
      if ($this->maxnotessize > 0 && $this->maxnotessize < $this->size)
         $this->error = 4;
      if ($this->maxnotessize > 0 && $this->maxnotessize < ($this->size + strlen($title . $date . $note)) && $submit == 'Submit Note')
         $this->error = 5;
      if ($this->maxnotesize > 0 && $this->maxnotesize < strlen($title . $date . $note))
         $this->error = 6;
      if ($this->maxnotessize > 0 && $this->maxnotessize < ($this->size + strlen($title . $date . $note) - strlen($oldtitle . $olddate . $oldtext)) && $submit == 'Save Note')
         $this->error = 7;
      if (($submit == 'Submit Note' || $submit == 'Add a Note') && ($this->error == 1 || $this->error == 2))
         $submit = '';
      if ($submit == 'Add a Note' && $this->error == 4)
         $submit = '';
      if ($submit == 'Submit Note' && ($this->error == 5 || $this->error == 6))
        $submit = "Add a Note";
      if ($editnote != '' && ($this->error == 5 || $this->error == 6)){
        $edit = $editnote;
        $submit = '';
      }
   }

   function EditNote($edit) {
      global $submit, $note, $title, $date;
      print "<h3><center>Edit a Note</center></h3>\n";
      if ($this->error != 6 && $this->error != 5) {
         $note = explode("|NOTES|", $this->notes[$edit]);
         $date = $note[0];
         $title = $note[1];
         $text = $note[2];
      } else {
         $text = $note;
      }
      $title = str_replace("<br>","\n",$title);
      $text = str_replace("<br>","\n",$text);
      $this->DisplayError();
      print "<form method=post><center><table><tr><td><input type=text name=title value='$title'></td></tr>\n";
      print "<tr><td><TEXTAREA NAME=note ROWS=8 COLS=50>$text</TEXTAREA></td></tr>\n";
      print "<tr><td><input type=hidden name=editnote value='$edit'><input type=hidden name=date value='$date'><input type=submit name=submit value='Save Note'></td></tr>\n";
      print "</table></center></form>\n";
      $submit = "editting";
   }

   function DisplayList() {
      global $color;
      $date = date("F j, Y");
      print "\n<br><br><center><table width=\"90%\" border=1 bordercolor='$color[10]' bgcolor='$color[9]'><tr><td width=120><center>Date</center></td><td colspan=2 width=350><center>Title</center></td><td><center>Size</center></td><td width=90>&nbsp;</td></tr>\n";
      $count = 0;
      while ($count <> $this->notescount){
         $note = explode("|NOTES|", $this->notes[$count]);
         $date = $note[0];
         $title = $note[1];
         $notesize = strlen($this->notes[$count]) - 14;
         print "<tr bgcolor='$color[4]'><td bgcolor='$color[4]'>&nbsp;$date</td><td colspan=2 bgcolor='$color[4]'>&nbsp;<a href='notes.php?submit=view&view=$count'>$title</a></td><td bgcolor='$color[4]' align=right>$notesize bytes</td><td bgcolor='$color[4]'><center><a href='notes.php?edit=$count'>Edit</a> | <a href='notes.php?delete=$count'>Delete</a></center></td></tr>\n";
         $count++;
      }
      if ($this->notescount == 0)
         print "<tr><td colspan=5 bgcolor='$color[4]'><center>You don't have any notes stored.</center></td></tr>\n";
      $file = @fopen($this->file,r);
      @fclose($file);

      if ($this->maxnotessize > 0)
         print "<tr><td><center>$this->notescount" . ($this->maxnotescount > 0 ? " / $this->maxnotescount" : '') . " Notes</center></td><td colspan=2>&nbsp;</td><td><center>$this->size / $this->maxnotessize Bytes</center></td><td>&nbsp;</td></tr>\n";
      else
         print "<tr><td><center>$this->notescount" . ($this->maxnotescount > 0 ? " / $this->maxnotescount" : '') . " Notes</center></td><td colspan=2>&nbsp;</td><td><center>$this->size Bytes</center></td><td>&nbsp;</td></tr>\n";
      print "</table></center><br><br>\n";
      if ($this->error == 0 && ($this->maxnotessize == 0 || $this->maxnotessize > $this->size))
         print "<center><form method=post><input type=submit name=submit value='Add a Note'></form></center>\n";
   }

   function ShowAdd() {
      global $title, $note;
      print "<h3><center>Add a Note</center></h3>\n";
      $this->DisplayError();
      if ($title == "")
         $title = "Title";
      print "<form method=post><center><table><tr><td><input type=text name=title value='$title'></td></tr>\n";
      print "<tr><td><TEXTAREA NAME=note ROWS=8 COLS=50>\n";
      print $note;
      print "\n</TEXTAREA>\n";
      print "<tr><td><input type=submit name=submit value='Submit Note'></td></tr>\n";
      print "</table></center></form>\n";
   }
}

?>