<?php


  // Global Variables, don't touch these unless you want to break the plugin
  //
  global $IMAPSelections, $rememberServer;



  // this will place a checkbox on the login page that allows 
  // the user to tell SquirrelMail to remember her last login server
  //
  $rememberServer = 1;



  // this is a listing of IMAP servers you offer and their 
  // corresponding server settings to be used when a user 
  // logs in using the IMAP pull-down selection menu.  Each 
  // server may have any number of settings associated with 
  // it; most any setting available in SquirrelMail's 
  // config/config.php is allowable.
  //
  $IMAPSelections = array(

      'Local Host' => array(
          'imapServerAddress' => 'localhost',
          'imapPort'          => '143',
      ),

      'My Other Server' => array(
          'imapServerAddress' => 'myotherserver.com',
          'imapPort'          => '143',
          'org_title'         => 'Your Mail',
          // NOTE - if your usernames do NOT include domain name,
          //        you should define separate data directories,
          //        else user preference files will be shared across
          //        all servers for the same usernames!
          'data_dir'          => '/var/lib/squirrelmail/otherserver/data',
      ),

      'Gmail' => array(
          'imap_server_type'         => 'gmail',
          'default_folder_prefix'    => '',
          // NOTE: in Europe or elsewhere "[Gmail]" might need to be "[Google Mail]",
          //       "Trash" might need to be "Bin", and these only work when both
          //       SquirrelMail and Gmail languages are set to English
          'trash_folder'             => '[Gmail]/Trash',
          'default_move_to_trash     => true,
          'sent_folder'              => '[Gmail]/Sent Mail',
          'draft_folder'             => '[Gmail]/Drafts',
          'auto_create_special'      => false,
          'show_prefix_option'       => false,
          'default_sub_of_inbox'     => false,
          'show_contain_subfolders_option' => false,
          'optional_delimiter'       => '/',
          'delete_folder'            => true,
          'force_username_lowercase' => false,
          'domain'                   => 'gmail.com',
          'imapServerAddress'        => 'imap.gmail.com',
          'imapPort'                 => 993,
          'use_imap_tls'             => true,
          'imap_auth_mech'           => 'login',
          'smtpServerAddress'        => 'smtp.gmail.com',
          'smtpPort'                 => 465,
          'use_smtp_tls'             => true,
          'smtp_auth_mech'           => 'login',
          'pop_before_smtp'          => false,
          'useSendmail'              => false,
      ),

      'Yet One More Server' => array(
          'imapServerAddress' => 'yetanotherserver.net',
          'imapPort'          => '143',
          'imap_server_type'  => 'courier',
          'smtpServerAddress' => 'yetanotherserver.net',
          'smtpPort'          => '25',
          'pop_before_smtp'   => true,
          'org_title'         => '"Mail for " . $_SESSION["username"]',
          'enable_plugins'    => array(
                                   'fortune',
                                   'change_passwd',
                                ),
          'disable_plugins'   => array(
                                   'addgraphics',
                                   'change_mysqlpass',
                                ),
          'settingsWithEmbeddedPHP' => array(
                                           'org_title',
                                      ),
        // etc. - use as many settings from ../../config/config.php 
        //        as you need
      ),

  );


