<?php

/**
  * SquirrelMail Multilogin Plugin
  * Copyright (c) 2003-2007 Paul Lesniewski <paul@squirrelmail.org>
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage multilogin
  *
  */



/**
  * Validate that this plugin is configured correctly
  *
  * @return boolean Whether or not there was a
  *                 configuration error for this plugin.
  *
  */
function multilogin_check_configuration_do()
{

   // only need to do this pre-1.5.2, as 1.5.2 will make this
   // check for us automatically
   //
   if (!check_sm_version(1, 5, 2))
   {

      // try to find Compatibility, and then that it is v2.0.7+
      //
      if (!function_exists('check_plugin_version')
       || !check_plugin_version('compatibility', 2, 0, 7, TRUE))
      {
         do_err('Multilogin plugin requires the Compatibility plugin version 2.0.7+', FALSE);
         return TRUE;
      }


      // make sure configuration file exists
      //
      if (!load_config('multilogin', 'config.php', TRUE))
      {
         do_err('Multilogin plugin is missing its configuration file; please consult its INSTALL document', FALSE);
         return TRUE;
      }


   }

   return FALSE;

}



/**
  * store the user's IMAP server in the session
  *
  */
function multilogin_registerIMAPServer_do($args)
{

   $current_hook_name = get_current_hook_name($args);

   // php 4.3 confuses login info when trying 
   // to login without having logged out last time
   //
   if ($current_hook_name == 'login_before')
   {
      global $onetimepad;
      $onetimepad = '';
      sqsession_unregister('onetimepad');
   }


   global $IMAPSelections;
   $loginServer = '';
   $rememberLoginServer = FALSE;

   sqGetGlobalVar('loginServer', $loginServer, SQ_FORM);
   sqGetGlobalVar('rememberLoginServer', $rememberLoginServer, SQ_FORM);


   // can't use load_config here because compatibility
   // plugin isn't in the include path prior to this
   // hook call... but that's OK, as we were already
   // able to use load_config on the login page
   //
   //load_config('multilogin', 'config.php');
   include_once(SM_PATH . 'plugins/multilogin/config.php');


   // somehow, we lose the main SM "key" cookie by doing this
   // in the login_verified hook in SM versions prior to 1.5.2
   if ($current_hook_name == 'login_before' || check_sm_version(1, 5, 2))
   {

      if (isset($rememberLoginServer) && $rememberLoginServer)
      {
         // cookie expires in 30 days
         //
         sqsetcookie('rememberLoginServer', $loginServer, (time()+60*60*24*30));
//         setcookie('rememberLoginServer', $loginServer, (time()+60*60*24*30));
//echo "SETTING -->$loginServer<-- COOKIE<hr>";exit;
      }
      else
      {
         sqsetcookie('rememberLoginServer', 'deleted', 1);
//         setcookie('rememberLoginServer', 'deleted', 1);
      }

   }

   if (is_array($IMAPSelections[$loginServer]))
   {

      global $config_override;
      sqsession_unregister('config_override');
////      $config_override = array();

      foreach ($IMAPSelections[$loginServer] as $setting => $value)
      {

         $config_override[$setting] = $value;

      }

      sqsession_register($config_override, 'config_override');

      multilogin_sqoverride_config_do($args);

   }
   else
   {

      include_once(SM_PATH . 'functions/display_messages.php');
      sq_change_text_domain('multilogin');
      logout_error(_("Invalid server selection"));
      exit;

   }

}



/**
  * present IMAP server selection pull-down
  *
  */
function multilogin_insertIMAPSelection_do()
{

   global $enableIMAPSelection, $IMAPSelections, $rememberServer, $color;

   load_config('multilogin', 'config.php');


   sq_change_text_domain('multilogin');


   // from SM 1.5.2 an up, just use our template, only need to 
   // assign a couple values to it
   //
   if (check_sm_version(1, 5, 2))
   {

      global $oTemplate;
      $foundMatchingLoginServer = 0;
      $remember = NULL;
      sqGetGlobalVar('rememberLoginServer', $remember, SQ_COOKIE); 
      foreach (array_keys($IMAPSelections) as $IMAPServer)
      {
         if (!is_null($remember) && $remember == $IMAPServer)
            $foundMatchingLoginServer = 1;

      }
      $oTemplate->assign('select_options', array_keys($IMAPSelections));
      $oTemplate->assign('default_option', $remember);


      if ($rememberServer)
      {
         $oTemplate->assign('show_remember_login_server_checkbox', 1);
         if ($foundMatchingLoginServer)
            $oTemplate->assign('login_server_checkbox_checked', 1);
         else
            $oTemplate->assign('login_server_checkbox_checked', 0);
      }
      else
         $oTemplate->assign('show_remember_login_server_checkbox', 0);

      $output = $oTemplate->fetch('plugins/multilogin/login_form.tpl');

   }


   // old style output...
   //
   else
   {

      // really crappy placement of new login_form hook in 1.5.1
      //
      if (check_sm_version(1, 5, 1) && !check_sm_version(1, 5, 2))
         $output = "</td></tr>\n";
      else
         $output = '';


      // build regular output
      //
      if (empty($color[0])) 
         $bgcolor = '#DCDCDC';
      else                  
         $bgcolor = $color[0];
      $output .= "<tr><td colspan=\"2\"><br /><center>\n"
         . "<table width=\"350\">\n"
         . "  <tr><td bgcolor=\"$bgcolor\"><table width=\"100%\">\n"
//         . "  <tr><td bgcolor=\"#DCDCDC\"><table width=\"100%\">\n"
//         . "  <tr><td bgcolor=\"#888888\"><table width=\"100%\">\n"
         . "  <tr>\n"
         . "    <td width='30%' align=\"right\">" . _("Log in to") . ":</td>\n"
         . "    <td width=\"*\" align=\"left\">\n"
         . "       <select name=\"loginServer\">\n";

      $foundMatchingLoginServer = 0;
      $remember = NULL;
      sqGetGlobalVar('rememberLoginServer', $remember, SQ_COOKIE); 
      foreach (array_keys($IMAPSelections) as $IMAPServer)
      {

         $output .= '          <option value="' . $IMAPServer . '"';

         if (!is_null($remember) && $remember == $IMAPServer)
         {
            $output .= ' selected';
            $foundMatchingLoginServer = 1;
         }
         $output .= '>'.$IMAPServer."</option>\n";

      }

      $output .= "       </select>\n".
           "    </td>\n".
           "  </tr>\n".
           "</table></td></tr>\n";

      if ($rememberServer)
      {
         $output .= "<tr><td><center><input type='checkbox'" .
            ($foundMatchingLoginServer ? ' checked' : '') . 
            " name='rememberLoginServer' id='remember' value='1'><label for='remember'>" . 
            _("Remember login server") . "</label>\n</center></td></tr>\n";
      }
      $output .= "</table>\n".
           "</center>\n";


      // really crappy placement of new login_form hook in 1.5.1
      //
      if (check_sm_version(1, 5, 1) && !check_sm_version(1, 5, 2))
         $output .= '';
      else
         $output .= '</td></tr>';

   }

   sq_change_text_domain('squirrelmail');


   // depending on SM version, either return or display output
   //
   if (check_sm_version(1, 5, 2))
      return array('login_form' => $output);
   else if (check_sm_version(1, 5, 1))
      return $output;
   else
      echo $output;

}



/**
  * This will look for config overrides in the session,
  * which must be in an array called 'config_override'.
  * If found, any values stored there will take precedence
  * over preexisting config values.
  *
  */
function multilogin_sqoverride_config_do($args='')
{

   if (sqsession_is_registered('config_override'))
   {

      global $plugins, $squirrelmail_plugin_hooks;
      $config_override = array();
      sqGetGlobalVar('config_override', $config_override, SQ_SESSION);
      $already_enabled = array();


      // grab all the config values out of the session
      // settings and override current settings with them
      //
//DEBUGGING
//sm_print_r($config_override);
      foreach ($config_override as $key => $value)
      {
//echo "$key == $value<br />";


         // enable additional plugins
         //
         if (stristr($key, 'enable_plugins'))
         {

            $already_enabled = $value;
            foreach ($value as $pluginName)
            {
               // function is found in Compatibility plugin v2.0.5+
               //
               add_plugin($pluginName, $args);
            }
            continue;

         }


         // disable plugins
         //
         if (stristr($key, 'disable_plugins') && is_array($plugins))
         {

            // disable ALL plugins?
            //
            if (in_array('*', $value))
            {
               $reenable_vlogin = FALSE;
               $reenable_multilogin = FALSE;
               if (in_array('vlogin', $plugins))
                  $reenable_vlogin = TRUE;
               if (in_array('multilogin', $plugins))
                  $reenable_multilogin = TRUE;

               $plugins = array();
               $squirrelmail_plugin_hooks = array();

               // if we had already enabled some plugins,
               // reenable them again
               //
               foreach ($already_enabled as $pluginName)
                  add_plugin($pluginName, $args, TRUE);

               if ($reenable_multilogin)
                  add_plugin('multilogin', $args, TRUE);
               if ($reenable_vlogin)
                  add_plugin('vlogin', $args, TRUE);
            }

            // no, just disable some plugins...
            //
            else
            {
               foreach ($value as $pluginName)
               {
                  // function is found in Compatibility plugin v2.0.5+
                  //
                  remove_plugin($pluginName);
               }
            }
            continue;
         }


         //
         // replace SquirrelMail config values
         //

         global $$key;

         // embedded PHP in value need to be evaluated?
         //
         if (isset($config_override['settingsWithEmbeddedPHP'])
          && is_array($config_override['settingsWithEmbeddedPHP'])
          && in_array($key, $config_override['settingsWithEmbeddedPHP']))
            eval('$$key = ' . $value . ';');
         else
            $$key = $value;

      }

   }

}



