<?php

/**
  * SquirrelMail Multilogin Plugin
  * Copyright (c) 2003-2005 Paul Lesneiwski <paul@openguild.net>
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage multilogin
  *
  */


/**
  * Register this plugin with SquirrelMail
  *
  */
function squirrelmail_plugin_init_multilogin() {

   global $squirrelmail_plugin_hooks;

   $squirrelmail_plugin_hooks['login_form']['multilogin'] = 'multilogin_insertIMAPSelection';
   $squirrelmail_plugin_hooks['login_before']['multilogin'] = 'multilogin_registerIMAPServer';

   // unfortunately, we can only set org_title in the title
   // bar of the browser if we use this hook - otherwise, it's
   // unecessary
   //
   $squirrelmail_plugin_hooks['webmail_top']['multilogin'] = 'multilogin_sqoverride_config';

}



/** @ignore */
if (!defined('SM_PATH'))
   define('SM_PATH', '../');



/**
  * Returns version info about this plugin
  *
  */
function multilogin_version()
{
   return '2.3.2-1.2';
}



/**
  * store the user's IMAP server in the session
  *
  */
function multilogin_registerIMAPServer($args='')
{

   include_once(SM_PATH . 'plugins/multilogin/functions.php');
   multilogin_registerIMAPServer_do($args);

}


/**
  * present IMAP server selection pull-down
  *
  */
function multilogin_insertIMAPSelection()
{

   include_once(SM_PATH . 'plugins/multilogin/functions.php');
   multilogin_insertIMAPSelection_do();

}



/**
  * present IMAP server selection pull-down
  *
  */
function multilogin_sqoverride_config($args='')
{

   include_once(SM_PATH . 'plugins/multilogin/functions.php');
   multilogin_sqoverride_config_do($args);

}



?>
