<?php



// include compatibility plugin
//
if (defined('SM_PATH'))
   include_once(SM_PATH . 'plugins/compatibility/functions.php');
else if (file_exists('../plugins/compatibility/functions.php'))
   include_once('../plugins/compatibility/functions.php');
else if (file_exists('./plugins/compatibility/functions.php'))
   include_once('./plugins/compatibility/functions.php');



// store the user's IMAP server in the session
//
function multilogin_registerIMAPServer_do()
{

   // php 4.3 confuses login info when trying 
   // to login without having logged out last time
   //
   global $onetimepad;
   $onetimepad = '';
   compatibility_sqsession_unregister('onetimepad');


   global $loginServer, $rememberLoginServer, $IMAPSelections;

   compatibility_sqextractGlobalVar('loginServer');
   compatibility_sqextractGlobalVar('rememberLoginServer');


   if (compatibility_check_SM_version(1, 3))
      include_once(SM_PATH . 'plugins/multilogin/config.php');
   else
      include_once('../plugins/multilogin/config.php');


   if (isset($rememberLoginServer) && $rememberLoginServer)
   {
      // cookie expires in 30 days
      //
      setcookie('rememberLoginServer', $loginServer, (time()+60*60*24*30));
   }
   else
   {
      setcookie('rememberLoginServer', '', (time() - 3600));
   }

   if (is_array($IMAPSelections[$loginServer]))
   {

      global $config_override;
      compatibility_sqsession_unregister('config_override');
////      $config_override = array();

      foreach ($IMAPSelections[$loginServer] as $setting => $value)
      {

         $config_override[$setting] = $value;

      }

      compatibility_sqsession_register($config_override, 'config_override');


      multilogin_sqoverride_config_do();

   }

}



// present IMAP server selection pull-down
//
function multilogin_insertIMAPSelection_do()
{

   global $enableIMAPSelection, $IMAPSelections, $IMAPServerSelectionText,
          $rememberServer, $rememberServerText;

   // get global variable for versions of PHP < 4.1
   //
   if (!compatibility_check_php_version(4,1)) {
      global $HTTP_COOKIE_VARS;
      $_COOKIE = $HTTP_COOKIE_VARS;
   }

   if (compatibility_check_SM_version(1, 3))
      include_once(SM_PATH . 'plugins/multilogin/config.php');
   else
      include_once('../plugins/multilogin/config.php');


   echo "<BR><CENTER>\n".
        "<TABLE COLS=\"1\" WIDTH=\"350\">\n".
        "  <TR><TD BGCOLOR=\"#FFFFFF\"><TABLE COLS=2 WIDTH=\"100%\">\n".
        "  <TR>\n".
        "    <TD WIDTH='30%' ALIGN=right>" . _($IMAPServerSelectionText) . ":</TD>\n".
        "    <TD WIDTH=\"*\" ALIGN=left>\n".
        "       <SELECT NAME=\"loginServer\">\n";

   $foundMatchingLoginServer = 0;
   foreach (array_keys($IMAPSelections) as $IMAPServer)
   {

      echo '          <OPTION VALUE="' . $IMAPServer . '"';

      if (isset($_COOKIE['rememberLoginServer']) 
         && $_COOKIE['rememberLoginServer'] == $IMAPServer)
      {
         echo ' SELECTED';
         $foundMatchingLoginServer = 1;
      }
      echo '>'.$IMAPServer."\n";

   }

   echo "       </SELECT>\n".
        "    </TD>\n".
        "  </TR>\n".
        "</TABLE></TD></TR>\n";
   if ($rememberServer)
   {
      echo "<TR><TD><CENTER><INPUT TYPE='checkbox'" .
         ($foundMatchingLoginServer ? ' CHECKED' : '') . 
         " NAME='rememberLoginServer'>" . 
         _($rememberServerText) . "\n</CENTER></TD></TR>\n";
   }
   echo "</TABLE>\n".
        "</CENTER>\n";

}



// This will look for config overrides in the session,
// which must be in an array called 'config_override'.
// If found, any values stored there will take precedence
// over preexisting config values.
//
function multilogin_sqoverride_config_do()
{

   if (compatibility_sqsession_is_registered('config_override'))
   {

      global $config_override, $plugins, $squirrelmail_plugin_hooks;
      compatibility_sqextractGlobalVar('config_override');


      // grab all the config values out of the session
      // settings and override current settings with them
      //
      foreach ($config_override as $key => $value)
      {


         // enable additional plugins
         //
         if (stristr($key, 'enable_plugins'))
         {
            foreach ($value as $pluginName)
            {
               $plugins[] = $pluginName;
               if (function_exists('use_plugin'))
                  use_plugin($pluginName);
            }
            continue;
         }


         // disable plugins
         //
         if (stristr($key, 'disable_plugins'))
         {
            foreach ($value as $pluginName)
            {
               $pluginKey = array_search($pluginName, $plugins);
               if (!is_null($pluginKey) && $pluginKey !== FALSE)
               {
                  unset($plugins[$pluginKey]);
                  if (is_array($squirrelmail_plugin_hooks))
                     foreach (array_keys($squirrelmail_plugin_hooks) as $hookName)
                     {
                        unset($squirrelmail_plugin_hooks[$hookName][$pluginName]);
                     }
               }
            }
            continue;
         }


         //
         // replace SquirrelMail config values
         //

         // in order to set the org_title, in the browser
         // title bar, have to do it now (using an eval
         // otherwise things like $_SESSION will never be
         // found when the variable is first defined)
         //
         if ($key == 'org_title')
         {
            global $$key;
            eval('$$key = ' . $value . ';');
         }
         else
         {
            global $$key;
            $$key = $value;
         }

      }

   }

}



?>
