<?php



// include compatibility plugin
//
if (defined('SM_PATH'))
   include_once(SM_PATH . 'plugins/compatibility/functions.php');
else if (file_exists('../plugins/compatibility/functions.php'))
   include_once('../plugins/compatibility/functions.php');
else if (file_exists('./plugins/compatibility/functions.php'))
   include_once('./plugins/compatibility/functions.php');



// store the user's IMAP server in the session
//
function multilogin_restoreIMAPServer_do()
{

   global $_SESSION;

   // get global variable for versions of PHP < 4.1
   //
   if (!check_php_version(4,1)) {
      global $HTTP_SESSION_VARS;
      $_SESSION = $HTTP_SESSION_VARS;
   }


   // grab all the "multilogin_..." values out of the session
   // settings and override SM settings with them
   //
   foreach ($_SESSION as $key => $value)
   {

      if (strpos($key, 'multilogin_') === 0)
      {
         $realVarName = substr($key, 11);
         global $$realVarName;
         $$realVarName = $value;
      }

   }

}



// store the user's IMAP server in the session
//
function multilogin_registerIMAPServer_do()
{

   global $loginServer;

   compatibility_sqextractGlobalVar('loginServer');

   $settingsList = preg_split('/\|/', $loginServer, -1, PREG_SPLIT_NO_EMPTY);

   foreach ($settingsList as $settings)
   {

      list($setting, $value) = preg_split('/:/', $settings, 2);

      sqsession_register($value, 'multilogin_' . $setting);

   }

   multilogin_restoreIMAPServer();

}



// present IMAP server selection pull-down
//
function multilogin_insertIMAPSelection_do()
{

   global $enableIMAPSelection, $IMAPSelections, $IMAPServerSelectionText;

   if (compatibility_check_SM_version(1, 3))
      include_once(SM_PATH . 'plugins/multilogin/config.php');
   else
      include_once('../plugins/multilogin/config.php');


   echo "<BR><CENTER>\n".
        "<TABLE COLS=\"1\" WIDTH=\"350\">\n".
        "  <TR><TD BGCOLOR=\"#FFFFFF\"><TABLE COLS=2 WIDTH=\"100%\">\n".
        "  <TR>\n".
        "    <TD WIDTH='30%' ALIGN=right>" . _($IMAPServerSelectionText) . ":</TD>\n".
        "    <TD WIDTH=\"*\" ALIGN=left>\n".
        "       <SELECT NAME=\"loginServer\">\n";

   foreach (array_keys($IMAPSelections) as $IMAPServer)
   {

      echo "          <OPTION VALUE=\"";

      foreach ($IMAPSelections[$IMAPServer] as $setting => $value)
         echo $setting . ':' . $value . '|';

      echo "\">".$IMAPServer."\n";

   }

   echo "       </SELECT>\n".
        "    </TD>\n".
        "  </TR>\n".
        "</TABLE>\n".
        "</CENTER>\n";

}



?>
