<?php

/**
  * SquirrelMail Move All Messages Plugin
  *
  * Copyright (c) 2011-2011 Paul Lesniewski <paul@squirrelmail.org>
  * Copyright (c) 2002 Barton Hodges <barton@gcmcomputers.com>
  *
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage move_all_messages
  *
  */



/**
  * Register this plugin with SquirrelMail
  *
  */
function squirrelmail_plugin_init_move_all_messages()
{

   global $squirrelmail_plugin_hooks;


   // SM 1.4.x - show move all button on mailbox list page
   //
   $squirrelmail_plugin_hooks['mailbox_display_buttons']['move_all_messages']
      = 'show_move_all_messages_button_stub';


   // SM 1.5.x - show move all button on mailbox list page
   //
   $squirrelmail_plugin_hooks['message_list_controls']['move_all_messages']
      = 'show_move_all_messages_button_stub';


   // SM 1.4.x - perform any needed actions
   //
   $squirrelmail_plugin_hooks['move_before_move']['move_all_messages']
       = 'move_all_messages_handle_button_click_stub';


   // SM 1.5.x - perform any needed actions
   //
   $squirrelmail_plugin_hooks['mailbox_display_button_action']['move_all_messages']
       = 'move_all_messages_handle_button_click_stub';

}



/**
  * Returns info about this plugin
  *
  */
function move_all_messages_info()
{

   return array(
                 'english_name' => 'Move All Messages',
                 'authors' => array(
                    'Paul Lesniewski' => array(
                       'email' => 'paul@squirrelmail.org',
                       'sm_site_username' => 'pdontthink',
                    ),
                    'Barton Hodges' => array(
                       'email' => 'barton@gcmcomputers.com',
                    ),
                 ),
                 'version' => '1.0',
                 'required_sm_version' => '1.4.0',
                 'requires_configuration' => 0,
                 'summary' => 'Provides a means to move all messages from one folder to another in a single click',
                 'details' => 'This plugin allows users to move all messages in one folder to another by clicking a single button.',
                 'requires_source_patch' => 0,
               );

}



/**
  * Returns version info about this plugin
  *
  */
function move_all_messages_version()
{
   $info = move_all_messages_info();
   return $info['version'];
}



/**
  * Show move all button on mailbox list page
  *
  */
function show_move_all_messages_button_stub(&$args)
{
   include_once(SM_PATH . 'plugins/move_all_messages/functions.php');
   show_move_all_messages_button($args);
}



/**
  * Perform any needed actions when clicked from message list page
  *
  */
function move_all_messages_handle_button_click_stub(&$args)
{
   include_once(SM_PATH . 'plugins/move_all_messages/functions.php');
   return move_all_messages_handle_button_click($args);
}



/**
  * Force the getpot script to pick up these translations
  * (which are in the config file in non-translated form)
  *
  * @ignore
  *
  */
function mam_no_op()
{
   $ignore = _("Move All");
   $ignore = _("Move All Messages");
   $ignore = _("Move All In Folder");
   $ignore = _("Move All Messages In Folder");
   $ignore = _("Move ALL messages out of this folder to the destination folder");
   $ignore = _("Move all messages out of this folder and into the destination folder");
}



