<?php
/**
 * setup file for the IMAP mini mail plugin
 *   
 * @copyright (c) 2002-2004 Jason Munro jason@stdbev.com
 * @copyright (c) 2005 The SquirrelMail Project Team
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License
 * @version $Id: setup.php,v 1.6 2005/10/31 16:48:42 tokul Exp $
 * @package sm-plugins
 * @subpackage mini
 */

/**
 * setup plugin hooks 
 */
function squirrelmail_plugin_init_mini() {
    global $squirrelmail_plugin_hooks;
    $squirrelmail_plugin_hooks['left_main_before']['mini'] = 'mini_link';
    $squirrelmail_plugin_hooks['loading_prefs']['mini'] = 'load_mini_settings';
    $squirrelmail_plugin_hooks['optpage_loadhook_display']['mini'] = 'mini_register_block';
}

/**
 * load settings from pref file
 */
function load_mini_settings () {
    include_once(SM_PATH.'plugins/mini/functions.php');
    mini_settings_function();
}

/**
 * Adds link in left_main.
 * link on the left frame for mini window
 */
function mini_link () {
    include_once(SM_PATH.'plugins/mini/functions.php');
    mini_link_function();
}

/**
 * Adds display options block
 * @since 0.3
 */
function mini_register_block() {
    include_once(SM_PATH.'plugins/mini/functions.php');
    mini_register_block_function();
}

/**
 * Returns plugin version
 * @return string plugin version
 * @since 0.3
 */
function mini_version() {
    return '0.3';
}
?>