<?php
/**
 * functions.php
 * Some functions for the mini plugin
 * @copyright (c) 2002-2004 Jason Munro
 * @copyright (c) 2005 The SquirrelMail Project Team
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License
 * @version $Id: functions.php,v 1.5 2005/07/27 16:15:58 tokul Exp $
 * @package sm-plugins
 * @subpackage mini
 */

/** Hooked functions */

/**
 * link on the left frame for mini window (internal function)
 * @since 0.3
 */
function mini_link_function () {
    global $mini_width, $mini_height;
    bindtextdomain('mini',SM_PATH .'locale');
    textdomain('mini');
    echo "<script><!--\n";
    echo "function javapop(){\n";
    echo "newwin=window.open('../".
         "plugins/mini/mini.php','javabox','width=";
    echo "$mini_width";
    echo ",height=";
    echo "$mini_height";
    echo ",scrollbars=yes,resizable=yes')}\n";
    echo "//--></script>\n";
    echo "<center><small><a href=\"javascript:void(0)\" ".
          "Onclick=\"javapop()\" ".
          '>'._("mini window")."</a></small></center><br>\n";
    bindtextdomain('squirrelmail',SM_PATH .'locale');
    textdomain('squirrelmail');
}

/**
 * Add display option block (internal function)
 * @since 0.3
 */
function mini_register_block_function() {
    global $optpage_data;

    bindtextdomain('mini',SM_PATH .'locale');
    textdomain('mini');

    $optpage_data['grps']['mini'] = _("Mini SquirrelMail");
    $optionValues = array();
    $optionValues[] = array(
        'name'    => 'mini_width',
        'caption' => _("Window width (in pixels)"),
        'type'    => SMOPT_TYPE_INTEGER,
        'refresh' => SMOPT_REFRESH_FOLDERLIST,
        'size'    => SMOPT_SIZE_TINY
        );
    $optionValues[] = array(
        'name'    => 'mini_height',
        'caption' => _("Window height (in pixels)"),
        'type'    => SMOPT_TYPE_INTEGER,
        'refresh' => SMOPT_REFRESH_FOLDERLIST,
        'size'    => SMOPT_SIZE_TINY
        );

    $refresh_values=array();
    $refresh_values[0]=_("never");
    foreach (array(30,60,90,120,150,180,210,240,270,300) as $refresh_val) {
        if ($refresh_val<60) {
            $refresh_values[$refresh_val] = sprintf(ngettext("%s second","%s seconds",$refresh_val),$refresh_val);
        } else {
            $refresh_mins = $refresh_val / 60;
            $refresh_values[$refresh_val] = sprintf(ngettext("%s minute","%s minutes",$refresh_mins),$refresh_mins);
        }
    }

    $optionValues[] = array(
        'name'    => 'mini_refresh',
        'caption' => _("Window refresh time"),
        'type'    => SMOPT_TYPE_STRLIST,
        'refresh' => SMOPT_REFRESH_NONE,
        'posvals' => $refresh_values
        );

    $optionValues[] = array(
        'name'    => 'mini_text_size',
        'caption' => _("Window text size"),
        'type'    => SMOPT_TYPE_STRLIST,
        'refresh' => SMOPT_REFRESH_NONE,
        'posvals' => array('0' => _("Very small"),
                           '1' => _("Small"),
                           '2' => _("Normal"))
        );
    $optpage_data['vals']['mini'] = $optionValues;

    bindtextdomain('squirrelmail',SM_PATH .'locale');
    textdomain('squirrelmail');
}

/**
 * Load settings (internal function)
 * @since 0.3
 */
function mini_settings_function () {
    global $username, $data_dir, $mini_width, $mini_height, $mini_refresh, $mini_text_size;
    $mini_width = (int) getPref($data_dir, $username, 'mini_width', '380');
    if ($mini_width <= 0 || $mini_width > 1024) $mini_width = 380;

    $mini_height = (int) getPref($data_dir, $username, 'mini_height', '240');
    if ($mini_height <= 0 || $mini_height > 768) $mini_height = 240;

    $mini_refresh = (int) getPref($data_dir, $username, 'mini_refresh', '0');
    if ($mini_refresh < 0 || $mini_refresh > 300) $mini_refresh = 0;

    $mini_text_size = (int) getPref($data_dir, $username, 'mini_text_size', '1');
    if ($mini_text_size < 0 || $mini_text_size > 2) $mini_text_size = 1;
}

/**
 * returns the text entity of the message or an explination about why it could not
 * @param stream $imapConn imap connection resource
 * @param string $mailbox mailbox name
 * @param string $id message id
 * @return string formated message text
 */
function mini_message ($imapConn, $mailbox, $id) {
    /* get the vars we need */
    global $color, $data_dir, $username;

    /* set the text size stuff */
    $mini_text_size = getPref($data_dir, $username, 'mini_text_size', '1');
    if ($mini_text_size == '1') {
        $bsm = "<small>";
        $esm = "</small>";
    }
    elseif ($mini_text_size == '0') {
        $bsm = "<small><small>";
        $esm = "</small></small>";
    }
    elseif ($mini_text_size == '2') {
        $bsm = "";
        $esm = "";
    }

    /* select the mailbox errors set to true */
    sqimap_mailbox_select($imapConn, $mailbox, true, false, false);

    /* get the message structure */
    $details = sqimap_get_message($imapConn, $id, $mailbox);
    $nogo = '';
    $ent = '1';

    /* account for changes in the message object */
    $type_1 = $details->type0;
    $type_2 = (isset($details->entities[0]->type0) ? $details->entities[0]->type0 : '') ;
    $type_3 = (isset($details->entities[0]->entities[0]->type0) ? $details->entities[0]->entities[0]->type0 : '') ;

    /* here is the check for text parts */
    switch ($type_1) {
        case 'multipart':
            $mini_extra = "$bsm<b>"
                ._("This message has additional parts. Please use the main SquirrelMail interface to open them")
                ."</b>$esm</td></tr>";
            if ($type_2 != 'text' && $type_3 != 'text') {
                $nogo = '<tr><td align=center>'."$bsm<b>"
                    ._("Could not find a text part. Please use the main SquirrelMail window to read this message")
                    ."$esm";
            } 
            elseif ($type_3 == 'text') {
                $ent = '1.1';
            }
            break;
        case 'text':
            $mini_extra = '</td></tr>';
            break;
        default:
            $nogo = "$bsm<b>"
                ._("Could not find a text part. Please use the main SquirrelMail window to read this message")
                ."$esm";
            break; 
    }
    if (!empty($nogo)) {
        return $nogo;
    }
    
    /* if we made it here then lets get the message body */
    $body = mini_formatBody($imapConn, $details, 56, $ent, $id);
    $response = $mini_extra."<tr><td bgcolor=\"$color[4]\">$bsm<pre>".
                $body."</pre>$esm\n";
    return $response;
}

/**
 * returns a list of folders with the message numbers of mail that is new
 * @param stream $imapConn imap connection resource
 * @return array new messages
 */
function get_mini_list($imapConn) {
    global $trash_folder, $uid_support;
    $boxes = sqimap_mailbox_list($imapConn);
    $box_count = count($boxes);
    $parent_unseen = 0;
    $results = array();
    
    /* loop through the folders and get the unseen message numbers */
    for ($i=0;$i<$box_count;$i++) {
        $cur_box = $boxes[$i]['unformatted'];
        $length = strlen($cur_box);
        $message = '';
        $search_response = array();
        $responses = array(); 

        /* if it is selectable search for unseen */
        if (!preg_match("/NoSelect/i", $boxes[$i]['raw']) &&
            !strstr($boxes[$i]['unformatted'], $trash_folder)) {

            $mbox_status=sqimap_status_messages($imapConn,$cur_box,array('UNSEEN'));
            if ($mbox_status['UNSEEN']>0) {
                sqimap_mailbox_select($imapConn,$cur_box);

                if (check_sm_version(1,5)) {
                    /**
                     * function is from functions/imap_asearch.php. In 1.5.x file is 
                     * loaded by functions/imap.php through mailbox_display.php. 
                     */
                    $results[$cur_box]=sqimap_run_search($imapConn,'UNSEEN','');
                } else {
                    /* do the search */
                    $message = '';
                    $responses = array();
                    $sid = sqimap_session_id(true);
                    $query = $sid." SEARCH UNSEEN UNSEEN\r\n";
                    fputs ($imapConn, $query);
                    $search_response = sqimap_read_data_list($imapConn, $sid,
                                                             true, $responses, $message);
                    if (preg_match("/^\*\sSEARCH\s(.+)/", $search_response[0][0], $regs)) {
                        $new_ids = explode(" ", $regs[1]);
                        $results[$boxes[$i]['unformatted']] = $new_ids;
                    }
                }
            }
        }
    }
    return $results;
}

/**
 * gets the subject and from for a list of messges
 * @param stream $imapConn imap connection resource
 * @param string $mailbox imap folder
 * @param array $ids message ids
 * @return array message data
 */
function get_mini_headers ($imapConn, $mailbox, $ids) {
    /* get some vars */
    global $username, $data_dir, $uid_support;
    $mini_width = getPref($data_dir, $username, 'mini_width', '380');
    $mini_text_size = getPref($data_dir, $username, 'mini_text_size', '1');
    $trim_to = intval((.098*$mini_width));  
    if ($mini_text_size == '1') {
        $bsm = "<small>";
        $esm = "</small>";
        $trim_to -= 5;
    }
    elseif ($mini_text_size == '0') {
        $bsm = "<small><small>";
        $esm = "</small></small>";
    }
    elseif ($mini_text_size == '2') {
        $bsm = "";
        $esm = "";
        $trim_to -= 10;
    }

    /* select the mailbox */
    sqimap_mailbox_select($imapConn, $mailbox, true, false, false);

    // 1.4.x requires integers in array values. 1.5.x works with strings too.
    array_walk($ids,'mini_array_to_int');

    /**
     * headers can be limited only in 1.5.x. use only two arguments 
     * in order to be compatible with 1.4.x and 1.5.x function syntax.
     */
    // $fetch_results = sqimap_get_small_header_list($imapConn, $ids, array('SUBJECT','FROM'),array());
    $fetch_results = sqimap_get_small_header_list($imapConn, $ids);
    
    /* fetch each message one at a time */
    foreach($fetch_results as $value => $headers) {
        $res='';
        if (isset($headers['SUBJECT']) && $headers['SUBJECT']!='') {
            // older sm api. key names are uppercased
            $full_subject = decodeHeader($headers['SUBJECT']);
            $res.= ' title="' . $full_subject . '">'
                . $full_subject . '</a>';
        } elseif (isset($headers['subject']) && $headers['subject']!='') {
            // newer sm api. key names are lowercased
            $full_subject = decodeHeader($headers['subject']);
            $res.= ' title="' . $full_subject . '">'
                . $full_subject . '</a>';
        } else {
            $res.= '>' . _("No subject") . '</a>';
        }
        $res.=$esm . '</td><td width="50%">' . $bsm;
        if (isset($headers['FROM']) && $headers['FROM']!='') {
            $full_sender = decodeHeader($headers['FROM']);
            $res.='<a title="' . $full_sender . '">'
                . $full_sender . '</a>';
        } elseif (isset($headers['from']) && $headers['from']!='') {
            $full_sender = decodeHeader($headers['from']);
            $res.='<a title="' . $full_sender . '">'
                . $full_sender . '</a>';
        } else {
            $res.='<a title="' . _("No sender") . '">'
                ._("No sender") . '</a>';
        }
        $id = (check_sm_version(1,5) ? $headers['UID'] : $headers['ID']);
        $results[$id] = $res; 
    }
    //$results = array_reverse($results);
    return $results;   
}

/**
 * callback function used in get_mini_headers
 * converts array values to integers
 * @since 0.3
 * @param mixed $value array value (will be converted to integer)
 * @param mixed $key array key
 */
function mini_array_to_int(&$value,$key) {
    $value = (int) $value;
}

/**
 * Stripped version of squirrelmail formatBody() from functions/mime.php.
 * removed hooks, view_unsafe_image and download as file code. 
 * replaced translateText function with own stripped version
 * @param stream $imap_stream imap connection resource
 * @param object $message message object
 * @param integer $wrap_at text wrapping
 * @param string $ent_num message entity
 * @param integer $id message id
 * @return string
 * @since 0.3
 */
function mini_formatBody($imap_stream, $message, $wrap_at, $ent_num, $id) {
    global $languages, $squirrelmail_language;

    $body = '';
    $body_message = getEntity($message, $ent_num);
    if (($body_message->header->type0 == 'text') ||
        ($body_message->header->type0 == 'rfc822')) {
        $body = mime_fetch_body ($imap_stream, $id, $ent_num);
        $body = decodeBody($body, $body_message->header->encoding);

        // TODO: recheck it (compatible only with 1.4.x)
        if (isset($languages[$squirrelmail_language]['XTRA_CODE']) &&
            function_exists($languages[$squirrelmail_language]['XTRA_CODE'])) {
            if (mb_detect_encoding($body) != 'ASCII') {
                $body = $languages[$squirrelmail_language]['XTRA_CODE']('decode', $body);
            }
        }

        /**
         * Strip html from text. do not follow user's preferences
         * currently unused.
         */
        if ($body_message->header->type1 == 'html') {
            $entity_conv = array('&nbsp;' => ' ',
                                 '<p>'    => "\n",
                                 '<P>'    => "\n",
                                 '<br>'   => "\n",
                                 '<BR>'   => "\n",
                                 '<br />' => "\n",
                                 '<BR />' => "\n",
                                 '&gt;'   => '>',
                                 '&lt;'   => '<');
            $body = strtr($body, $entity_conv);
            $body = strip_tags($body);
            $body = trim($body);
        }
        mini_translateText($body, $wrap_at,
                           $body_message->header->getParameter('charset'));
        $body .= '</small></center><br />' . "\n";
    }
    return $body;
}

/**
 * Stripped version of translateText() from functions/mime.php
 * Url parsing and quote coloring removed.
 * @param string $body message body
 * @param integer $wrap_at line length
 * @param charset $charset text encoding
 * @since 0.3
 */
function mini_translateText(&$body, $wrap_at, $charset) {
    $body_ary = explode("\n", $body);
    for ($i=0; $i < count($body_ary); $i++) {
        $line = $body_ary[$i];
        if (strlen($line) - 2 >= $wrap_at) {
            sqWordWrap($line, $wrap_at);
        }
        $line = charset_decode($charset, $line);
        $line = str_replace("\t", '        ', $line);

        $body_ary[$i] = $line;
    }
    $body = '<pre>' . implode("\n", $body_ary) . '</pre>';
}

if (! function_exists('ngettext')) {
    /**
     * Simple wrapper for setups without ngettext support.
     * @param string $singular singular string
     * @param string $plural plural string
     * @param integer $count counter
     * @return string singular or plural string (according to US English rules and $count)
     * @since 0.3
     */
    function ngettext($singular,$plural,$count) {
	$count = (int) $count;
        if ($count!=1) {
            return $plural;
        } else {
            return $singular;
        }
    }
}
?>