<?php

   // include compatibility plugin
   //
   if (defined('SM_PATH'))
      include_once(SM_PATH . 'plugins/compatibility/functions.php');
   else if (file_exists('../plugins/compatibility/functions.php'))
      include_once('../plugins/compatibility/functions.php');
   else if (file_exists('./plugins/compatibility/functions.php'))
      include_once('./plugins/compatibility/functions.php');

// Display mark_read links on target folders
//
function mark_read_show_link_do($parms) {

   global $data_dir, $username, $default_folders_to_show_mark_read_link,
          $default_mark_read_display, $default_mark_read_displayall; 

   include_once(SM_PATH . 'functions/i18n.php');
   bindtextdomain('mark_read', SM_PATH . 'plugins/mark_read/locale');
   textdomain('mark_read');
   
   $numMessages = $parms[0];
   $real_box = $parms[1];
   $imapConnection = $parms[2];


   if (compatibility_check_sm_version(1, 3))
      include_once (SM_PATH . 'plugins/mark_read/config.php');
   else
      include_once ('../plugins/mark_read/config.php');


   // grab preferences
   //
   $allFolders = getPref($data_dir, $username, 'mark_read_show_link', '');
   $mark_read_display = intval(getPref($data_dir, $username, 'mark_read_display', $default_mark_read_display));


   // load default folders if none have previously been chosen
   //
   if ($allFolders == 'NONE') $allFolders = '';
   else if ($allFolders == '')
   {
      $allFolders = implode('###', $default_folders_to_show_mark_read_link);
   }
   $mark_read_show_link = explode('###', $allFolders);


   if (empty($numMessages)) {
      $numMessages = sqimap_get_num_messages($imapConnection, $real_box);
   }
   if ($numMessages > 0 && in_array($real_box, $mark_read_show_link)) {
      $urlMailbox = urlencode($real_box);
      $display = '';
      if( ($mark_read_display & READ) > 0 ) $display .= "<A HREF=\"../plugins/mark_read/mark_read.php?mailbox=$urlMailbox&mark=read\" title=\""._("mark all messages in this folder as read")."\">"._("read")."</A>";
      if( ($mark_read_display & (READ+UNREAD)) == (READ+UNREAD) ) $display .= '/'; 
      if( ($mark_read_display & UNREAD) > 0 ) $display .= "<A HREF=\"../plugins/mark_read/mark_read.php?mailbox=$urlMailbox&mark=unread\" title=\""._("mark all messages in this folder as unread")."\">"._("unread")."</A>"; 
      return (($mark_read_display > NONE)?"<small>&nbsp;($display)</small>":"");
   }
   bindtextdomain('squirrelmail', SM_PATH . 'locale');
   textdomain('squirrelmail');

}

// Display mark all read link
//
function mark_read_do_mark_all_read() {

   global $data_dir, $username, $default_folders_to_show_mark_read_link,
          $default_mark_read_display, $default_mark_read_displayall; 

  include_once(SM_PATH . 'functions/i18n.php');
  bindtextdomain('mark_read', SM_PATH . 'plugins/mark_read/locale');
  textdomain('mark_read');


  $mark_read_displayall = getPref($data_dir, $username, 'mark_read_displayall', $default_mark_read_displayall);
  if( $mark_read_displayall == 1 ) { 
    $mark_read_display = intval(getPref($data_dir, $username, 'mark_read_display', $default_mark_read_display));
    $display = '';
    if( ($mark_read_display & READ) > 0 ) $display .= "<A HREF=\"../plugins/mark_read/mark_read.php?markallread=1&mark=read\" title=\""._("mark all messages in the above folders as read")."\">"._("read")."</A>";
    if( ($mark_read_display & (READ+UNREAD)) == (READ+UNREAD) ) $display .= '/'; 
    if( ($mark_read_display & UNREAD) > 0 ) $display .= "<A HREF=\"../plugins/mark_read/mark_read.php?markallread=1&mark=unread\" title=\""._("mark all messages in the above folders as unread")."\">"._("unread")."</A>"; 
    echo (($mark_read_display > NONE)?"<small>&nbsp;("._("mark all folders")." $display)</small>":"");
  }
  
  bindtextdomain('squirrelmail', SM_PATH . 'locale');
  textdomain('squirrelmail');
  
}

// This is the text that appears on the option page
//
function mark_read_show_options_do() {

   global $username, $data_dir, $color, $user_mark_read_link, 
          $default_mark_read_display, $default_mark_read_displayall, 
          $default_folders_to_show_mark_read_link;

  include_once(SM_PATH . 'functions/i18n.php');
  bindtextdomain('mark_read', SM_PATH . 'plugins/mark_read/locale');
  textdomain('mark_read');


   // grab new settings if user had just pressed Save
   //
   global $mark_read_form;
   compatibility_sqextractGlobalVar('mark_read_form');
   if (isset($mark_read_form) && $mark_read_form)
   {

      // get folders that should get a mark_read link
      //
      global $mark_read_show_link;
      compatibility_sqextractGlobalVar('mark_read_show_link');
      $allFolders = '';
      if (isset($mark_read_show_link))
         foreach ($mark_read_show_link as $folder)
            $allFolders .= $folder . '###';
      if (!isset($mark_read_show_link) || count($mark_read_show_link) == 0)
         $allFolders = 'NONE';
      setPref($data_dir, $username, 'mark_read_show_link', $allFolders);

      // get display options from the form
      //
      global $mark_read_display;
      compatibility_sqextractGlobalVar('mark_read_display');
      if( isset($mark_read_display) ) {
         setPref($data_dir, $username, 'mark_read_display', $mark_read_display);
      }
      global $mark_read_displayall;
      compatibility_sqextractGlobalVar('mark_read_displayall');
      if( isset($mark_read_displayall) ) {
         setPref($data_dir, $username, 'mark_read_displayall', $mark_read_displayall);
      } else {
         setPref($data_dir, $username, 'mark_read_displayall', 0);
      }

   }


   if (compatibility_check_sm_version(1, 3))
      include_once (SM_PATH . 'plugins/mark_read/config.php');
   else
      include_once ('../plugins/mark_read/config.php');


   // grab preferences
   //
   $allFolders = getPref($data_dir, $username, 'mark_read_show_link', '');
   $mark_read_display = getPref($data_dir, $username, 'mark_read_display', $default_mark_read_display);
   $mark_read_displayall = getPref($data_dir, $username, 'mark_read_displayall', $default_mark_read_displayall);


   // load default folders if none have previously been chosen
   //
   if ($allFolders == 'NONE') $allFolders = '';
   else if ($allFolders == '')
   {
      $allFolders = implode('###', $default_folders_to_show_mark_read_link);
   }

   
   $mark_read_show_link = explode('###', $allFolders);


   if ($user_mark_read_link)
   {

      echo '<FORM METHOD="POST" NAME="mark_read_links_form">'
         . '<input type="hidden" value="1" name="mark_read_form">'
         . '<TABLE WIDTH="70%" COLS="1" ALIGN="CENTER" cellpadding="4" '
         . 'cellspacing="0" border="0">'
         . "<tr><td bgcolor=\"$color[4]\">&nbsp;</td></tr>\n"
         . "<TR><TD BGCOLOR=\"$color[9]\" ALIGN=CENTER><B>"
         . _("Mark Read Link")
         . '</B></TD></TR>'
         . "<TR><TD BGCOLOR=\"$color[0]\" ALIGN=CENTER>";
      if ($user_mark_read_link)
      {
         global $boxes, $trash_folder;
         $specialFolders = array();
         echo '<TABLE WIDTH="100%" BORDER="0"><TR><TD width="60%" align="right">'
            . '<SELECT NAME="mark_read_show_link[]" multiple size="8">';
         for ($i = 0; $i < count($boxes); $i++) 
         {
            if (strtolower($boxes[$i]['unformatted']) != $trash_folder)
            {
               $box = $boxes[$i]['unformatted-dm'];
               $box2 = str_replace(' ','&nbsp;',imap_utf7_decode_local(
                                                $boxes[$i]['unformatted-disp']));
               if (strtolower($box) != 'inbox.trash') 
                  echo '<OPTION VALUE="' . $box . '"'
                     . (isset($mark_read_show_link) 
                        && in_array($box, $mark_read_show_link)
                        ? ' SELECTED' : '') . '>' . $box2 . "\n";

               // get special folder list for use below
               //
               if (isSpecialMailbox($box))
                  $specialFolders[] = $box2;

            }
         }

         echo '</SELECT></TD><TD valign="bottom">'
            . '&nbsp;&nbsp;<a href="#" onClick="list=document.mark_read_links_form.elements[1]; for (i=0; i<list.length; i++) {if (';
         $first = true;
         foreach ($specialFolders as $specialFolder)
         {
            if (!$first) echo ' || ';
            else $first = false;
            echo 'list.options[i].text==\'' . $specialFolder . '\'';
         }
         echo ') { if (list.options[i].selected) list.options[i].selected=false; else list.options[i].selected=true; } } return false">'._("Toggle Special Folders").'</a><br><br>'
            . '&nbsp;&nbsp;<a href="#" onClick="list=document.mark_read_links_form.elements[1]; for (i=0; i<list.length; i++) {if (list.options[i].selected) list.options[i].selected=false; else list.options[i].selected=true; } return false">'._("Toggle All").'</a></TD></TR></TABLE>';
         
         echo 'Display links: <select name="mark_read_display" size="1">'.
               '<option '.($mark_read_display==0?'selected ':'').'value="0">'._("none").'</option>'.
               '<option '.($mark_read_display==1?'selected ':'').'value="1">'._("(read)").'</option>'.
               '<option '.($mark_read_display==2?'selected ':'').'value="2">'._("(unread)").'</option>'.
               '<option '.($mark_read_display==3?'selected ':'').'value="3">'._("(read/unread)").'</option>'.
               '</select><br />';
         echo '<input type="checkbox" name="mark_read_displayall" value="1" '.($mark_read_displayall==1?'checked="checked"':'').' /> '.
               _("Display 'mark all folders' link below the folder list");
      }
      echo '</TD></TR><TR><TD BGCOLOR="' . $color[0] 
         . '" align="right"><input type="submit" value="' 
         . _("Save") . '">'
         . '</TD></TR></TABLE></FORM>';

   }

  bindtextdomain('squirrelmail', SM_PATH . 'locale');
  textdomain('squirrelmail');

}



?>
