<?php


/**
  * Register this plugin with SquirrelMail
  *
  */
function squirrelmail_plugin_init_mark_read() {

  global $squirrelmail_plugin_hooks;


  $squirrelmail_plugin_hooks['folders_bottom']['mark_read'] 
     = 'mark_read_show_options';
  $squirrelmail_plugin_hooks['left_main_after_each_folder']['mark_read']
     = 'mark_read_show_link';
  $squirrelmail_plugin_hooks['left_main_after']['mark_read']
     = 'mark_read_show_link_all_read';  

}


/** ignore */
if (!defined('SM_PATH'))
   define('SM_PATH', '../');


function mark_read_show_options() {

  include_once(SM_PATH . 'plugins/mark_read/functions.php');
  mark_read_show_options_do();

}


function mark_read_show_link($parms) {

  include_once(SM_PATH . 'plugins/mark_read/functions.php');
  return mark_read_show_link_do($parms);

}

function mark_read_show_link_all_read() {

  include_once(SM_PATH . 'plugins/mark_read/functions.php');
  return mark_read_do_mark_all_read();
  
}


/**
  * Returns info about this plugin
  *
  */
function mark_read_info()
{

   return array(
                 'english_name' => 'Mark Read',
                 'version' => '1.4.2',
                 'required_sm_version' => '1.2',
                 'requires_configuration' => 0,
                 'requires_source_patch' => array(
           '1.4.1' => 3, // 3 = this version & below require patching
           '1.4.2' => 6, // 6 = this version & above do not require patching
                                                 ),
                 'required_plugins' => array(),
                 'summary' => 'Mark whole folders as read or unread with one click in the folder list.',
                 'details' => 'This plugin allows the user to turn on the display of "(read/unread)" links to the right of any folders in their folder list that contain at least one message.  Clicking on the link will then mark all messages in this folder as read/unread.  Note that you may turn the "read/unread" link on and off by going to the Folders page.  You may even turn only the "read" or the "unread" link on or off.  It also displays a "mark all read/unread" link below the folder list to mark all folders read/unread that are selected on the Folders page.',
               );

}


/**
  * Returns version info about this plugin
  *
  */
function mark_read_version()
{

   $info = mark_read_info();
   return $info['version'];

}


?>
