<?php
/**
** Mail Alias plugin for SquirrelMail
**
**  mail_alias_opt.php
**
**  Copyright (C) 2004,2005 Graeme C Neatham <graeme@promptpost.com>
**  Licensed under the GNU GPL. For full terms see the file COPYING.
**
**  Displays all options relating to mail_alias plugin
**
**/
    global $dom_list, $dom_array, $max_alias, $alRule, $emlAl,
           $show_ma_format, $show_ma_permmitted_list;

    if (!defined('SM_PATH'))
       define('SM_PATH','../../');

    include_once('DB.php');
    include_once(SM_PATH . 'plugins/mail_alias/functions.php');
    include_once(SM_PATH . 'include/validate.php');
    include_once(SM_PATH . 'functions/display_messages.php');
    include_once(SM_PATH . 'functions/imap.php');

    displayPageHeader($color, 'None');

    bindtextdomain('mail_alias', SM_PATH . 'plugins/mail_alias/locale');
    textdomain('mail_alias');

    // set the maximum number of aliases allowed
    //
    if (!$max_alias) get_db_alias_max();

    // construct the domain list
    //
    if(empty($dom_list)) {
        get_db_domains();
        $dom_array = explode(",",ltrim($dom_list));
    }

    // set the alias action flag
    // and the Identity Synchronize flag
    //
    if (!sqgetGlobalVar('rule', $alRule, SQ_FORM))  $alRule = 'none';
    if (!sqgetGlobalVar('idsync', $idSync, SQ_FORM)) $idSync = 'no';

    // create a new alias
    //
    if ($alRule == "newAlias") {
       sqgetGlobalVar('newUname', $emlUn, SQ_FORM);
       sqgetGlobalVar('newDom', $emlDm, SQ_FORM);
       if (!sqgetGlobalVar('idsync', $idSync, SQ_FORM)) $idSync = 'no';
       $emlAl = $emlUn . '@' . $emlDm;
       $addRes = add_db_alias_for_user($emlAl, $idSync);
    }

    // delete an existing alias
    //
    if (strpos($alRule, '@')) {
        $delRes = del_db_alias_for_user($alRule, $idSync);
    }

    // get previous alias entry from MySQL 
    //
    $select_result = get_db_alias_for_user();
?>
    <!-- Printing results in HTML -->
    <table align=center width='95%' border='0' cellpadding='2' cellspacing='0'>
        <tr>
            <td align=center bgcolor='<?php echo $color[0]; ?>'>
                <b><?php echo _("Options") . ' - ' . _("Mail Aliases"); ?></b>
            </td>
        </tr>  
        <tr>
            <td align='center'>
               <?php if ($show_ma_format) echo '<br>' ._("Mail aliases consist of:") . '&nbsp;'; ?>
               <?php if ($show_ma_format) echo '<i>' . _("username, domain ") . '</i>'; ?> 
               <?php if ($show_ma_format) echo _("in the format") . '<br>'; ?>
               <?php if ($show_ma_format) echo '<b><i>' . _("username@domain") . '</i></b>'; ?>
               <?php if ($show_ma_permitted_list) echo '<br>' . _("Permitted domains are :"); ?>
               <?php if ($show_ma_permitted_list) echo '<br>' . $dom_list; ?>
            </td>
         </tr>
         <tr><td>&nbsp;</td></tr>
    </table>
    <table width='66%' align='center' border='2' cellpadding='3' cellspacing='2'>
<?php
$colspan = ($allow_ident_sync) ? 3 : 2;
if ($max_alias > 0) {
    echo "\t<tr>\n";
    echo "\t\t<td align='center' colspan='$colspan' bgcolor='$color[0]'>\n<b>";
    echo _("You may add Aliases up to a maximum of") . ' ' . $max_alias . "</b>\n";
    echo "\t\t</td>\n\t</tr>\n";
}
?>
        <tr>
            <td align='center'><b><?php echo _("Alias"); ?></b></td>
            <?php if ($allow_ident_sync) 
            echo "\n\t<td align = 'center'><span style='font-size: 84%'><b>" 
                 .  _("Synchronize Identities") . "</b></span></td>\n"; ?>
            <td align='center'><b><?php echo _("Action"); ?></b></td>
       </tr>
<?php
    $add_btn = _("Add");
    $del_btn = _("Delete"); 
    $alnum = 0; 
    while ($select_result->fetchInto($line, DB_FETCHMODE_ORDERED)) {
       echo "\t<tr>\n";
       echo "\t<form action='mail_alias_opt.php' method='post'>\n";
       echo "\t\t<td align='center'>$line[0]"
          . "\t<input type='hidden' name='rule' value='$line[0]'></td>\n";
       if ($allow_ident_sync){ 
            $strEcho = "\t\t<td align = 'center'><input type='checkbox' ";
            if (ident_exists($line[0])) $strEcho .= "checked ";
            $strEcho .= "name='idsync' value='yes'></td>\n";
            echo $strEcho;
       }
       echo  "\t\t<td align='center'><input type='submit' value='$del_btn'></td>\n";
       echo "\t</form>\n";
       $alnum += 1;
       echo "\t</tr>\n";
    }
    
    if (($alnum < $max_alias) || ($max_alias < 0)) {
       echo "\t<tr>\n";
       echo "\t<form action='mail_alias_opt.php' method='post'>\n"
          . "\t<input type='hidden' name='rule' value='newAlias'>\n";
       echo "\t\t<td align='center' dir='LTR'><input type='text' name='newUname'>" . " @ "
          . "<select name='newDom'>";
       foreach ($dom_array as $domOpt) {
           echo "<option>$domOpt</option>\n";
       }
       if ($allow_ident_sync) 
            echo "\t\t<td align = 'center'><input type='checkbox' name='idsync' value='yes'></td>\n";
       echo "</select></td>\n"
          . "\t\t<td align='center'><input type='submit' value='$add_btn'> </td>\n";
       echo "\t</form>\n";
       echo "\t</tr>\n";
    }
    else {
       $str01 = _("You have set up your maximum number of aliases.");
       $str02 = _("You must delete one of your existing aliases before adding a new one.");

       echo "\t<tr>\n";
       echo "\t\t<td align='center' colspan='$colspan'></td>\n";
       echo "\t<tr>\n";
       echo "\t\t<td align='center' colspan='$colspan'>"
          . "<br>\n\t\t" . $str01
          . "<br>\n\t\t" . $str02
          . "<br><br></td>\n";
       echo "\t</tr>\n";
    }

    bindtextdomain('squirrelmail', SM_PATH . 'locale');
    textdomain('squirrelmail');
?>
    </table></body></html>
