<?php

/**
  * SquirrelMail Login Redirect Plugin
  * Copyright (C) 2004-2006 Paul Lesneiwski <paul@squirrelmail.org>
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage login_redirect
  *
  */



/**
  * Fixes the login page uri shown for login errors.
  *
  */
function rl_logout_error_do(&$args)
{


   global $custom_login_URI, $domain;
   @include_once(SM_PATH . 'plugins/login_redirect/config.php');


   // if no location given, try to get one from vlogin
   //
   if (empty($custom_login_URI))
   {
      global $login_redirect_custom_login_URI;
      if (!empty($login_redirect_custom_login_URI))
         $custom_login_URI = $login_redirect_custom_login_URI;
   }


   // if not empty, fix the login uri
   //
   if (!empty($custom_login_URI))
   {

      // if $domain needs to be inserted into the URI, do that now
      //
      $custom_login_URI = str_replace('###DOMAIN###', $domain, $custom_login_URI);

      if (check_sm_version(1, 5, 2))
      {
         $args[2]['URI'] = $custom_login_URI;
      }
      else
      {
         $args[3] = $custom_login_URI;
      }

   }

}



/**
  * Fixes the login page uri shown for the signout page.
  *
  */
function rl_signout_do(&$args)
{


   global $custom_login_URI, $domain;
   @include_once(SM_PATH . 'plugins/login_redirect/config.php');


   // if no location given, try to get one from vlogin
   //
   if (empty($custom_login_URI))
   {
      global $login_redirect_custom_login_URI;
      if (!empty($login_redirect_custom_login_URI))
         $custom_login_URI = $login_redirect_custom_login_URI;
   }


   // if not empty, fix the login uri
   //
   if (!empty($custom_login_URI))
   {

      // if $domain needs to be inserted into the URI, do that now
      //
      $custom_login_URI = str_replace('###DOMAIN###', $domain, $custom_login_URI);

      // will only work with 1.5.2+ unless you patch the source
      //
      if (check_sm_version(1, 5, 2))
      {
         $args = $custom_login_URI;
      }
      else
      {
         $args[1] = $custom_login_URI;
      }

   }

}



/** 
  * Pushes user to different login page (custom portal, etc)
  *
  */
function redirect_login_do()
{

   global $lr_debug, $custom_login_URI, 
          $prevent_endless_redirects, $domain;
   @include_once(SM_PATH . 'plugins/login_redirect/config.php');
   if (!isset($prevent_endless_redirects))
      $prevent_endless_redirects = 1;


   // if no location given, try to get one from vlogin
   //
   if (empty($custom_login_URI))
   {
      global $login_redirect_custom_login_URI;
      if (!empty($login_redirect_custom_login_URI))
         $custom_login_URI = $login_redirect_custom_login_URI;
   }


   // if still empty, bail!
   //
   if (empty($custom_login_URI))
      return;


   // if $domain needs to be inserted into the URI, do that now
   //
   $custom_login_URI = str_replace('###DOMAIN###', $domain, $custom_login_URI);


   // don't redirect if we're already at the same URI
   //
   if ($prevent_endless_redirects)
   {

      // TODO: is this too loose?  This might prevent redirects when the
      //       target page is different from the source page only by some
      //       query arguments.  For now, if users have a problem with
      //       that, they can turn off the $prevent_endless_redirects 
      //       setting.  this is also possibly an inaccurate build of 
      //       the page address, given it doesn't include protocol nor
      //       non-standard port number, etc.
      //
      sqGetGlobalVar('HTTP_HOST', $host, SQ_SERVER);
      sqGetGlobalVar('PHP_SELF', $uri, SQ_SERVER);
      sqGetGlobalVar('QUERY_STRING', $query, SQ_SERVER);

      if ($lr_debug)
      {
         echo 'Redirect: ' . $custom_login_URI . '<br />';
         echo 'Current: ' .$host . $uri . (empty($query) ? '' : (strpos($query, '?') === 0 ? '' : '?') . $query) . '<hr />';
         sm_print_r($_SERVER);
         exit;
      }


      // this one uses query string
      //
      //if (strpos($custom_login_URI, $host . $uri 
      //                            . (empty($query) ? '' : (strpos($query, '?') === 0 ? '' : '?') . $query) !== FALSE)


      // this one not using query string
      //
      if (strpos($custom_login_URI, $host . $uri) !== FALSE)
         return;

   }


// TODO: does this need to be changed to $oTemplate->header(); in 1.5.2+??
   header('Status: 303 See Other');
   header('Location: ' . $custom_login_URI);
   exit;

}



