<?php

/**
  * SquirrelMail Login Authentication Plugin
  *
  * Copyright (c) 2004-2012 Paul Lesniewski <paul@squirrelmail.org>,
  * Copyright (c) 2001 Tyler Akins
  *
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage login_auth
  *
  */


/**
  * Register this plugin with SquirrelMail
  *
  */
function squirrelmail_plugin_init_login_auth()
{

   global $squirrelmail_plugin_hooks;


   // verify that an externally logged-in user's
   // (external) login session is still valid
   //
   $squirrelmail_plugin_hooks['generic_header']['login_auth']
      = 'login_auth_verify_login_stub';


   // check if user has already authenticated themselves; can we skip login page?
   //
   $squirrelmail_plugin_hooks['login_cookie']['login_auth']
      = 'login_auth_skip_login_stub';


   // make sure to use alternative auth credentials when logging in if needed
   //
   $squirrelmail_plugin_hooks['login_before']['login_auth']
      = 'login_auth_login_before_stub';


   // change the signout page
   //
   $squirrelmail_plugin_hooks['logout']['login_auth']
      = 'login_auth_logout_stub';


   // change the login link on error pages
   //
   $squirrelmail_plugin_hooks['logout_error']['login_auth']
      = 'login_auth_error_login_link_stub';


   // configuration check
   //
   $squirrelmail_plugin_hooks['configtest']['login_auth']
      = 'login_auth_check_configuration_stub';

}



/**
  * Returns info about this plugin
  *
  */
function login_auth_info()
{

   return array(
                 'english_name' => 'Login Authentication',
                 'authors' => array(
                    'Paul Lesniewski' => array(
                       'email' => 'paul@squirrelmail.org',
                       'sm_site_username' => 'pdontthink',
                    ),
                    'Tyler Akins' => array(
                    ),
                 ),
                 'version' => '3.0',
                 'required_sm_version' => '1.4.0',
                 'requires_configuration' => 0,
                 'requires_source_patch' => 0,
                 'summary' => 'Allows externally authenticated (using HTTP authentication or a single sign-on system) users to skip the SquirrelMail login page.', 
                 'details' => 'This plugin tells SquirrelMail how to understand when users have been externally authenticated, in which case the SquirrelMail login page is unnecessary.  Common uses of this plugin are for environments that employ HTTP authentication or have implemented single sign-on systems.  Remember that SquirrelMail still needs to authenticate against your IMAP server, so SquirrelMail still needs to know what credentials to use and how to get them.  Assuming you\'ve coordinated your IMAP authentication with your external web authentication, this plugin helps with those tasks.',
                 'per_version_requirements' => array(
                    '1.5.2' => array(
                       'required_plugins' => array()
                    ),
                    '1.5.0' => array(
                       'required_plugins' => array(
                          'compatibility' => array(
                             'version' => '2.0.7',
                             'activate' => FALSE,
                          )
                       )
                    ),
                    '1.4.10' => array(
                       'required_plugins' => array()
                    ),
                    '1.4.0' => array(
                       'required_plugins' => array(
                          'compatibility' => array(
                             'version' => '2.0.7',
                             'activate' => FALSE,
                          )
                       )
                    ),
                 ),
               );

}



/**
  * Returns version info about this plugin
  *
  */
function login_auth_version()
{
   $info = login_auth_info();
   return $info['version'];
}



/**
  * Verify that an externally logged-in user's
  * (external) login session is still valid
  *
  */
function login_auth_verify_login_stub()
{
   include_once(SM_PATH . 'plugins/login_auth/functions.php');
   login_auth_verify_login();
}



/**
  * Check if user has already authenticated themselves;
  * can we skip login page?
  *
  */
function login_auth_skip_login_stub()
{
   include_once(SM_PATH . 'plugins/login_auth/functions.php');
   login_auth_skip_login();
}



/**
  * Make sure to use alternative auth credentials when
  * logging in if needed
  *
  */
function login_auth_login_before_stub()
{
   include_once(SM_PATH . 'plugins/login_auth/functions.php');
   login_auth_login_before();
}



/**
  * Change the signout page
  *
  */
function login_auth_logout_stub()
{
   include_once(SM_PATH . 'plugins/login_auth/functions.php');
   login_auth_logout();
}



/**
  * Change the login link on error pages
  *
  */
function login_auth_error_login_link_stub(&$args)
{
   include_once(SM_PATH . 'plugins/login_auth/functions.php');
   login_auth_error_login_link($args);
}



/**
  * Validate that this plugin is configured correctly
  *
  * @return boolean Whether or not there was a
  *                 configuration error for this plugin.
  *
  */
function login_auth_check_configuration_stub()
{
   include_once(SM_PATH . 'plugins/login_auth/configtest.php');
   return login_auth_check_configuration();
}



