<?php

/**
  * SquirrelMail Login Authentication Plugin
  *
  * Copyright (c) 2004-2012 Paul Lesniewski <paul@squirrelmail.org>,
  * Copyright (c) 2001 Tyler Akins
  *
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage login_auth
  *
  */


// define page name - mimick the core signout page by
// masquerading as the same PAGE_NAME (un-auth'd users
// don't get a "you must log in to access this page" error)
//
define('PAGE_NAME', 'signout');



// set up SquirrelMail environment
//
if (file_exists('../../include/init.php'))
   include_once('../../include/init.php');
else if (file_exists('../../include/validate.php'))
{
   define('SM_PATH', '../../');
   include_once(SM_PATH . 'include/validate.php');
}
else
{
// not compatible with SM version less than 1.4.0
die('Sorry, the Login Authentication plugin is not compatible with SquirrelMail versions less than 1.4.0');
   chdir('..');
   define('SM_PATH', '../');
   include_once(SM_PATH . 'src/validate.php');
}



// Make sure plugin is activated!
//
global $plugins;
if (!in_array('login_auth', $plugins))
   exit;



// make sure session_expire_* data is wiped
//
$login_uri = sqm_baseuri() . 'src/login.php';
do_hook('logout', $login_uri);
sq_change_text_domain('login_auth');
sqsession_destroy();



if (check_sm_version(1, 5, 2))
{

   //
   // copied from 1.5.2 src/signout.php
   //

   /* After a reload of signout.php, $oTemplate might not exist anymore.
    * Recover, so that we don't get all kinds of errors in that situation. */
   if ( !isset($oTemplate) || !is_object($oTemplate) ) {
      require_once(SM_PATH . 'class/template/Template.class.php');
      $sTemplateID = Template::get_default_template_set();
      $icon_theme_path = !$use_icons ? NULL : Template::calculate_template_images_directory($sTemplateID);
      $oTemplate = Template::construct_template($sTemplateID);

      // We want some variables to always be available to the template
      $oTemplate->assign('javascript_on', checkForJavascript());
      $oTemplate->assign('base_uri', sqm_baseuri());
      $always_include = array('sTemplateID', 'icon_theme_path');
      foreach ($always_include as $var) {
         $oTemplate->assign($var, (isset($$var) ? $$var : NULL));
      }
   }

   // The error handler object is probably also not initialized on a refresh
   $oErrorHandler = new ErrorHandler($oTemplate,'error_message.tpl');

   /* internal gettext functions will fail, if language is not set */
   set_up_language($squirrelmail_language, true, true);

   displayHtmlHeader($org_title . ' - ' . _("Signout Incomplete"));

   $oTemplate->assign('frame_top', $frame_top);
   $oTemplate->assign('login_uri', $login_uri);

   $oTemplate->display('plugins/login_auth/login_auth_signout.tpl');

   sq_change_text_domain('squirrelmail');
   $oTemplate->display('footer.tpl');

}
else
{

   //
   // copied from 1.4.16 src/signout.php
   //

   /* internal gettext functions will fail, if language is not set */
   set_up_language($squirrelmail_language, true, true);
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
   <meta name="robots" content="noindex,nofollow">
<?php
    if ($theme_css != '') {
?>
   <link rel="stylesheet" type="text/css" href="<?php echo $theme_css; ?>">
<?php
    }
?>
   <title><?php echo $org_title . ' - ' . _("Signout Incomplete"); ?></title>
</head>
<body text="<?php echo $color[8]; ?>" bgcolor="<?php echo $color[4]; ?>"
link="<?php echo $color[7]; ?>" vlink="<?php echo $color[7]; ?>"
alink="<?php echo $color[7]; ?>">
<br /><br />
<?php
// remove next line login_auth (replace with the following one)
//$plugin_message = concat_hook_function('logout_above_text');
$plugin_message = '';
echo
html_tag( 'table',
    html_tag( 'tr',
         html_tag( 'th', _("Sign Out Not Complete"), 'center' ) ,
    '', $color[0], 'width="100%"' ) .
    $plugin_message .
    html_tag( 'tr',
         html_tag( 'td', _("You must close all instances of this browser to sign out.") .
             '<br /><a href="' . $login_uri . '" target="' . $frame_top . '">' .
             _("Click here to return to your webmail.") . '</a><br />' ,
         'center' ) ,
    '', $color[4], 'width="100%"' ) .
    html_tag( 'tr',
         html_tag( 'td', '<br />', 'center' ) ,
    '', $color[0], 'width="100%"' ) ,
'center', $color[4], 'width="50%" cols="1" cellpadding="2" cellspacing="0" border="0"' )
?>
</body>
</html>
<?php

   sq_change_text_domain('squirrelmail');

}


exit;



