<?php

/**
  * SquirrelMail Login Authentication Plugin
  *
  * Copyright (c) 2004-2012 Paul Lesniewski <paul@squirrelmail.org>,
  * Copyright (c) 2001 Tyler Akins
  *
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage login_auth
  *
  */



/**
  * Validate that this plugin is configured correctly
  *
  * @return boolean Whether or not there was a
  *                 configuration error for this plugin.
  *
  */
function login_auth_check_configuration()
{

   // only need to do this pre-1.5.2, as 1.5.2 will make this
   // check for us automatically
   //
   if (!check_sm_version(1, 5, 2))
   {

      // if running 1.4.10+ (but not 1.5.0 or 1.5.1)
      // this test does not need to be performed
      //
      if (check_sm_version(1, 4, 10) && !check_sm_version(1, 5, 0))
      { /* no-op */ }


      // otherwise, try to find Compatibility, and
      // then that it is v2.0.7+
      //
      else
      {
         if (function_exists('check_plugin_version')
          && check_plugin_version('compatibility', 2, 0, 7, TRUE))
         { /* no-op */ }


         // something went wrong
         //
         else
         {
            do_err('The Login Authentication plugin requires the Compatibility plugin version 2.0.7+', FALSE);
            return TRUE;
         }
      }

   }


   // make sure plugin is correctly configured
   //
   include_once(SM_PATH . 'plugins/login_auth/functions.php');
   if (!login_auth_init())
   {
      do_err('The Login Authentication plugin is not configured correctly', FALSE);
      return TRUE;
   }


   global $external_auth_validation_type, $trusted_saml_username,
          $trusted_saml_password, $imap_auth_mech, $required_environment_variable,
          $required_environment_variable_value_type,
          $required_environment_variable_value, $authenticated_saml_compress_assertion;


   if ($external_auth_validation_type == 'trusted_saml')
   {
      if (!check_sm_version(1, 4, 23)
       || check_sm_version(1, 5, 0)
       || check_sm_version(1, 5, 1))
      {
         do_err('When using the "trusted_saml" module for the Login Authentication plugin, SquirrelMail version 1.4.23+ is required', FALSE);
         return TRUE;
      }


      if ($imap_auth_mech != 'plain')
      {
         do_err('When using the "trusted_saml" module for the Login Authentication plugin, $imap_auth_mech must be set to "plain"', FALSE);
         return TRUE;
      }


      if (empty($trusted_saml_username) || empty($trusted_saml_password))
      {
         do_err('When using the "trusted_saml" module for the Login Authentication plugin, $trusted_saml_username and $trusted_saml_password cannot be left empty', FALSE);
         return TRUE;
      }

   }


   else if ($external_auth_validation_type == 'authenticated_saml')
   {
      if ($authenticated_saml_compress_assertion && !function_exists('gzcompress'))
      {
         do_err('When using the "authenticated_saml" module for the Login Authentication plugin, you cannot enable $authenticated_saml_compress_assertion without PHP Zlib support.  See http://php.net/manual/en/zlib.installation.php', FALSE);
         return TRUE;
      }
   }


   if ($external_auth_validation_type != 'http_auth')
   {

      if (empty($required_environment_variable))
      {
         do_err('When using the "authenticated_saml" or "trusted_saml" module for the Login Authentication plugin, it is highly recommended that you also configure $required_environment_variable', FALSE);
         return FALSE;
      }


      else if ($required_environment_variable_value_type !== 0
       && $required_environment_variable_value_type !== 1
       && $required_environment_variable_value_type !== 2)
      {
         do_err('When using $required_environment_variable in the Login Authentication plugin, $required_environment_variable_value_type must be 0, 1 or 2', FALSE);
         return TRUE;
      }


      if ($required_environment_variable_value_type === 0
       && empty($required_environment_variable_value))
      {
         do_err('When $required_environment_variable_value_type is set to 0 in the Login Authentication plugin, $required_environment_variable_value should not be empty', FALSE);
         return TRUE;
      }

   }


//TODO: what else can we test?


   return FALSE;

}



