<?php

/**
  * SquirrelMail Login Auth Plugin
  * Copyright (c) 2001 Tyler Akins
  * Copyright (c) 2004-2008 Paul Lesniewski <paul@squirrelmail.org>,
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage login_auth
  *
  */


/**
  * Register this plugin with SquirrelMail
  *
  */
function squirrelmail_plugin_init_login_auth()
{

   global $squirrelmail_plugin_hooks;


   // check if user has already authenticated themselves; can we skip login page?
   //
   $squirrelmail_plugin_hooks['login_cookie']['login_auth']
      = 'login_auth_skip_login';


   // make sure to use alternative auth credentials (from HTTP request) when logging in
   //
   $squirrelmail_plugin_hooks['login_before']['login_auth']
      = 'login_auth_login_before';


   // change the signout page
   //
   $squirrelmail_plugin_hooks['logout']['login_auth']
      = 'login_auth_logout';

}



/**
  * Returns info about this plugin
  *
  */
function login_auth_info()
{

   return array(
                 'english_name' => 'Login: HTTP Authentication',
                 'authors' => array(
                    'Paul Lesniewski' => array(
                       'email' => 'paul@squirrelmail.org',
                       'sm_site_username' => 'pdontthink',
                    ),
                    'Tyler Akins' => array(
                    ),
                 ),
                 'version' => '2.1',
                 'required_sm_version' => '1.4.0',
                 'requires_configuration' => 0,
                 'requires_source_patch' => 0,
                 'summary' => 'If you keep SquirrelMail behind a password-protected directory, this plugin will log the user in automatically with the same username/password credentials.', 
                 'details' => 'If you keep SquirrelMail behind a password-protected directory on your web server and if PHP has access to the username and password used by the web server, this plugin will bypass the login screen and use that username/password pair.<br /><br />If you have not password-protected your SquirrelMail directory, this plugin will turn itself off, and logins will work as they normally do using the SquirrelMail login page.',
                 'per_version_requirements' => array(
                    '1.5.2' => array(
                       'required_plugins' => array()
                    ),
                    '1.5.0' => array(
                       'required_plugins' => array(
                          'compatibility' => array(
                             'version' => '2.0.7',
                             'activate' => FALSE,
                          )
                       )
                    ),
                    '1.4.10' => array(
                       'required_plugins' => array()
                    ),
                    '1.4.9' => array(
                       'required_plugins' => array(
                          'compatibility' => array(
                             'version' => '2.0.7',
                             'activate' => FALSE,
                          )
                       )
                    ),
                 ),
               );

}



/**
  * Returns version info about this plugin
  *
  */
function login_auth_version()
{
   $info = login_auth_info();
   return $info['version'];
}



/**
  * Check if user has already authenticated themselves;
  * can we skip login page?
  *
  */
function login_auth_skip_login()
{
   include_once(SM_PATH . 'plugins/login_auth/functions.php');
   login_auth_skip_login_do();
}



/**
  * Make sure to use alternative auth credentials (from HTTP
  * request) when logging in
  *
  */
function login_auth_login_before()
{
   include_once(SM_PATH . 'plugins/login_auth/functions.php');
   login_auth_login_before_do();
}



/**
  * Change the signout page
  *
  */
function login_auth_logout()
{
   include_once(SM_PATH . 'plugins/login_auth/functions.php');
   login_auth_logout_do();
}



