<?php
/*  $Id: setup.php,v 1.2 2002/12/11 06:30:55 dminor Exp $
 *  Login:Alias Plugin
 * 
 *  Copyright (C) 2001 Jay Guerette <JayGuerette_at_pobox.com>
 *  Copyright (C) 2002 David Minor <dave_at_dminor.com>
 *  
 *  Thanks to Christian Schneider <schneider_at_uni-dortmund.de> and
 *	Emerson <emereson_at_inetintl.com>
 *  for their contributions.
 *
 *  Please address questions about this plugin to the squirrelmail-plugins
 *  mailing list.
 *
 *  View the README document for information on installing this.  Also view
 *  plugins/README.plugins for more information.
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *  
 *  See the complete text at <../../COPYING>
 *  
 */

function squirrelmail_plugin_init_login_alias() {
    global $squirrelmail_plugin_hooks;

    $squirrelmail_plugin_hooks['login_before']['login_alias'] 
        = 'login_alias_lookup_alias';
    $squirrelmail_plugin_hooks['options_personal_inside']['login_alias'] 
        = 'login_alias_options_set';
    $squirrelmail_plugin_hooks['options_personal_save']['login_alias'] 
        = 'login_alias_options_save';
}

/* called in redirect.php */
function login_alias_lookup_alias() {
    global $login_username;
    global $$login_username;
    global $plugins;
    global $data_dir;
    global $prefs_are_cached;
    global $prefs_cache;

    $username=$login_username;
    
    /* if password_forget is loaded, use the obfuscated name */
    if (in_array('password_forget',$plugins) && $$login_username!="") {
        $username=$$login_username;
    }

    $filename = $data_dir.'login_alias.pref';
    if (file_exists($filename)) {
        $realname=getPref($data_dir,'login_alias',$username);
        $prefs_are_cached = false;
        $prefs_cache = array();
        session_unregister('prefs_are_cached');
    }


    if (!isset($realname) || $realname=='') return;

    /* if password_forget is loaded, use the obfuscated name */
    if (in_array('password_forget',$plugins) && $$login_username!="") 
        $$login_username=$realname;
    else 
        $login_username=$realname;
    }

/* called in options_personal.php */
function login_alias_options_set() {
    global $data_dir;
    global $username;

    $login_alias=getPref($data_dir,$username,'login_alias');
    echo "<tr>\t<td align=right nowrap>Login Alias\n\t</td><td>\n\t";
    echo "<input size=50 type=text value='$login_alias' name=login_alias>\n\t";
    echo "</td>\n</tr>\n";

}

/* called in options.php */
function login_alias_options_save() {
    global $login_alias;
    global $data_dir;
    global $username;
    global $prefs_are_cached;
    global $prefs_cache;

    $filename = $data_dir.'login_alias.pref';
    if (file_exists($filename) && (isset($login_alias) && $login_alias != '')) {

	/* Remove duplicated cached prefs for login_alias file */
	$old_login_alias=getPref($data_dir,$username,'login_alias');
	$alias_email=getPref($data_dir,'login_alias',$login_alias);
	if ( $alias_email != $username && !empty($alias_email) ) {
	    include_once( '../functions/display_messages.php');
	    plain_error_message("Alias has already used. Please use another alias.", $color);	    
	} else {
            $prefs_are_cached = false;
	    $prefs_cache = array();
            cachePrefValues($data_dir, 'login_alias');
	    removePref($data_dir,'login_alias',$old_login_alias);	

        /* change cached prefs for login_alias file */
        /* for writing changes                      */
        $prefs_are_cached = false;
        $prefs_cache = array();
        cachePrefValues($data_dir, 'login_alias');
        setPref($data_dir,'login_alias',$login_alias,$username);

		$prefs_are_cached = false;
		$prefs_cache = array();
		cachePrefValues($data_dir, $username);
		setPref($data_dir,$username,'login_alias',$login_alias);

        /* change cached prefs back to users */
        $prefs_are_cached = false;
        $prefs_cache = array();
        session_register('prefs_are_cached');
        cachePrefValues($data_dir, $username);
	
	}
    
    }
}
?>
