<?php
/*  $Id: setup.php,v 1.3 2003/02/03 06:30:55 dminor Exp $
 *  Login:Alias Plugin
 * 
 *  Copyright (C) 2001 Jay Guerette <JayGuerette_at_pobox.com>
 *  Copyright (C) 2002 David Minor <dave_at_dminor.com>
 *  
 *  Thanks to Christian Schneider <schneider_at_uni-dortmund.de> and
 *	Emerson <emereson_at_inetintl.com>
 *  for their contributions.
 *
 *  Please address questions about this plugin to the squirrelmail-plugins
 *  mailing list.
 *
 *  View the README document for information on installing this.  Also view
 *  plugins/README.plugins for more information.
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *  
 *  See the complete text at <../../COPYING>
 *  
 */



// include compatibility plugin
//
if (defined('SM_PATH'))
   include_once(SM_PATH . 'plugins/compatibility/functions.php');
else if (file_exists('../plugins/compatibility/functions.php'))
   include_once('../plugins/compatibility/functions.php');
else if (file_exists('./plugins/compatibility/functions.php'))
   include_once('./plugins/compatibility/functions.php');



/* called in redirect.php */
function login_alias_lookup_alias_do() {
    global $login_username;
    global $$login_username;
    global $plugins;
    global $data_dir;
    global $prefs_are_cached;
    global $prefs_cache;
    global $foundLoginAlias;
    global $prefs_dsn;


    // figure out where prefs are stored
    //
    if (isset($prefs_dsn) && !empty($prefs_dsn))
        $prefsInDB = true;
    else
        $prefsInDB = false;


    $user=$login_username;
    
    // if password_forget is loaded, use the obfuscated name
    if (in_array('password_forget',$plugins)) {
      if (!isset($$login_username)) compatibility_sqextractGlobalVar($login_username);
      if ($$login_username != '')
        $user=$$login_username;
    }

    $filename = $data_dir.'login_alias.pref';
    if ((!$prefsInDB && file_exists($filename)) || $prefsInDB) {
        $prefs_are_cached = false;
        $realname=getPref($data_dir,'login_alias',$user);
        $prefs_are_cached = false;
        $prefs_cache = array();
        session_unregister('prefs_are_cached');
    }

    $foundLoginAlias = 0;

    if (!isset($realname) || $realname=='') return;

    $foundLoginAlias = 1;

    /* if password_forget is loaded, use the obfuscated name */
    if (in_array('password_forget',$plugins) && $$login_username!='') 
        $$login_username=$realname;
    else 
        $login_username=$realname;
}

/* called in options_personal.php */
function login_alias_options_set_do() {
    global $data_dir;
    global $username;

    $login_alias=getPref($data_dir,$username,'login_alias');
    echo "<tr>\t<td align=right nowrap>" . _("Login Alias") . "\n\t</td><td>\n\t";
    echo "<input size=50 type=text value='$login_alias' name=login_alias>\n\t";
    echo "</td>\n</tr>\n";
    echo "<tr>\t<td align=right nowrap></td><td>";
    echo _("You can use this or your regular account name to log in to your account.");
    echo "<br><br>\n\t";
    echo "</td>\n</tr>\n";

}

/* called in options.php */
function login_alias_options_save_do() {
    global $login_alias;
    global $data_dir;
    global $username;
    global $prefs_are_cached;
    global $prefs_cache;
    global $color;
    global $prefs_dsn;


    compatibility_sqextractGlobalVar('login_alias');


    // figure out where prefs are stored
    //
    if (isset($prefs_dsn) && !empty($prefs_dsn))
        $prefsInDB = true;
    else
        $prefsInDB = false;
    

    $filename = $data_dir.'login_alias.pref';
    if (((!$prefsInDB && file_exists($filename)) || $prefsInDB)
       && (isset($login_alias) && $login_alias != '')) {

	/* Remove duplicated cached prefs for login_alias file */
	$prefs_are_cached = false;
	session_unregister('prefs_are_cached');
	$alias_email=getPref($data_dir,'login_alias',$login_alias);
	$old_login_alias=getPref($data_dir,$username,'login_alias');
	if ( $alias_email != $username && !empty($alias_email) ) {
	    include_once( '../functions/display_messages.php');
	    plain_error_message(_("Alias is already in use.  Please select another alias.") . "<br><br>", $color);	    
	} else {

// These are redundant... should be removed if we can verify that older SM versions don't need them
//	$prefs_are_cached = false;
//	$prefs_cache = array();
//	cachePrefValues($data_dir, 'login_alias');
//	removePref($data_dir,'login_alias',$old_login_alias);	

        /* change cached prefs for login_alias file */
        /* for writing changes                      */
        $prefs_are_cached = false;
        $prefs_cache = array();
        cachePrefValues($data_dir, 'login_alias');
	    removePref($data_dir,'login_alias',$old_login_alias);	
        setPref($data_dir,'login_alias',$login_alias,$username);

		$prefs_are_cached = false;
		$prefs_cache = array();
		cachePrefValues($data_dir, $username);
		setPref($data_dir,$username,'login_alias',$login_alias);

        /* change cached prefs back to users */
        $prefs_are_cached = false;
        $prefs_cache = array();
        session_register('prefs_are_cached');
        cachePrefValues($data_dir, $username);
	
	}
    
    }
}


?>
