<?php
   /*
    *  Login:Alias Plugin
    *  By Jay Guerette <JayGuerette@pobox.com>
    *  (c) 2001 (GNU GPL - see ../../COPYING)
    *
    *  If you need help with this, or see improvements that can be made, please
    *  email me directly at the address above.  I definately welcome suggestions
    *  and comments.  This plugin, as is the case with all SquirrelMail plugins,
    *  is not directly supported by the developers.  Please come to me off the
    *  mailing list if you have trouble with it.
    *
    *  View the README document for information on installing this.  Also view
    *  plugins/README.plugins for more information.
    *
    */

   function squirrelmail_plugin_init_login_alias() {
      global $squirrelmail_plugin_hooks;

      $squirrelmail_plugin_hooks['login_before']['login_alias'] = 'login_alias_lookup_alias';
      $squirrelmail_plugin_hooks['options_personal_inside']['login_alias'] = 'login_alias_options_set';
      $squirrelmail_plugin_hooks['options_personal_save']['login_alias'] = 'login_alias_options_save';
   }

   // called in redirect.php
   function login_alias_lookup_alias() {
	global $login_username;
  	global $$login_username;
	global $plugins;
	global $data_dir;

	$username=$login_username;
	
	// if password_forget is loaded, use the obfuscated name
	if (in_array('password_forget',$plugins) && $$login_username!="") {
          	$username=$$login_username;
	}

	$filename = $data_dir.'login_alias.pref';
	if (file_exists($filename)) $realname=getPref($data_dir,'login_alias',$username);
	if (!isset($realname) || $realname=='') return;

	// if password_forget is loaded, use the obfuscated name
	if (in_array('password_forget',$plugins) && $$login_username!="") $$login_username=$realname;
	else $login_username=$realname;
   }

   // called in options_personal.php
   function login_alias_options_set() {
	global $data_dir;
	global $username;
	
	$login_alias=getPref($data_dir,$username,'login_alias');
	echo "<tr>\t<td align=right nowrap>Login Alias\n\t</td><td>\n\t";
	echo "<input size=50 type=text value='$login_alias' name=login_alias>\n\t";
	echo "</td>\n</tr>\n";

   }

   // called in options.php
   function login_alias_options_save() {
	global $login_alias;
	global $data_dir;
	global $username;

	$filename = $data_dir.'login_alias.pref';
	if (file_exists($filename) && isset($login_alias)) {
		setPref($data_dir,'login_alias',$login_alias,$username);
		setPref($data_dir,$username,'login_alias',$login_alias);
	}
   }
?>
