<?php

/**
  * SquirrelMail Lockout Plugin
  * Copyright (c) 2004-2008 Paul Lesniewski <paul@squirrelmail.org>
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage lockout
  *
  */



/**
  * Register this plugin with SquirrelMail
  *
  */
function squirrelmail_plugin_init_lockout() 
{

   global $squirrelmail_plugin_hooks;

   $squirrelmail_plugin_hooks['configtest']['lockout']
      = 'lockout_configtest';

   $squirrelmail_plugin_hooks['logout_error']['lockout'] 
      = 'check_failed_login_count';

   $squirrelmail_plugin_hooks['login_verified']['lockout'] 
      = 'reset_failed_login_count';

   $squirrelmail_plugin_hooks['prefs_backend']['lockout'] 
      = 'move_lockout_to_end_of_login_before_hook';
   $squirrelmail_plugin_hooks['loading_constants']['lockout'] 
      = 'move_lockout_to_end_of_login_before_hook';

   $squirrelmail_plugin_hooks['login_before']['lockout'] 
      = 'check_lockout';

   $squirrelmail_plugin_hooks['login_cookie']['lockout'] 
      = 'activate_captcha_plugin';

}



/** @ignore */
if (!defined('SM_PATH')) define('SM_PATH', '../');



/**
  * Returns info about this plugin
  *
  */
function lockout_info()
{

   return array(
                  'english_name' => 'Lockout',
                  'authors' => array(
                     'Paul Lesniewski' => array(
                        'email' => 'paul@squirrelmail.org',
                        'sm_site_username' => 'pdontthink',
                     ),
                  ),
                  'version' => '1.5',
                  'required_sm_version' => '1.4.1',
                  'requires_configuration' => 1,
                  'requires_source_patch' => 0,
                  'summary' => 'Specify a list of users or domains that should be disallowed login access and/or stop brute-force password guessing attacks.',
                  'details' => 'This plugin allows you to create a list of users and/or domains that should be disallowed login access to SquirrelMail.  It also allows you to block brute-force password guessing attacks, although please note that this will ONLY help fight such attacks in the SquirrelMail interface, and should really be implemented in your mail system\'s authentication backend.',
                  'required_plugins' => array(
                     'compatibility' => array(
                        'version' => '2.0.11',
                        'activate' => FALSE,
                     )
                  )
               );

}



/**
  * Returns version info about this plugin
  *
  */
function lockout_version() 
{

   $info = lockout_info();
   return $info['version'];

}



/**
  * Validate that this plugin is configured correctly
  *
  */
function lockout_configtest()
{

   include_once(SM_PATH . 'plugins/lockout/functions.php');
   lockout_configtest_do();

}



/**
  * Checks for prior violations of maximum failed login attempts
  * as well as the rules for what users can and can't log in.
  *
  */
function check_lockout($args)
{

   include_once(SM_PATH . 'plugins/lockout/functions.php');
   check_lockout_do($args);

}



/**
  * Check number of successive failed login attempts
  * and block user permanently if necessary
  *
  */
function check_failed_login_count($args)
{

   include_once(SM_PATH . 'plugins/lockout/functions.php');
   check_failed_login_count_do($args);

}



/**
  * Valid login - reset failure count
  *
  */
function reset_failed_login_count()
{

   include_once(SM_PATH . 'plugins/lockout/functions.php');
   reset_failed_login_count_do();

}



/**
  * Make sure this plugin fires the LAST on the login_before
  * hook
  *
  */
function move_lockout_to_end_of_login_before_hook()
{

   include_once(SM_PATH . 'plugins/lockout/functions.php');
   move_lockout_to_end_of_login_before_hook_do();

}



/**
  * Activate the CAPTCHA plugin if need be
  *
  */
function activate_captcha_plugin($args)
{

   include_once(SM_PATH . 'plugins/lockout/functions.php');
   activate_captcha_plugin_do($args);

}



