<?php

global $at;


// you may change this if your usernames are in the form of 
// regular email addresses, but the "at" symbol is different
//
$at = '@';



// include compatibility plugin
//
if (defined('SM_PATH'))
   include_once(SM_PATH . 'plugins/compatibility/functions.php');
else if (file_exists('../plugins/compatibility/functions.php'))
   include_once('../plugins/compatibility/functions.php');
else if (file_exists('./plugins/compatibility/functions.php'))
   include_once('./plugins/compatibility/functions.php');



// parses a table that lists domains and/or users that are
// to be locked out and not allowed to log in
//
function check_lockout_do()
{

   global $username, $at;


   $user = $username;


   // get global variable for versions of PHP < 4.1
   //
   if (!compatibility_check_php_version(4,1)) {
      global $HTTP_SERVER_VARS;
      $_SERVER = $HTTP_SERVER_VARS;
   }


   // grab hostname into local var
   //
   $host = $_SERVER['HTTP_HOST'];


   // get the domain from the username, since it might
   // be different than the domain being used to log in
   //
   if (strpos($user, $at) !== FALSE)
      $usersDomain = substr($user, strpos($user, $at) + 1);
   else
      $usersDomain = '';


   if (!defined('SM_PATH')) define('SM_PATH', '../');


   if ($LOCKOUTTABLE = @fopen (SM_PATH . 'plugins/lockout/data/lockout_table.dat', 'r'))
   {

      while (!feof($LOCKOUTTABLE))
      {

         $line = fgets($LOCKOUTTABLE, 4096);
         $line = trim($line);


         // skip blank lines and comment lines
         //
         if (strpos($line, '#') === 0 || strlen($line) < 3)
            continue;


         // if we have a hostname from the username, see if this is 
         // a domain lockout line
         //
         if (!empty($usersDomain) && preg_match('/^\s*domain:\s*(\S+)\s+(.+)\s*$/', $line, $matches))
         {

            // check for match with hostname, redirect if found
            //
            if (preg_match('/^' . str_replace(array('?', '*'), array('\w{1}', '.*?'), 
                          strtoupper($matches[1])) . '$/', strtoupper($usersDomain)))
            {
               fclose($LOCKOUTTABLE);
               sqsession_destroy();
               header('Location: ../plugins/lockout/' . $matches[2]);
               exit;
            }

         }


         // if we were given a hostname, see if this is 
         // a domain lockout line
         //
         if (!empty($host) && preg_match('/^\s*domain:\s*(\S+)\s+(.+)\s*$/', $line, $matches))
         {

            // check for match with hostname, redirect if found
            //
            if (preg_match('/^' . str_replace(array('?', '*'), array('\w{1}', '.*?'), 
                          strtoupper($matches[1])) . '$/', strtoupper($host)))
            {
               fclose($LOCKOUTTABLE);
               sqsession_destroy();
               header('Location: ../plugins/lockout/' . $matches[2]);
               exit;
            }

         }


         // if we were given a username, see if this is 
         // a user lockout line
         //
         if (!empty($user) && preg_match('/^\s*user:\s*(\S+)\s+(.+)\s*$/', $line, $matches))
         {

            // check for match with username, redirect if found
            //
            if (preg_match('/^' . str_replace(array('?', '*'), array('\w{1}', '.*?'), 
                          strtoupper($matches[1])) . '$/', strtoupper($user)))
            {
               fclose($LOCKOUTTABLE);
               sqsession_destroy();
               header('Location: ../plugins/lockout/' . $matches[2]);
               exit;
            }

         }

      }

      fclose($LOCKOUTTABLE);

   }

}


?>
