<?php

/**
  * SquirrelMail Local User Autoresponder and Mail Forwarder Plugin
  * Copyright (c) 2004-2007 Jonathan Bayer <jbayer@spamcop.net>,
  *                         Paul Lesniewski <paul@squirrelmail.org>,
  *                         Dan Astoorian
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage local_autorespond_forward
  *
  */



/**
  * Inserts link to the configuration page
  * in main SM options page
  *
  */
function laf_option_link_do() 
{

   global $optpage_blocks, $maintain_autoresponder, 
          $maintain_forwarding, $forward_file;

   local_autorespond_forward_init();

   if (!$maintain_autoresponder && !$maintain_forwarding)
      die('Local User Autoresponder and Mail Forwarder plugin cannot have both $maintain_autoresponder and $maintain_forwarding turned off');
   if (empty($forward_file) && $maintain_forwarding)
      die('Local User Autoresponder and Mail Forwarder plugin cannot have $maintain_forwarding turned on without also having $forward_file configured');

   sq_change_text_domain('local_autorespond_forward');

   if ($maintain_autoresponder)
   {

      // all functionalities turned on
      //
      if ($maintain_forwarding)
      {
         $title = _("Autoresponder / Mail Forwarding");
         $desc = _("Set up an auto-reply message and optionally forward your incoming email to other addresses. This can be useful when you are away on vacation.");
      }

      // only an autoresponder - no forwarding
      //
      else
      {
         $title = _("Autoresponder");
         $desc = _("Set up an auto-reply message for you incoming email. This can be useful when you are away on vacation.");
      }
   }

   // only mail forwarding
   //
   else
   {
      $title = _("Mail Forwarding");
      $desc = _("Set up other email addresses to which your incoming messages will be forwarded.");
   }

   $optpage_blocks[] = array(
      'name' => $title,
      'url' => SM_PATH . 'plugins/local_autorespond_forward/options.php',
      'desc' => $desc,
      'js' => FALSE
   );

   sq_change_text_domain('squirrelmail');

}



/**
  * Initialize this plugin (load config values)
  *
  * @return boolean FALSE if no configuration file could be loaded, TRUE otherwise
  *
  */
function local_autorespond_forward_init()
{

   if (!@include_once(SM_PATH . 'plugins/local_autorespond_forward/config.php'))
      return FALSE;

   return TRUE;

}



/**
  * Validate that this plugin is configured correctly
  *
  * @return boolean Whether or not there was a
  *                 configuration error for this plugin.
  *
  */
function local_autorespond_forward_check_configuration_do()
{

   // make sure base config is available
   //
   if (!local_autorespond_forward_init())
   {
      do_err('Local User Autoresponder and Mail Forwarder plugin is missing its main configuration file', FALSE);
      return TRUE;
   }


   // make sure configuration is not b0rked
   //
   global $maintain_autoresponder, $maintain_forwarding, $forward_file;
   if (!$maintain_autoresponder && !$maintain_forwarding)
   {
      do_err('Local User Autoresponder and Mail Forwarder plugin cannot have both $maintain_autoresponder and $maintain_forwarding turned off', FALSE);
      return TRUE;
   }
   if (empty($forward_file) && $maintain_forwarding)
   {
      do_err('Local User Autoresponder and Mail Forwarder plugin cannot have $maintain_forwarding turned on without also having $forward_file configured', FALSE);
      return TRUE;
   }


   // only need to do this pre-1.5.2, as 1.5.2 will make this
   // check for us automatically
   //
   if (!check_sm_version(1, 5, 2))
   {

      // 1.4.10+ gets a pass on Compatibility plugin
      //
      if (check_sm_version(1, 5, 0) || !check_sm_version(1, 4, 10))
      {

         // try to find Compatibility, and then that it is v2.0.7+
         //
         if (function_exists('check_plugin_version')
          && check_plugin_version('compatibility', 2, 0, 7, TRUE))
            return FALSE;


         // something went wrong
         //
         do_err('Local User Autoresponder and Mail Forwarder plugin requires the Compatibility plugin version 2.0.7+', FALSE);
         return TRUE;

      }

   }

   return FALSE;

}



