<?php
/**
 * Limit Languages plugin setup script.
 * 
 * Copyright (c) 2005 Tomas Kuliavas <tokul@users.sourceforge.net>
 * This file is part of SquirrelMail Limit Languages plugin.
 *
 * Limit Languages plugin is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Limit Languages plugin is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Limit Languages plugin; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @copyright (c) 2005 Tomas Kuliavas <tokul@users.sourceforge.net>
 * @version $Id: setup.php,v 1.3 2005/06/26 09:01:40 tokul Exp $
 * @package sm-plugins
 * @subpackage limit_languages
 */

/** @ignore */
if (! defined('SM_PATH')) define('SM_PATH','../');

/**
 * Init plugin
 */
function squirrelmail_plugin_init_limit_languages() {
    global $squirrelmail_plugin_hooks;
    $squirrelmail_plugin_hooks['loading_prefs']['limit_languages']='limit_languages';
    $squirrelmail_plugin_hooks['right_main_after_header']['limit_languages']='limit_languages_warning';
}

/**
 * Filters $languages array
 * 
 * Main function attached to loading_prefs hook.
 */
function limit_languages() {
    include_once(SM_PATH . 'plugins/limit_languages/functions.php');
    limit_languages_function();
}

/**
 * Display warning if plugin is running with default configuration.
 * 
 * Main function attached to right_main_after_header hook
 */
function limit_languages_warning() {
    include_once(SM_PATH . 'plugins/limit_languages/functions.php');
    limit_languages_warning_function();
}

/**
 * Returns plugin version
 * @return string plugin version
 */
function limit_languages_version() {
    return '1.0';
}
?>