<?php

   /**
    **  ldifimport.php
    **  (c)2001 Nic Bernstein, for iTech, Inc.
    **
    **  This file contains the code to manage the import of an LDIF
    **  address book into Squirrelmail.  The address book must conform
    **  to rfc-2849.  Since the RFCs do not specify how a nickname is
    **  identified, we will use the "xmozzillanickname", "xnavnickname"
    **  or "uid" records for the nickname.  This jives with what is 
    **  produced by the interguru converter.
    **
    **/

   chdir("..");

   include('../src/validate.php');
   include("../functions/page_header.php");
   include("../functions/display_messages.php");
   include("../functions/imap.php");
   include("../functions/addressbook.php");
   include("../functions/array.php");
   include("../src/load_prefs.php");

   // Set up the page
   displayPageHeader($color, "None");

   echo "  <br>\n";
   echo "  <table width=95% align=center border=0 cellpadding=2>\n";
   echo "    <tr>\n";
   echo "      <td bgcolor=".$color[0].">\n";
   echo "        <center><b>Address Book Import</b></center>\n";
   echo "      </td>\n";
   echo "    </tr>\n";
   echo "  </table>\n";

   global $username,$data_dir;
   global $submit_ldifimport,$fname;

   // Deal with the submitted form
   if ($submit) {
      echo "  <TABLE cols=5 border=1 width=95%>\n";
      echo "    <TR>\n";
      echo "      <TH width=10%>Nickname</TH>\n";
      echo "      <TH width=20%>First name</TH>\n";
      echo "      <TH width=20%>Last name</TH>\n";
      echo "      <TH width=20%>E-Mail</TH>\n";
      echo "      <TH width=30%>Comment</TH>\n";
      echo "    </TR>\n";

      // Open the imported file for read
      $file = fopen($HTTP_POST_FILES['fname']['tmp_name'], 'r');

      // Open the address book
      $abook = addressbook_init(true, true);
      $n = 0;
      $addaddr = array();

      // Process the file
      while ( !feof ($file)) {
         $line = fgets($file, 1024);
	 $line = trim($line);
	 $line = explode("\r", $line);
	 foreach ($line as $l)
  	    ProcessLine($l, $addaddr, $n, $abook);
      }
      ProcessLine('', $addaddr, $n, $abook);

      // Get rid of the file (happens automatically with PHP)
      fclose($file);

      echo "</TABLE>\n";
      echo "<center> Address book imported ".$n." records </center>";
   }


function ProcessLine($line, &$addaddr, &$n, &$abook)
{
   // Jump to the wrap-up if we have a blank line
   if (strpos($line, ':')) {
      // Parse the line into a key-value pair
      $pair = explode(':',  $line);
      $key = trim($pair[0]);
      $val = trim($pair[1]);

      // Set the appropriate variable based upon the key
      switch ($key) {
         case 'sn':
	    $addaddr['lastname'] = $val;
	    break;
	 case 'cn':
	    if (! isset($addaddr['lastname'])) {
	       $addaddr['lastname'] = $val;
	    } 
	    break;
	 case 'givenname':
	    $addaddr['firstname'] = $val;
	    break;
	 case 'mail': 
	    $addaddr['email'] = $val;
	    break;
	 case 'uid':
	 case 'xnavnickname':
	 case 'xmozillanickname':
	    $addaddr['nickname'] = $val;
	    break;
	 case 'member':
	    // This is part of a list of addresses
	    $mark = strpos( $val, 'mail=') + 5;
	    if (isset( $addaddr['email'] )) {
	       $addaddr['email'] .= ';' ;
	    }
	    $addaddr['email'] .= substr( $val, $mark);
	    break;
	    // Everything below here is gravy
	 case 'description':
	    $addaddr['label'] .= 'Description: ' . $val . '  ' ;
	    break;
	 case 'locality': 
	    $addaddr['label'] .= 'Locality: ' . $val . '  ' ;
	    break;
	 case 'countryname': 
	    $addaddr['label'] .= 'Country: ' . $val . '  ' ;
	    break;
	 case 'homephone': 
	    $addaddr['label'] .= 'Homephone: ' . $val . '  ' ;
	    break;
	 case 'streetaddress':
	    $addaddr['label'] .= 'Streetaddress: ' . $val . '  ' ;
	    break;
	 case 'xmozillaanyphone':
	    $addaddr['label'] .= 'Anyphone: ' . $val . '  ' ;
	    break;
	 case 'title':
	    $addaddr['label'] .= 'Title: ' . $val . '  ' ;
	    break;
	 case 'phone2':
	    $addaddr['label'] .= 'phone2: ' . $val . '  ' ;
	    break;
	 case 'o':
	    $addaddr['label'] .= 'Organization: ' . $val . '  ' ;
	    break;
	 case 'st':
	    $addaddr['label'] .= 'State: ' . $val . '  ' ;
	    break;
	 case 'facsimiletelephonenumber':
	    $addaddr['label'] .= 'Fax: ' . $val . '  ' ;
	    break;
	 case 'ou':
	    $addaddr['label'] .= 'Dept: ' . $val . '  ' ;
	    break;
	 case 'pagerphone':
	    $addaddr['label'] .= 'Pager: ' . $val . '  ' ;
	    break;
	 case 'cellphone':
	    $addaddr['label'] .= 'Cellphone: ' . $val . '  ' ;
	    break;
	 case 'homeurl':
	    $addaddr['label'] .= 'URL: ' . $val . '  ' ;
	    break;
      }
   } else {
      // We've hit a blank line, which separates records
      // so we need to flush this record

      // First, make sure we have something valid to work with
      if (!isset($addaddr['email'])) {
         // Bail out
	 unset($addaddr);
	 return;
      }
      
      // Munge something into a nickname if we have no nickname
      if (!isset( $addaddr['nickname'] )) {
         if (isset( $addaddr['firstname'])) {
	    $addaddr['nickname'] = $addaddr['firstname'];
	 } else if (isset( $addaddr['lastname'])) {
	    $addaddr['nickname'] = $addaddr['lastname'];
	 } else {
	    $parse = explode($addaddr['email'], '@');
	    $addaddr['nickname'] = $parse[0];
	 }
      }
      
      // Set unset values to null or appropriate filler
      if (!isset($addaddr['firstname'])) {
         $addaddr['firstname'] = $addaddr['nickname'];
      }
      if (!isset($addaddr['lastname'])) {
         $addaddr['lastname'] = '';
      }
      if (!isset($addaddr['label'])) {
         $addaddr['label'] = '';
      }
      
      // Insert the record into the address book
      $result = $abook->add($addaddr,$abook->localbackend);
      if(!$result) {
         echo '<tr><td colspan=5>';
         echo 'Error: '.$abook->error."\n";
	 echo "</td></tr>\n";
      } else {
         echo "  <TR>\n";
	 echo '    <TD>'.$addaddr['nickname']."&nbsp;</TD>\n";
	 echo '    <TD>'.$addaddr['firstname']."&nbsp;</TD>\n";
	 echo '    <TD>'.$addaddr['lastname']."&nbsp;</TD>\n";
	 echo '    <TD>'.$addaddr['email']."&nbsp;</TD>\n";
	 echo '    <TD>'.$addaddr['label']."&nbsp;</TD>\n";
	 echo "  </TR>\n";
	 $n++;
      }

      // Clear the variables for the next loop
      unset($addaddr);
   }
}


   echo "Return to the <a href=\"../../src/options.php\">Options</a> page.\n";
?>
