<?php
   /**
    **  ldifimport_opt.php
    **
    **  Displays all options relating to importing an LDIF address book
    **
    **/

   chdir("..");

   session_start();

   if (!isset($config_php))
      include("../config/config.php");
   if (!isset($strings_php))
      include("../functions/strings.php");
   if (!isset($page_header_php))
      include("../functions/page_header.php");
   if (!isset($display_messages_php))
      include("../functions/display_messages.php");
   if (!isset($imap_php))
      include("../functions/imap.php");
   if (!isset($addressbook_php))
      include("../functions/addressbook.php");
   if (!isset($array_php))
      include("../functions/array.php");
   if (!isset($i18n_php))
      include("../functions/i18n.php");

   include("../src/load_prefs.php");
   displayPageHeader($color, "None");

?>
   <br>
   <table width=95% align=center border=0 cellpadding=2 cellspacing=0><tr><td bgcolor="<?php echo $color[0] ?>">
      <center><b><?php echo _("Options") ?> - Address Book Import</b></center>
   </td></tr></table>
<p>
    This page will allow you to import an address book from another 
    e-mail application into <b><i>i</i>WayMail</b>.
</p><p>
    This importer understands the <b>LDIF</b> file format as defined in 
    <a href="ftp://ftp.isi.edu/in-notes/rfc2849.txt" target="blank">
      RFC-2849
    </a>.
    Many e-mail programs, such as NetScape Communicator, will export 
    address books in LDIF format.
</p><p>
    If your program does not, then use the address book converter at:
    <a href="http://www.interguru.com/mailconv.htm" target="blank">
       www.interguru.com
    </a>
    to convert your address book into LDIF format, and then import it here.
</p><p>
    Use the <b>File</b> dialog below to select the address book file.

   <form action="ldifimport.php" method=post ENCTYPE="multipart/form-data">
      <table width=100% cellpadding=0 cellspacing=2 border=0>
        <tr>
            <td align=right nowrap>&nbsp
            </td><td>
               <b>Address Book Filename</b>
               <input type=file name=fname size=48>
            </td>
         </tr>
         <tr>
            <td>&nbsp;
            </td><td>
               <input type="submit" value="Submit" name="submit">
            </td>
         </tr>
      </table>   
   </form>
</body></html>
