<?php

   /**
    **  ldifimport.php
    **  (c)2001 Nic Bernstein, for iTech, Inc.
    **  (c)2002 Nic Bernstein, for Onlight, llc.
    **  v. 1.4 modification (c) 2003 Brad Donison
    **
    **  This file contains the code to manage the import of an LDIF
    **  address book into Squirrelmail.  The address book must conform
    **  to rfc-2849.  Since the RFCs do not specify how a nickname is
    **  identified, we will use the "xmozzillanickname", "xnavnickname"
    **  or "uid" records for the nickname.  This jives with what is 
    **  produced by the interguru converter.
    **
    **/

if (!defined('SM_PATH')) {
   chdir('../');
   define(SM_PATH, '../');
}

// include compatibility plugin
if (file_exists(SM_PATH . 'plugins/compatibility/functions.php'))
   include_once(SM_PATH . 'plugins/compatibility/functions.php');
else if (file_exists('./plugins/compatibility/functions.php'))
      include_once('./plugins/compatibility/functions.php');

if (file_exists(SM_PATH . 'functions/page_header.php'))
   include_once (SM_PATH . 'functions/page_header.php');
else if (file_exists('./functions/page_header.php'))
   include_once ('./functions/page_header.php');
if (file_exists(SM_PATH . 'functions/display_messages.php'))
  include_once (SM_PATH . 'functions/display_messages.php');
else if (file_exists('./functions/display_messages.php'))
  include_once ('./functions/display_messages.php');

if (compatibility_check_sm_version(1, 3)) {
   include_once (SM_PATH . 'include/validate.php');
   include_once (SM_PATH . 'functions/addressbook.php');
   include_once (SM_PATH . 'include/load_prefs.php');
} else {
   include_once ('../src/validate.php');
   include_once ('../functions/addressbook.php');
   include_once ('../src/load_prefs.php');
}

   // Set up the page
   displayPageHeader($color, 'None');

?>
  <br>
  <table width="95%" align="center" border="0" cellpadding="2">
    <tr>
      <td bgcolor="<?php echo $color[0]?>">
        <center><b>Address Book Import</b></center>
      </td>
    </tr>
  </table>
<?php
   global $username, $data_dir, $_POST, $_FILES;

   // Deal with the submitted form
   if ($_POST['submit_ldifimport'] && 
       is_uploaded_file($_FILES['fname']['tmp_name']) &&
       is_readable($_FILES['fname']['tmp_name'])) {
?>
  <TABLE cols="5" border="1" width="95%">
    <TR>
      <TH width=10%>Nickname</TH>
      <TH width=20%>First name</TH>
      <TH width=20%>Last name</TH>
      <TH width=20%>E-Mail</TH>
      <TH width=30%>Comment</TH>
    </TR>
<?php

      // Open the address book
      $abook = addressbook_init(true, true);
      $n = 0;
      $errors = 0;
      $addaddr = array();

      // Open the imported file for read
      $file = file($_FILES['fname']['tmp_name']);

      // As per rfc2849, an end of line may be CR, LF or both CR and LF
      // the "file" command above will only break the file on newlines
      // so we must break it on carriage returns ourselves
      $file = preg_replace('/\r/', "", $file);
      $ldiffilesize = count($file);

      // Process the file
      for ($l=0; $l < $ldiffilesize; $l++) {
         // If the next line begins with a space, then this line
         // is folded (as per rfc2849)
         while (ereg("^ ", $file[$l+1])) {
            // unfold this line by sticking the next line on the end
            $file[$l] .= substr($file[$l+1], 1);

            // remove the next line from the array
            array_splice($file, $l+1, 1);
         }

         // feed this line to the processor, which returns true when it has
         // completed an entry (which may be any number of lines).
         if (ProcessLine($file[$l], $addaddr, $n, $abook, $errors)) {
            // clear the decks for the next entry
            unset($addaddr);
         }
      }
      // flush the processor in case there is no blank line at the end
      ProcessLine('', $addaddr, $n, $abook, $errors);

      echo "  </TABLE>\n";
      echo "  <center> Address book imported ".$n." records ";
      if ($errors > 0) {
        echo "($errors errors)";
      }
      echo "</center>\n";
      if (($errors >= $n) || ($errors >= $GLOBALS['ldif_showblurb']) || ($n == 0)) {
        echo $GLOBALS['ldiff_infoblurb'];
      }
   }
   if ($ldiff_options > 0) {
      echo "Return to the <a href=\"../../src/options.php\">Options</a> page.\n";
   } else {
      echo "Return to your <a href=\"../../src/addressbook.php\">Address Book</a> page.\n";
   }

function ProcessLine($line, &$addaddr, &$n, &$abook, &$errors) {
   // Jump to the wrap-up if we have a blank line
   if (strpos($line, ':')) {
      // Parse the line into a key-value pair.  Everything after the
      // first : will be considered part of the value
      if (strpos($line, '::')) {
         // This value is base64 encoded, so we need to decode it first
         $pair = explode('::',  $line, 2);
         $key = strtolower(trim($pair[0]));
         $val = base64_decode(trim($pair[1]));
      } else {
         $pair = explode(':',  $line, 2);
         $key = strtolower(trim($pair[0]));
         $val = trim($pair[1]);
      }
      // remove double quotation marks
      $val = preg_replace("/[\"]/", '', $val);

      // Set the appropriate variable based on the key
      switch ($key) {
         case 'sn':
	    $addaddr['lastname'] = $val;
	    break;
	 case 'givenname':
         case 'givenName':
         // Mozilla uses givenName
	    $addaddr['firstname'] = $val;
	    break;
	 case 'cn':
	    if (! isset($addaddr['cn'])) {
	       $addaddr['cn'] = $val;
	    } 
	    break;
	 case 'mail': 
	    $addaddr['email'] = $val;
	    break;
	 case 'uid':
	 case 'userid':
	 case 'xnavnickname':
	 case 'xmozillanickname':
	    $addaddr['nickname'] = $val;
	    break;
	 case 'member':
	    // This is part of a list of addresses
	    $mark = strpos( $val, 'mail=') + 5;
            // tack a semi-colon on the end of the email variable
            // if there is one yet.
	    if (isset( $addaddr['email'] )) {
	       $addaddr['email'] .= ';' ;
	    }
	    $addaddr['email'] .= substr( $val, $mark);
            // remember that this is a list entry
            $addaddr['list'] += 1;
	    break;
	    // Everything below here is gravy
	 case 'description':
	    $addaddr['label'] .= 'Description: ' . $val . '  ' ;
	    break;
	 case 'locality': 
         case 'l':
	    $addaddr['label'] .= 'Locality: ' . $val . '  ' ;
	    break;
	 case 'countryname': 
	    $addaddr['label'] .= 'Country: ' . $val . '  ' ;
	    break;
	 case 'homephone': 
	    $addaddr['label'] .= 'Homephone: ' . $val . '  ' ;
	    break;
	 case 'streetaddress':
	    $addaddr['label'] .= 'Streetaddress: ' . $val . '  ' ;
	    break;
	 case 'xmozillaanyphone':
	    $addaddr['label'] .= 'Anyphone: ' . $val . '  ' ;
	    break;
	 case 'title':
	    $addaddr['label'] .= 'Title: ' . $val . '  ' ;
	    break;
	 case 'phone2':
	    $addaddr['label'] .= 'phone2: ' . $val . '  ' ;
	    break;
	 case 'o':
	 case 'organization':
	    $addaddr['label'] .= 'Organization: ' . $val . '  ' ;
	    break;
	 case 'st':
	    $addaddr['label'] .= 'State: ' . $val . '  ' ;
	    break;
	 case 'facsimiletelephonenumber':
	    $addaddr['label'] .= 'Fax: ' . $val . '  ' ;
	    break;
	 case 'ou':
	 case 'organizationalunit':
	    $addaddr['label'] .= 'Dept: ' . $val . '  ' ;
	    break;
	 case 'pagerphone':
	    $addaddr['label'] .= 'Pager: ' . $val . '  ' ;
	    break;
	 case 'cellphone':
	    $addaddr['label'] .= 'Cellphone: ' . $val . '  ' ;
	    break;
	 case 'homeurl':
	    $addaddr['label'] .= 'URL: ' . $val . '  ' ;
	    break;
         case 'objectclass':
            /* Since objectClass is just a housekeeping attribute for
               the LDIF file, we'll toss it out.  If you don't like 
               that, comment this chunk out.
            */
            break;
         /*  Uncomment this stanza if you wish for all attributes in the
             LDIF file to be added to the label for this entry
         */
         /*
         default:
            $addaddr['label'] .= $key . ': ' .$val . '  ' ;
         */
      }
   } else {
      // We've hit a blank line, which separates records
      // so we need to flush this record

      /* We are going to have to be a little clever here.
         If we have a CN entry, but no SN or GivenName then we
         will see if we can chop up the CN into parts for these
         entries
      */
      /* A note on name part division:
         In order to write this function I had to make some assumptions.
         With any piece of software which has a potentially multi-ethnic
         user base, the kinds of assumptions I have made have their own
         pitfalls.  If you have CNs for names with more than two parts,
         such as "Bob van de Hull" or "Mary Beth Smith", and you do not
         have GivenName or SN attributes for these entries this routine
         may not do the right thing with the names.  For example, the
         first one will become firstname="Bob" and lastname="van de Hull"
         whereas the second one will become firstname="Mary" lastname=
         "Beth Smith".  This is cured if the names are formatted as 
         "lastname, firstname" since the algorythm will see the comma,
         and split on that.
      */
      /* Oh yeah, and if the entry had any "member" attributes set, then
         we assumed its a list of names, and that the CN will contain the
         list name, which becomes the nickname.
      */
      if (isset($addaddr['cn'])) {
         if (!isset($addaddr['list'])) {
            if (strpos($addaddr['cn'], ', ')) {
               $nameparts = explode(', ', $addaddr['cn'], 2);
               if (! isset($addaddr['firstname'])) {
                  $addaddr['firstname'] = $nameparts[1];
               }
               if (! isset($addaddr['lastname'])) {
                  $addaddr['lastname'] = $nameparts[0];
               }
            } elseif (strpos($addaddr['cn'], ' ')) {
               $nameparts = explode(' ', $addaddr['cn'], 2);
               if (! isset($addaddr['firstname'])) {
                  $addaddr['firstname'] = $nameparts[0];
               }
               if (! isset($addaddr['lastname'])) {
                  $addaddr['lastname'] = $nameparts[1];
               }
            }
         } else {
            $addaddr['nickname'] = $addaddr['cn'];
            // append a portion of the email address if it makes sence
            if ((strpos($addaddr['email'], '@')) && (!strpos($addaddr['nickname'], '@'))) {
              $parse = explode('@', $addaddr['email']);
              if (isset($parse[1])) {
                $parse = explode('.', $parse[1]);
              }
              $addaddr['nickname'] .= "_" . $parse[0];
            }
         }
      }
         
      // Munge something into a nickname if we have no nickname
      if (!isset( $addaddr['nickname'] )) {
         if (isset( $addaddr['firstname'])) {
	    $addaddr['nickname'] = $addaddr['firstname'];
	 }
         if (isset( $addaddr['lastname'])) {
	    $addaddr['nickname'] .= $addaddr['lastname'];
	 }
         // append portions of the email address if it makes sence
         if ((strpos($addaddr['email'], '@')) && (!strpos($addaddr['nickname'], '@'))) {
	    $parse = explode('@', $addaddr['email']);
            if ($addaddr['nickname'] == '') {
	       $addaddr['nickname'] .= $parse[0];
            }
            if (isset($parse[1])) {
               $parse = explode('.', $parse[1]);
            }
	    $addaddr['nickname'] .= "_" . $parse[0];
	 }
      }

      // remove any illegal nickname characters
      $addaddr['nickname'] = preg_replace("/[,\W\:\|\#\"\!]/", '', $addaddr['nickname']);

      // Set unset values to null or appropriate filler
      if (!isset($addaddr['firstname'])) {
         $addaddr['firstname'] = $addaddr['nickname'];
      }
      if (!isset($addaddr['lastname'])) {
         $addaddr['lastname'] = '';
      }
      if (!isset($addaddr['label'])) {
         $addaddr['label'] = '';
      }

      // First, make sure we have something valid to work with
      if (((!isset($addaddr['email'])) || ($addaddr['email'] == '')) &&
          ((!isset($addaddr['firstname'])) || ($addaddr['firstname'] == '')) &&
          ((!isset($addaddr['lastname'])) || ($addaddr['lastname'] == '')) &&
          ((!isset($addaddr['label'])) || ($addaddr['label'] == '')) ) {
         // Bail out
         unset($addaddr);
         return false;
      }

      // Insert the record into the address book
      $result = $abook->add($addaddr,$abook->localbackend);
      if (!$result) {
         echo '<tr><td colspan=5>';
         echo 'Error: '.$abook->error.'  ';
         // Now allow user to modify the data and submit again
         echo '
<form ACTION="../../src/addressbook.php" NAME=f_add METHOD="POST" TARGET="_blank">
Nickname: <input NAME="addaddr[nickname]" SIZE="12" VALUE="' .
$addaddr['nickname'] . '">
E-mail: <input NAME="addaddr[email]" SIZE="33" VALUE="' . $addaddr['email'] .
'">' . "<br>\n" . 'First name: <input NAME="addaddr[firstname]" SIZE="20" VALUE="' .
$addaddr['firstname'] . '">
Last name: <input NAME="addaddr[lastname]" SIZE="20" VALUE="' .
$addaddr['lastname'] . '">
Info: <input NAME="addaddr[label]" SIZE="20" VALUE="' . $addaddr['label'] . '">
<input TYPE=submit NAME="addaddr[SUBMIT]" VALUE="Add address">';
	 echo "\n</form></td></tr>\n";
         $errors++;
      } else {
         echo "  <TR>\n";
	 echo '    <TD>'.$addaddr['nickname']."&nbsp;</TD>\n";
	 echo '    <TD>'.$addaddr['firstname']."&nbsp;</TD>\n";
	 echo '    <TD>'.$addaddr['lastname']."&nbsp;</TD>\n";
	 echo '    <TD>'.$addaddr['email']."&nbsp;</TD>\n";
	 echo '    <TD>'.$addaddr['label']."&nbsp;</TD>\n";
	 echo "  </TR>\n";
	 $n++;
      }
      return true;
   }
}
?>
