<?php
/*
 *  SquirrelMail LDAP Prefs Backend Plugin (ldapuserdata) version 0.4
 *  By Alexandros Vellis <avel@users.sourceforge.net>
 *  Based on Retrieve User Data Plugin
 *  by Ralf Kraudelt <kraude@wiwi.uni-rostock.de>
 *
 * Copyright (c) 1999-2002 The SquirrelMail Project Team
 * and Alexandros Vellis <avel@users.sourceforge.net>
 *
 * Licensed under the GNU GPL. For full terms see the file COPYING that came
 * with the Squirrelmail distribution.
 *
 * Also view plugins/README.plugins for more information.
 */
   
function squirrelmail_plugin_init_ldapuserdata() {
	global $squirrelmail_plugin_hooks;
	global $ldap_bind_dn, $ldap_host, $ldap_master_host, $ldap_username, $ldap_base_dn;
	global $ldap_network_timeout, $ldap_bind_dn, $ldap_bind_pw, $ldap_manager_dn, $ldap_manager_pw;
	global $ldap_objectclass, $prefs_default, $ldap_attributes, $boolean_attrs, $multivalue_attrs;
	global $alternateemail_attrs;

	include(SM_PATH . 'plugins/ldapuserdata/config.php');

	// $squirrelmail_plugin_hooks["login_verified"]["ldapuserdata"] = "check_userdata";
	$squirrelmail_plugin_hooks["login_before"]["ldapuserdata"] = "get_userdata";
	$squirrelmail_plugin_hooks["logout"]["ldapuserdata"] = "flush_userdata";
}

function ldapuserdata_get_imapserveraddress($username) {
	return $_SESSION['imapServerAddress'];
}

/* My convenience function for connecting to the LDAP database.
 * $type is one of 'user', 'squirrel' or 'manager'.
 * If must do writes, connect to master LDAP, so $master = true.
 */

function connect_to_ldap ($type = 'user', $master = false) {
	global $ldap_host, $ldap_master_host, $username, $ldap_base_dn, $ldap_network_timeout;
	global $ldap_bind_dn, $ldap_bind_pw, $ldap_manager_dn, $ldap_manager_pw;
	global $cleartext_passwd;

	if($master) {
		$ldap_host = $ldap_master_host;
	}
	$ldap_error = 0;

	if (!($ldap = ldap_connect($ldap_host))) {
		print "Could not connect to LDAP!";
		return false;
	}

	if (!ldap_set_option($ldap, LDAP_OPT_PROTOCOL_VERSION, 3)) { 
		print "Failed to set protocol version to 3";
	}

	/* if (!$master) {
		if (!ldap_set_option($ldap, LDAP_OPT_NETWORK_TIMEOUT, $ldap_network_timeout)) {
			print "Failed to set network timeout.\n";
		}
	}*/
	
	switch ($type) {
		case 'manager':
			$bind_result = ldap_bind( $ldap, $ldap_manager_dn, $ldap_manager_pw);
			break;
		case 'squirrel':
			$bind_result = ldap_bind( $ldap, $ldap_bind_dn, $ldap_bind_pw);
			break;
		case 'user':
		default:
			$bind_result = ldap_bind( $ldap, 'uid='.$username.',ou=people,'.$ldap_base_dn, $cleartext_passwd);
			break;
	}

	if (!$bind_result) {
		print "Error while binding to LDAP server as $username";
		return false;
	}
	return $ldap;
}

/*
 *  get user data from LDAP database. 
 */
   
function get_userdata() {
	global $login_username, $imapServerAddress;
	global $full_name, $email_address;
	global $ldap_bind_dn, $ldap_host;

	/* fill $ldap_prefs_cache with data from LDAP. */
	$ldap_prefs_cache = retrieve_data($login_username);

	/*
	print "<pre>";
	print_r($ldap_prefs_cache);
	print_r($_SESSION);
	print_r ($_POST);
	print "</pre>";
	*/

	/* $prefs_before will remain, for checking if there are any changes to
	 * write in the end. */ 
	$prefs_before = $ldap_prefs_cache;
	$prefs_tralala = $ldap_prefs_cache;

	$imapServerAddress = $ldap_prefs_cache['imapServerAddress'];
	$full_name = $ldap_prefs_cache['full_name'];
	$email_address = $ldap_prefs_cache['email_address'];
	$prefs_are_cached = true;

	sqsession_register($prefs_are_cached, 'prefs_are_cached');
	sqsession_register($ldap_prefs_cache, 'ldap_prefs_cache');
	sqsession_register($prefs_before, 'prefs_before');
	sqsession_register($imapServerAddress, 'imapServerAddress');
	sqsession_register($full_name, 'full_name');
	sqsession_register($email_address, 'email_address');
}


function retrieve_data ($uid) {
	global $ldap_host, $username, $ldap_base_dn, $ldap_bind_dn, $ldap_bind_pw;
	global $ldap_manager_dn, $ldap_manager_pw;
	global $ldap_objectclass, $prefs_default, $ldap_attributes, $boolean_attrs, $multivalue_attrs;
      
	$ldap = connect_to_ldap('squirrel', false);

	// $ldapattrarray = array_values($ldap_attributes);
	// print "<pre>"; print_r(array_keys($ldap_attributes)); print "</pre>";

	if (!($search_result = ldap_search($ldap, $ldap_base_dn, "UID=$uid",
	array_merge( array_keys($ldap_attributes), array_keys($multivalue_attrs), 'objectclass', 'mailalternateaddress') ))) {
		print "Error while searching for $uid.";
		exit;
	}

	$info = ldap_get_entries($ldap, $search_result);
	// print "<pre>DEBUG INFO array: \n"; print_r($info); print "</pre>";

	if (!is_array($info[0])) {
		print "Sorry, the username and/or password you have provided is incorrect.";
		session_destroy();
		exit;
	}
	      
	/* Check if we have objectClass $ldap_objectclass (default: SquirrelMailUser) */
	while(list($no, $class) = each($info[0]["objectclass"])) {
		if ($class == $ldap_objectclass) {
			$already_member = true;
			break;
		}
	}

	if ($info["count"] == 1) {
		reset($ldap_attributes);
		while(list($ldapattr, $squirrelattr) = each($ldap_attributes)) {
			if (isset($info[0][$ldapattr][0])) {
				$prefs[$squirrelattr] = $info[0][$ldapattr][0];
				//print "setting $ldapattr aka $squirrelattr to $info[0][$ldapattr][0] aka ";
				//print $info[0][$ldapattr][0] ."...<br>"; 
			}
		}
	} else {
		print "Error, more than one $uid found.";
		exit;
	}

	/* Special handling of some multivalue attributes */

	if (isset($info[0]['mailalternateaddress']['count'])) {
		/* for($i = 0; $i < $info['mailalternateaddress']['count']; $i++) {
			$alternateemails[$i] = $info['mailalternateaddress'][$i];
		} */
		$prefs['alternateemails'] = $info[0]['mailalternateaddress'];
	}
	
	//print "info is:<pre>"; print_r($info); print "</pre>";

	if (isset($info[0]['mailfetch']['count'])) {
		$prefs['mailfetch'] = $info[0]['mailfetch'];
	}

	/* Special treatment for POP mail-fetch...
	LDAP: mailfetch[0] = "server:alias:user:pass: etc.
	*/

	if(isset($info[0]['mailfetch']['count']) &&
	  $info[0]['mailfetch']['count'] > 0) {
		$prefs['mailfetch_server_number'] = $info[0]['mailfetch']['count'];

		for ($i=0; $i < $info[0]['mailfetch']['count']; $i++) {
			$fetcharray = explode (":", $prefs['mailfetch'][$i]);
			//print_r($fetcharray);
			$prefs['mailfetch_server_'.$i] = $fetcharray[0];
			$prefs['mailfetch_alias_'.$i] = $fetcharray[1];
			$prefs['mailfetch_user_'.$i] = $fetcharray[2];
			$prefs['mailfetch_pass_'.$i] = $fetcharray[3];
			$prefs['mailfetch_cypher_'.$i] = $fetcharray[4];
			$prefs['mailfetch_lmos_'.$i] = $fetcharray[5];
			$prefs['mailfetch_login_'.$i] = $fetcharray[6];
			$prefs['mailfetch_fref_'.$i] = $fetcharray[7];
			$prefs['mailfetch_subfolder_'.$i] = $fetcharray[8];
			$prefs['mailfetch_uidl_'.$i] = $fetcharray[9];
		}
	}
	ldap_close($ldap);

	/* Some additional thingies for the options:
	move_to_trash, move_to_sent, save_as_draft, which are NOT included in the
	ldap schema. */

	if(isset($prefs['trash_folder']) && $prefs['trash_folder'] != 'none') {
		$prefs['move_to_trash'] = 1;
	} else { 
		$prefs['move_to_trash'] = 0;
	}

	if(isset($prefs['sent_folder']) && $prefs['sent_folder'] != 'none') {
		$prefs['move_to_sent'] = 1;
	} else { 
		$prefs['move_to_sent'] = 0;
	}
	
	if(isset($prefs['draft_folder']) && $prefs['draft_folder'] != 'none') {
		$prefs['save_as_draft'] = 1;
	} else { 
		$prefs['save_as_draft'] = 0;
	}


	/* If first time logged in, add me to the SquirrelMailUser objectclass */

	if(!$already_member) {
		$newinfo = array();
		$newinfo['objectclass'] = array();
		for($i = 0; $i < $info[0]["objectclass"]["count"]; $i++) {
			$newinfo['objectclass'][$i] =  $info[0]["objectclass"][$i];
		}
		// $newinfo["objectclass"][$objectclass[0]["objectclass"]["count"]] = $ldap_objectclass;
		$newinfo["objectclass"][$i] = $ldap_objectclass;
		
		// print "I will modify objectclass as follows:";
		// print "<pre>"; print_r($newinfo); print "</pre>";
		$ldap2 = connect_to_ldap('manager', true);
		
		if(!ldap_modify($ldap2, "uid=$uid,ou=people,$ldap_base_dn" , $newinfo)) {
			print "<STRONG>Error while updating your objectclass! Could not modify LDAP data.</strong>";
			exit;
		} 
		ldap_close($ldap2);
		// $_SESSION['first_time_user'] = 1;
		//session_register($first_time_user);
	} 

	while(list($ldapattr, $squirrelattr) = each($boolean_attrs)) {
		if( array_key_exists($squirrelattr, $prefs) ) {
			if($prefs[$squirrelattr] == "TRUE") {
				$prefs[$squirrelattr] = 1;
			} elseif ($prefs[$squirrelattr] == "FALSE") {
				$prefs[$squirrelattr] = 0;
			}
		}
	}

	$prefs['dn'] = $info[0]['dn'];
	return($prefs);

}

/*
 *  write user data to LDAP database
 */
   
function flush_userdata() {
      include(SM_PATH . "plugins/ldapuserdata/config.php");

      global $username;
      global $ldap_host;
      global $ldap_objectclass, $prefs_default, $ldap_attributes, $boolean_attrs;

	if(is_array($_SESSION['ldap_prefs_cache'])) {
		$ldap_prefs_cache = $_SESSION['ldap_prefs_cache'];
	}

	// prepare data
	$attr_to_write = array();
	$attr_to_del = array();

	while(list($ldapattr, $squirrelattr) = each($ldap_attributes)) {
		if( !( ($ldapattr == "cn") || ($ldapattr == "mail") || ($ldapattr == "mailhost")) ) {
	
		// print "<br>DEBUG: $squirrelattr - Checking if ".$ldap_prefs_cache[$squirrelattr]."
		// is different than ".$_SESSION['prefs_before'][$squirrelattr]."<br>";

		if(isset($_SESSION['ldap_prefs_cache'][$squirrelattr]) &&
		  $_SESSION['ldap_prefs_cache'][$squirrelattr] != $_SESSION['prefs_before'][$squirrelattr] )
			if ($_SESSION['ldap_prefs_cache'][$squirrelattr] != "" ) {
				$attr_to_write[$ldapattr] = $_SESSION['ldap_prefs_cache'][$squirrelattr];
			} else {
				$attr_to_del[$ldapattr] = $_SESSION['prefs_before'][$squirrelattr];
			}
		}
	}

	/* Handle boolean attributes */
	while(list($ldapattr, $squirrelattr) = each($boolean_attrs)) {
		if( array_key_exists($ldapattr, $attr_to_write) ) {
			if($attr_to_write[$ldapattr]) {
				$attr_to_write[$ldapattr] = 'TRUE';
			} else {
				$attr_to_write[$ldapattr] = 'FALSE';
			}
		}
	}

	/* Handle multivalue attributes */
	if(isset($_SESSION['ldap_prefs_cache']['mailfetch_server_number']) &&
	  $_SESSION['ldap_prefs_cache']['mailfetch_server_number'] > 0) {
		//print "putting mailfetch vars";
		
		for ($i=0; $i < $_SESSION['ldap_prefs_cache']['mailfetch_server_number']; $i++) {
			//print "writing # $i";

			$newarray[0] = $_SESSION['ldap_prefs_cache']['mailfetch_server_'.$i];
			$newarray[1] = $_SESSION['ldap_prefs_cache']['mailfetch_alias_'.$i]; 
			$newarray[2] = $_SESSION['ldap_prefs_cache']['mailfetch_user_'.$i]; 
			$newarray[3] = $_SESSION['ldap_prefs_cache']['mailfetch_pass_'.$i];
			$newarray[4] = $_SESSION['ldap_prefs_cache']['mailfetch_cypher_'.$i];
			$newarray[5] = $_SESSION['ldap_prefs_cache']['mailfetch_lmos_'.$i]; 
			$newarray[6] = $_SESSION['ldap_prefs_cache']['mailfetch_login_'.$i];
			$newarray[7] = $_SESSION['ldap_prefs_cache']['mailfetch_fref_'.$i]; 
			$newarray[8] = $_SESSION['ldap_prefs_cache']['mailfetch_subfolder_'.$i];
			$newarray[9] = $_SESSION['ldap_prefs_cache']['mailfetch_uidl_'.$i]; 
			
			$mailfetchpref[$i] = implode (":", $newarray);
			//print_r($mailfetchpref);
		}

		for($i=0; $i<sizeof($mailfetchpref) ;$i++) {
			if($mailfetchpref[$i] != $_SESSION['prefs_before']['mailfetch'][$i]) {
				$different = true;
			}
		}
		
		if(isset($different) && $different = true ) {
			for($i=0; $i<sizeof($mailfetchpref) ;$i++) {
				$attr_to_write['mailfetch'][$i] = $mailfetchpref[$i];
			}
		}

	}

	/*while(list($ldapattr, $squirrelattr) = each($multivalue_attrs)) {
		while( list(
		}
	}*/
	
	/* Now our $attr_to_write and $attr_to_del arrays are ready. */

	/* Starting Write Process.  Of course, perform a write on our poor
	 * LDAP, only if there _is_ something different to write. 
	 */
		
		
	if(isset($_SESSION['ldap_prefs_cache']['dn'])) {
		$user_dn = $_SESSION['ldap_prefs_cache']['dn'];
	} else {
		$user_dn = "uid=$username,ou=people,$ldap_base_dn";
	}
	 

	if(!(sizeof($attr_to_write) == 0)) {
		print "DEBUG: I will write these on LDAP:";
		print "<pre>"; print_r($attr_to_write); print "</pre>";
	}
	if(!(sizeof($attr_to_del) == 0)) {
		print "I will clear these on LDAP:";
		print "<pre>"; print_r($attr_to_del); print "</pre>";
	}
	// print "I will use the dn $user_dn";

	if(!(sizeof($attr_to_write) == 0)) {
		$ldap = connect_to_ldap('manager', true);

	//	$objarr = array("objectClass");
		/* Check if we have objectClass $ldap_objectclass (default: SquirrelMailUser) */
	//	if (!($sr = ldap_search($ldap, $ldap_base_dn, "UID=$username", array("objectClass")))) {
	//		print "Cound not get objectclass values for $username.";
	//		exit;
	//	}
	//	$objectclassinfo = ldap_get_entries($ldap, $sr);

		 print "DEBUG: I will now execute ldap_modify (ldap,
		 uid=$username,ou=people,$ldap_base_dn , $attr_to_write)";
		
		if(!ldap_modify($ldap, $user_dn, $attr_to_write)) {
			print "<STRONG>ERROR: While writing your preferences, an error had
			occured on the LDAP server.</strong><br />
			Please contact your administrator.";
		} 
		if(sizeof($attr_to_del) == 0) {
			ldap_close($ldap);
		}
	}


	if(!(sizeof($attr_to_del) == 0)) {
		if(sizeof($attr_to_write) == 0) {
			$ldap = connect_to_ldap('manager', true);
		}
		
		if(!ldap_mod_del($ldap, $user_dn, $attr_to_del)) {
			print "<STRONG>ERROR: While writing your preferences, an error had
			occured on the LDAP server.</strong> (ldap_mod_del)<br />
			Please contact your administrator.";
		}
		ldap_close($ldap);
	}
}

function ldapuserdata_get_server($username) {

	return $_SESSION['prefs_before']['imapServerAddress'];
}

?>
