<?php

/*
 * ldap_prefs.php
 *
 * Copyright (c) 1999-2002 The SquirrelMail Project Team
 * and Alexandros Vellis <avel@noc.uoa.gr>
 * Licensed under the GNU GPL. For full terms see the file COPYING.
 *
 * This contains functions for manipulating user preferences
 * stored in an LDAP database.
 *
 */

require_once('../config/config.php');
require_once('../plugins/ldapuserdata/config.php');

//global $prefs_default, $prefs_are_cached, $prefs_cache;
session_start();

/*
* When a highlight option is deleted the preferences module
* must renumber the list.  This should be done somewhere else,
* but it is not, so....
*/
function renumberHighlightList() {
	global $HTTP_SESSION_VARS;

	$j = 0;
	for($i = 0; $i < 10 ; $i++) {
		$highlightarray[$i] = $HTTP_SESSION_VARS['prefs_cache']['highlight'.$i];
		if($highlightarray[$i]) {
			$newarray[$j] = $highlightarray[$i];
			$j++;
		}
	}
	/* print "got the array:";
	print "<pre>";
	print_r($highlightarray);
	print "will put the array:";
	print_r($newarray);
	print "</pre>";
	*/
	for($i = 0; $i < 10 ; $i++) {
		$HTTP_SESSION_VARS['prefs_cache']['highlight'.$i] = $newarray[$i];
	}
	return true;
}

/* returns the value for the pref $string */
function getPref($data_dir, $username, $string, $default = '') {
	global $HTTP_SESSION_VARS, $prefs_default;

	if($HTTP_SESSION_VARS['prefs_cache']) {
		if ($string == 'full_name') {
			return $HTTP_SESSION_VARS['prefs_cache']['full_name'];

		} elseif ($string == 'email_address') {
			if(!is_numeric($default)) {
				//print "I am here in default identity.... returning... ";
				//print $_SESSION['prefs_cache']['email_address'];
				return $HTTP_SESSION_VARS['prefs_cache']['email_address'];
			} else {
				//print "I am here in alternate stuff.... returning... ";
				//print $_SESSION['prefs_cache']['alternateemails'][$default];
				return $HTTP_SESSION_VARS['prefs_cache']['alternateemails'][$default];
			}

		} elseif(isset($HTTP_SESSION_VARS['prefs_cache'][$string])) {
			//print "<b>DEBUG: I was asked for $string; I returned ".$HTTP_SESSION_VARS['prefs_cache'][$string]."</b><br>"; 
			return $HTTP_SESSION_VARS['prefs_cache'][$string];


	/*	} elseif (array_key_exists($prefs_cache, $string) && !isset($prefs_cache[$string])) {
			print "DEBUG: I was asked for something user hadnt defined so I returned ".$prefs_default['string']; 
			return $prefs_default[$string];

		} elseif (!$prefs_cache[$string]) {
			print "DEBUG: I was asked for something I didnt have so I returned ".$prefs_default['string']; 
			return $prefs_default[$string];
*/
		} else {
			//print "I returned $string from the deafult array:".$prefs_default[$string]."<br>";
			return $prefs_default[$string];
			// return false;
		}
	} else {
		//print "No cache? WHYYYYYYYY? :-(";
		//print_r($HTTP_SESSION_VARS);
	}

}

/* sets the pref, $string, to $set_to */
function setPref($data_dir, $username, $string, $set_to = '') {
	global $HTTP_SESSION_VARS, $prefs_default;

	if ($string == "full_name" || $string == "mail" || $string == "imapServerAddress" ) {
		print "Error: I was told to change something I shouldn't.";
	}

	if($HTTP_SESSION_VARS['prefs_cache']) {
		if(isset($HTTP_SESSION_VARS['prefs_cache'][$string]) && ($HTTP_SESSION_VARS['prefs_cache'][$string] == $set_to)) {
			return;
		} else {
			$HTTP_SESSION_VARS['prefs_cache'][$string] = $set_to;
			if($string == 'trash_folder') {
				if ($set_to != 'none' ) {
					$HTTP_SESSION_VARS['prefs_cache']['move_to_trash'] = 1;
				} else {
					$HTTP_SESSION_VARS['prefs_cache']['move_to_trash'] = 0;
				}
			}
			if($string == 'sent_folder') {
				if ($set_to != 'none' ) {
					$HTTP_SESSION_VARS['prefs_cache']['move_to_sent'] = 1;
				} else {
					$HTTP_SESSION_VARS['prefs_cache']['move_to_sent'] = 0;
				}
			}
			if($string == 'draft_folder') {
				if ($set_to != 'none' ) {
					$HTTP_SESSION_VARS['prefs_cache']['save_as_draft'] = 1;
				} else {
					$HTTP_SESSION_VARS['prefs_cache']['save_as_draft'] = 0;
				}
			}
			return;
		}

    /* assert_options(ASSERT_ACTIVE, 1);
    assert_options(ASSERT_BAIL, 1);
    assert ('$set_to == $prefs_cache[$string]'); */

	return;
	}
}

/* Remove the pref $string */
function removePref($data_dir, $username, $string) {

	setPref($data_dir, $username, $string, '');
	if(substr($string, 0,9) == 'highlight') {
		if (!(renumberHighlightList())) {
			print "Error while renumbering...";
		}
	}
	return;
}

/* This checks if the prefs are available */
/* function checkForPrefs($data_dir, $username) {
} */

/**
 * Write the User Signature.
 */
function setSig($data_dir, $username, $number, $value) {
	
	setPref($data_dir, $username, 'signature', $value);

}

/**
 * Get the signature.
 */
function getSig($data_dir, $username, $number) {

	$sig = getPref($data_dir, $username, 'signature', $value);
	return $sig;
}

?>
