<?php
   /* ldapquery options hooks
    *
    */

   chdir ("..");
   require_once ('../src/validate.php');

   require_once ("../plugins/ldapquery/config.php");

   if (isset($action) && $action == 'done') {
      setPref($data_dir, $username, 'ldapquery_output_type', $ldapquery_output_type);
      foreach ($ldq_attributes as $attr) {
	 $Var = 'ldapquery_showattr_'.$attr;
	 if ($$Var == "") {
	    $$Var = "off";
	 }
         setPref($data_dir, $username, $Var, $$Var);
      }
   }

   displayPageHeader($color, "None");

   function ldapquery_LoadPrefs($attributes) {
      global $ldapquery_output_type;
      $ldapquery_output_type = getPref($data_dir, $username, "ldapquery_output_type");
      if ($ldapquery_output_type == "")
         $ldapquery_output_type = "OneTable";

      foreach ($attributes as $attr) {
         $Var = "ldapquery_showattr_" . $attr;
         global $$Var;
         $$Var = getPref($data_dir, $username,
             $Var);
         if ($$Var == "")
            $$Var = "on";
      }
   }

   function ShowOption($Var, $value, $Desc) {
       $Var = 'ldapquery_' . $Var;
       
       global $$Var;
       
       echo '<option value="' . $value . '"';
       if ($$Var == $value)
       {
           echo ' SELECTED';
       }
       echo '>' . $Desc . "</option>\n";
   }

   function ldapquery_ShowCheckboxes($attributes) {
      foreach ($attributes as $attr_full=>$attr) {
         $Var = "ldapquery_showattr_" . $attr;
         global $$Var;
         print ("<tr><td>$attr_full</td><td><input type=checkbox name=" . $Var);
         if ($$Var == "on")
            print (" CHECKED");
         print ("></td></tr>\n");
      }
   }

   ldapquery_LoadPrefs($ldq_attributes);

?>
   <br>
   <table width=95% align=center border=0 cellpadding=2 cellspacing=0><tr><td bgcolor="<?php echo $color[0] ?>">
      <center><b><?php echo _("Options") ?> - Search LDAP</b></center>
   </td></tr></table>

   <p>Output types can be:</p>
   
   <ul>
   
   <li><b>One Table</b> -
       One big table with one row per record found and each
       selected attribute as a separate column.</li>

   <li><b>Multiple Tables</b> -
       One table per record found with 2 columns for each table.
       One colunn contains attribute names and the 2nd column shows
       values for each attribute.  This format is best if you have 
       many attributes selected or if the values for some of the 
       attributes you have selected can be very long with no spaces
       (like labeledurl).</li>

   </ul>
   
   <form action="options.php?action=done" method=post>
   <table border=0 cellpadding=0 cellspacing=2>
   <tr><td align=right nowrap>Output Type:</td>
       <td><select name="ldapquery_output_type">
<?PHP
    ShowOption('output_type', 'OneTable', 'One Table');
    ShowOption('output_type', 'MultiTable', 'Multiple Tables');
?>       </select>
       </td></tr>
<?PHP
   ldapquery_ShowCheckboxes ($ldq_attributes);
?>
   <tr><td></td><td>
       <input type="submit" value="Submit" name="submit_ldapquery">
       </td></tr>
   </table>
   </form>
</body></html>
