<?
   /* ldapquery plugin version 1.1
    *
    * Undoubtedly there are better/faster ways to do what I do here,
    * but this is just a quickie to give me minimal functionality I need
    * until I can replace addrbook_search_html.php. Hopefully when I do it
    * will be full-featured enough to not require the Javascript version,
    * or I'll just hafta grab a book on Javascript as well.   :-)
    */

   chdir ("..");
   require_once ('../src/validate.php');

   require_once ("../plugins/ldapquery/config.php");


   /* ldapquery_compattrs - compare attributes for sorting results
    */
   function ldapquery_compattrs ($left, $right) {
      return strcasecmp($left,$right);
   }

   /* ldapquery_lnf - Convert a string with a name in it in firstname first
    *     format to a lastname first formatted string
    */
   function ldapquery_lnf ($fnf) {
      $name = explode(" ", $fnf);
      if (count($name) > 1)
         $lnf = $name[count($name)-1];
      else
         $lnf = "";
      for ($i = 0; $i < count($name)-1; $i++)
         $lnf .= $name[$i];
      return $lnf;
   }

   /* ldapquery_compcns - compare cn attributes for sorting results by lastname
    *     This is a bit of a hack for those of us who don't have surname
    *     attributes in our LDAP records (so we can't just select it in
    *     "sort by".
    */
   function ldapquery_compcns ($left, $right) {
      // find last names and put it at start of strings
      $left_lnf = ldapquery_lnf ($left);
      $right_lnf = ldapquery_lnf ($right);

      return strcasecmp($left_lnf,$right_lnf);
   }

   /* ldapquery_dispresultsMulti - display HTML results from an LDAP query
    *   takes the list of attributes that were searched for and the
    *   returned results as parameters
   */
   function ldapquery_dispresultsMulti ($attributes, $entry, $sortby) {
      // sort the entries. First, build an array with the sortby as the key
      // and the entry index as the value
      if ($entry["count"] > 0) {
         for ($i=0 ; $i < $entry["count"]; $i++) {
            $Val = $entry[$i][$sortby][0] . $i;
            $sorted[$Val] = $i;
         }
         if ($sortby == "cn")
            uksort ($sorted, "ldapquery_compcns");
         else
            uksort ($sorted, "ldapquery_compattrs");
   
         foreach ($sorted as $key=>$i) {
            print ("<table border=BORDER>");
   
            foreach ($attributes as $attr_full=>$attr) {
               $Var = "ldapquery_showattr_" . $attr;
               global $$Var;
               if ($$Var == "on") {
                  for ($x=0 ; $x < $entry[$i][$attr]["count"] ; $x++) {
                     // print one row of table of attr/value pairs
                     // print attribute cell
                     print ("<tr>\n");
                     print ("<td>$attr_full</td><td>");
      
                     // print value cell
                     // separate and print multi-line values
                     // For labeledurl attribs, make the first part a link
      
                     switch ($attr) {
                     case "labeledurl":
                        // split up url and label parts
                        $val = $entry[$i][$attr][$x] . " <END>";
                        $isfirsttoken = true;
                        for ($token = strtok($val, " "); $token != "<END>";
                             $token = strtok(" "))
                        {
                           if ($isfirsttoken) {
                              print ("<A HREF=\"$token\">");
                           }
                           print ("$token");
                           if ($isfirsttoken) {
                              print ("</A> ");
                              $isfirsttoken = false;
                           }
                        }
                        break;
                     case "mail":
                        $val = $entry[$i][$attr][$x];
                        displayInternalLink ("src/compose.php?send_to=$val",
                                             "$val", "right");
                        break;
                     default:
                        $val = $entry[$i][$attr][$x] . "$<END>";
                        for ($token = strtok($val, "\$");
                                $token != "<END>"; $token = strtok("\$"))
                        {
                           print ("$token<BR>");
                        }
                        print ("</td>\n");
                        print ("</tr>\n");
                     }
      
                  }
               }
            }
            print ("</table>\n");
   
            print ("<HR>");
         }
      } else {
         print ("No records found<BR>\n");
      }
   }

   /* ldapquery_dispresultsSingle - display HTML results from an LDAP query
    *   with each record being one row in a single table
    *   takes the list of attributes that were searched for and the
    *   returned results as parameters
   */
   function ldapquery_dispresultsSingle ($attributes, $entry, $sortby) {
      // sort the entries. First, build an array with the sortby as the key
      // and the entry index as the value
      if ($entry["count"] > 0) {
         for ($i=0 ; $i < $entry["count"]; $i++) {
            $Val = $entry[$i][$sortby][0] . $i;
            $sorted[$Val] = $i;
         }
         if ($sortby == "cn")
            uksort ($sorted, "ldapquery_compcns");
         else
            uksort ($sorted, "ldapquery_compattrs");
   
         print ("<table border=BORDER>");
   
         // print table headers
         print ("<tr>");
         foreach ($attributes as $attr_full=>$attr) {
            $Var = "ldapquery_showattr_" . $attr;
            global $$Var;
            if ($$Var == "on") {
               print ("<td><b>$attr_full</b></td>");
            }
         }
         print ("</tr>\n");
   
         foreach ($sorted as $key=>$i) {
   
            foreach ($attributes as $attr) {
               $Var = "ldapquery_showattr_" . $attr;
               global $$Var;
               if ($$Var == "on") {
                  print ("<td>");
      
		  if ($entry[$i][$attr]["count"] == 0) {
		     print ("<BR>\n");  // to avoid totally empty cells
		  }

                  for ($x=0 ; $x < $entry[$i][$attr]["count"] ; $x++) {
                     // Since there might be multiple values per attribute,
                     // prefix each one with <p> so they're on separate lines
                     // within the cell
                     print ("<p>");
      
                     switch ($attr) {
                     case "labeledurl":
                        // split up url and label parts
                        $val = $entry[$i][$attr][$x] . " <END>";
                        $isfirsttoken = true;
                        for ($token = strtok($val, " "); $token != "<END>";
                             $token = strtok(" "))
                        {
                           if ($isfirsttoken) {
                              print ("<A HREF=\"$token\">");
                           }
                           print ("$token");
                           if ($isfirsttoken) {
                              print ("</A> ");
                              $isfirsttoken = false;
                           }
                        }
                        break;
                     case "mail":
                        $val = $entry[$i][$attr][$x];
                        displayInternalLink ("src/compose.php?send_to=$val",
                                             "$val", "right");
                        break;
                     default:
                        $val = $entry[$i][$attr][$x] . "$<END>";
                        for ($token = strtok($val, "\$");
                                $token != "<END>"; $token = strtok("\$"))
                        {
                           print ("$token<BR>");
                        }
                     }
      
                  }
                  print ("</td>");
               }
            }
   
            print ("</tr>\n");
         }
         print ("</table>\n");
      } else {
         print ("No records found<BR>\n");
      }
   }

   function ldapquery_LoadPrefs($attributes) {
      global $ldapquery_output_type;
      $ldapquery_output_type = getPref($data_dir, $username, "ldapquery_output_type");
      if ($ldapquery_output_type == "")
         $ldapquery_output_type = "OneTable";

      foreach ($attributes as $attr) {
         $Var = "ldapquery_showattr_" . $attr;
         global $$Var;
         $$Var = getPref($data_dir, $username,
             $Var);
         if ($$Var == "")
            $$Var = "on";
      }
   }


   displayPageHeader($color, "None");

   //$ldapquery_output_type = getPref($data_dir, $username, "ldapquery_output_type");
   ldapquery_LoadPrefs($ldq_attributes);

   print ("<FORM ACTION=\"$PHP_SELF\" METHOD=\"post\">\n");

   if ($ldq_authreqd) {
      // Get the userdn to authenticate with
      print ("<b>User DN:</b> ");
      print ("<INPUT ");
      print ("TYPE=\"text\" ");
      print ("NAME=\"ldq_rdn\" ");
      print ("VALUE=\"$ldq_rdn\">\n");
   
      // Get the user password
      print ("<b>Password:</b> ");
      print ("<INPUT ");
      print ("TYPE=\"password\" ");
      print ("NAME=\"ldq_pass\" ");
      print ("VALUE=\"$ldq_pass\">\n");
      print ("<BR>\n");
   }

   // Get the objectclass the user wants to search for
   print ("<b>Search For:</b> ");
   print ("<SELECT ");
   print ("NAME=\"ldq_searchfor\"> ");
   foreach ($ldq_searchobjs as $ldq_full=>$ldq_short) {
      print ("<OPTION");
      if ($ldq_full == $ldq_searchfor)
         print (" SELECTED");
      print (">$ldq_full</OPTION>");
   }
   print ("</SELECT>\n");


   // Get the attribute the user wants to search by
   print ("<b>By:</b> ");
   print ("<SELECT ");
   print ("NAME=\"ldq_searchby\"> ");
   foreach ($ldq_searchattrs as $ldq_full=>$ldq_short) {
      print ("<OPTION");
      if ($ldq_full == $ldq_searchby)
         print (" SELECTED");
      print (">$ldq_full</OPTION>");
   }
   print ("</SELECT>\n");
   
   // Get type of search
   print ("<SELECT ");
   print ("NAME=\"ldq_comparetype\"> ");
   if ($ldq_comparetype == "Contains") 
      print ("<OPTION SELECTED>Contains</OPTION>");
   else
      print ("<OPTION>Contains</OPTION>");
   if ($ldq_comparetype == "Is") 
      print ("<OPTION SELECTED>Is</OPTION>");
   else
      print ("<OPTION>Is</OPTION>");
   print ("</SELECT>\n");

   // Get search name from user
   print ("<INPUT ");
   print ("TYPE=\"text\" ");
   print ("NAME=\"ldq_querystr\" ");
   print ("VALUE=\"$ldq_querystr\">\n");
   print ("<BR>\n");

   // Sort By menu
   print ("<b>Sort By:</b> ");
   print ("<SELECT ");
   print ("NAME=\"ldq_sortby\"> ");
   foreach ($ldq_attributes as $ldq_full=>$ldq_short) {
      print ("<OPTION");
      if ($ldq_full == $ldq_sortby)
         print (" SELECTED");
      print (">$ldq_full</OPTION>");
   }
   print ("</SELECT>\n");

   // Submit button
   print ("<INPUT ");
   print ("TYPE=\"submit\" ");
   print ("NAME=\"Submit_Button\" ");
   print ("VALUE=\"Search\">\n");

   print ("</FORM>\n");

   if ($ldq_querystr != "") {
      print ("<H3>Search Results</H3><HR>\n");

      // setup search filter
      //print ("Comparetype is $ldq_comparetype<BR>\n");
      switch ($ldq_comparetype) {
         case "Contains":
            $ldq_tfilter = "*$ldq_querystr*";
            break;
         case "Is":
            $ldq_tfilter = $ldq_querystr;
            break;
         default:   // assume it's a contains search
            $ldq_tfilter = "*$ldq_querystr*";
      }
      if ($ldq_tfilter == "***")
         $ldq_tfilter = "*";
      $ldq_filter = $ldq_searchattrs[$ldq_searchby] . "=$ldq_tfilter";

      // Now take the filter and "AND" in the objectclass restriction if any
      $ldq_filter = "(&(objectclass=" . $ldq_searchobjs[$ldq_searchfor] .
                    ")(" . $ldq_filter . "))";
      //print ("QUERY is $ldq_filter<BR>\n");
   
      // Perform search for each LDAP server configured in squirrel
      for ($ldq_lds=0 ; $ldq_lds < count($ldap_server) ; $ldq_lds++) {
         // Get the data for this Directory Server
         $ldq_Server = $ldap_server[$ldq_lds]["host"];
         $ldq_Port = $ldap_server[$ldq_lds]["port"];
         $ldq_base = $ldap_server[$ldq_lds]["base"];
	 //$ldq_rdn = "cn=root, " . $ldq_base;
	 //$ldq_pass = "glaglog";

         // I usually just use these for debugging
         //print ("<i>Querying: $ldq_Server on port $ldq_Port with ");
         //print ("base $ldq_base</i><BR>");

         print ("<i>" . $ldap_server[$ldq_lds]["name"] . "</i><BR><BR>");
   
         // connect to LDAP server
         if (!($ldq_ldap=ldap_connect($ldq_Server,$ldq_Port))) {
            die("Could not connect to LDAP server " . $ldq_Server);
         }
   
         //attempt to bind to LDAP server
	 if ($ldq_authreqd) {
            if (!ldap_bind($ldq_ldap, $ldq_rdn . ", " . $ldq_base, $ldq_pass)) {
               die ("Unable to bind to LDAP server");
            }
	 } else {
            if (!ldap_bind($ldq_ldap)) {
               die ("Unable to bind to LDAP server");
            }
	 }
   
         foreach ($ldq_attributes as $attr) {
            $ldq_tattr[] = $attr;
         }

         // perform search
         if (!($ldq_result = ldap_search($ldq_ldap, $ldq_base, $ldq_filter, $ldq_tattr))) {
            die ("Nothing found!");
         }
   
         // Get all the entries
         $ldq_entry = ldap_get_entries ($ldq_ldap, $ldq_result);
   
//print ("<b>output type is $ldapquery_output_type  </b><BR>\n");
//print ("<b>output sorted by $ldq_sortby </b><BR>\n");

         switch ($ldapquery_output_type) {
            case "OneTable":
               ldapquery_dispresultsSingle ($ldq_attributes, $ldq_entry,
                                            $ldq_attributes[$ldq_sortby]);
               break;
            case "MultiTable":
               ldapquery_dispresultsMulti ($ldq_attributes, $ldq_entry,
                                           $ldq_attributes[$ldq_sortby]);
               break;
            default:
               ldapquery_dispresultsMulti ($ldq_attributes, $ldq_entry,
                                           $ldq_attributes[$ldq_sortby]);
         }
 
         // close connection
         ldap_close($ldq_ldap);
      }
   }

   print ("</BODY>\n");
   print ("</HTML>\n");

?>

