<?php
/**
 * ldapquery plugin - main query script
 *
 * @copyright 2001-2004 Brent Bice <bbice@persistence.com>
 * @copyright 2004-2006 The SquirrelMail Project Team
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License
 * @version $Id: ldapquery.php,v 1.17 2006/03/21 17:21:10 tokul Exp $
 * @package sm-plugins
 * @subpackage ldapquery
 */

/** 
 * SM_PATH define
 * @ignore 
 */
define('SM_PATH','../../');

/** Including required squirrelmail files */
include_once (SM_PATH . 'include/validate.php');

/** Load post vars */
sqgetGlobalVar('ldq_searchfor',$ldq_searchfor,SQ_POST);
sqgetGlobalVar('ldq_searchby',$ldq_searchby,SQ_POST);
if (! sqgetGlobalVar('ldq_comparetype',$ldq_comparetype,SQ_POST))
     $ldq_comparetype='Contains';
sqgetGlobalVar('ldq_querystr',$ldq_querystr,SQ_POST);
sqgetGlobalVar('ldq_sortby',$ldq_sortby,SQ_POST);

sqgetGlobalVar('ldq_rdn',$ldq_rdn,SQ_POST);
sqgetGlobalVar('ldq_pass',$ldq_pass,SQ_POST);

if (sqgetGlobalVar('ldq_server',$ldq_server,SQ_POST)) {
    $ldq_server = (int) $ldq_server;
} else {
    $ldq_server = -1;
}

displayPageHeader($color, "None");

// switch to ldapquery domain
bindtextdomain('ldapquery',SM_PATH . 'locale');
textdomain('ldapquery');

$ldq_check = ldq_check_setup();
if (! empty($ldq_check)) {
    ldq_error_box($ldq_check,$color);
    exit('</body></html>');
}

// load ldap schemas
$ldq_loaded_schemas=ldq_load_schemas();

echo "<!-- start ldapquery search form -->\n";
echo '<form action="' . $PHP_SELF . '" method="post">' . "\n";

if ($ldq_authreqd) {
    // Get the userdn to authenticate with
    echo '<b>' . _("User DN:") . '</b> ';
    echo '<input type="text" name="ldq_rdn" value="' . (isset($ldq_rdn) ? htmlspecialchars($ldq_rdn) : '') . "\">\n";
   
    // Get the user password
    echo '<b>' . _("Password:") . '</b> ';
    echo '<input type="password" name="ldq_pass" value="">'. "\n";
    echo "<br />\n";
}

// Get the objectclass the user wants to search for
echo '<b>' . _("Search For:") . '</b> ';
echo '<select name="ldq_searchfor">'. "\n";
foreach ($ldq_searchobjs as $ldq_short) {
    echo '<option value="' . $ldq_short . '"';
    if (isset($ldq_searchfor) && $ldq_short == $ldq_searchfor)
        echo ' selected';
    echo '>' . $ldq_loaded_schemas->get_object_name($ldq_short) . "</option>\n";
}
echo "</select>\n";


// Get the attribute the user wants to search by
echo '<b>' . _("Where:") . '</b> ';
echo '<select name="ldq_searchby">' . "\n";
if ($ldq_searchattrs==array()) {
    foreach ($ldq_attributes as $ldq_short) {
        $ldq_showattr='ldapquery_showattr_' . $ldq_short;
        if ($$ldq_showattr=='on') {
            echo '<option value="' . $ldq_short . '"';
            if (isset($ldq_searchby) && $ldq_short == $ldq_searchby)
                echo ' selected';
            echo '>' . $ldq_loaded_schemas->get_attrib_name($ldq_short) . "</option>\n";
        }
    }
} else {
    foreach ($ldq_searchattrs as $ldq_short) {
        echo '<option value="' . $ldq_short . '"';
        if (isset($ldq_searchby) && $ldq_short == $ldq_searchby)
            echo ' selected';
        echo '>' . $ldq_loaded_schemas->get_attrib_name($ldq_short) . "</option>\n";
    }
}
echo "</select>\n";
   
// Get type of search
echo '<select name="ldq_comparetype">' . "\n";
if ($ldq_comparetype == "Contains") 
     echo '<option value="Contains" selected>' . _("Contains") . "</option>\n";
     else
     echo '<option value="Contains">' . _("Contains") . "</option>\n";
if ($ldq_comparetype == "Is") 
     echo '<option value="Is" selected>' . _("Is") . "</option>\n";
     else
     echo '<option value="Is">' . _("Is") . "</option>\n";
echo "</select>\n";

// Get search name from user
echo '<input type="text" name="ldq_querystr" ';
echo 'value="' . (isset($ldq_querystr) ? htmlspecialchars($ldq_querystr) : '') ."\">\n";
echo "<br />\n";

// Sort By menu
echo '<b>' . _("Sort By:") . '</b> ';
echo '<select name="ldq_sortby">' . "\n";
foreach ($ldq_attributes as $ldq_short) {
    $ldq_showattr='ldapquery_showattr_' . $ldq_short;
    if ($$ldq_showattr=='on') {
        echo '<option value="' . $ldq_short . '"';
        if (isset($ldq_sortby) && $ldq_short == $ldq_sortby)
            echo ' selected';
        echo '>' . $ldq_loaded_schemas->get_attrib_name($ldq_short) . "</option>\n";
    }
}
echo "</select><br />\n";

// Server selection box
if (count($ldap_server)>1) {
    echo '<b>' . _("Search in:") . '</b> ';
    echo '<select name="ldq_server">' . "\n";

    echo '<option value="-1"'
        .($ldq_server== -1 ? ' selected="selected"' : '' ).'>'
        ._("All LDAP address books")."</option>\n";

    foreach ($ldap_server as $ldap_key => $ldap_config) {
        echo '<option value="' . $ldap_key . '"'
            .($ldq_server==$ldap_key ? ' selected="selected"' : '' ).'>';
        if (isset($ldap_config['name'])) {
            echo $ldap_config['name'];
        } else {
            echo $ldap_config['host'];
        }
        echo "</option>\n";
    }
    echo "</select><br />\n";
}

// Submit button
echo '<input type="submit" name="Submit_Button" ';
echo 'value="' . _("Search") . "\">\n";

// End seach form
echo "</form>\n";
echo "<!-- end ldapquery search form -->\n";

if (isset($ldq_querystr) && $ldq_querystr != "") {
    echo '<h3>' . _("Search Results") . "</h3>\n";

    // setup search filter
    if ($ldq_debug)
        echo sprintf(_("Comparetype is %s"),htmlspecialchars($ldq_comparetype)) . "<br />\n";

    switch ($ldq_comparetype) {
    case "Is":
        $ldq_tfilter = ldapquery_ldapspecialchars($ldq_querystr);
        break;
    case "Contains":
    default:   // assume it's a contains search
        $ldq_tfilter = '*' . ldapquery_ldapspecialchars($ldq_querystr) . '*';
    }
    // still allow use of single * in search
    if ($ldq_querystr == "*" && $ldq_allow_asterisk_search)
        $ldq_tfilter = "*";
    $ldq_filter = $ldq_searchby . "=$ldq_tfilter";

    // Now take the filter and "AND" in the objectclass restriction if any
    $ldq_filter = "(&(objectclass=" . $ldq_searchfor .
        ")(" . $ldq_filter . "))";

    if ($ldq_debug)
        echo sprintf(_("QUERY is %s"),htmlspecialchars($ldq_filter)) . "<br />\n";

    // Perform search for each LDAP server configured in squirrel
    for ($ldq_lds=0 ; $ldq_lds < count($ldap_server) ; $ldq_lds++) {
        if ($ldq_server == -1 || 
            ! isset($ldap_server[$ldq_server]) ||
            $ldq_server == $ldq_lds) {

            // Get the data for this Directory Server
            $ldq_Server = $ldap_server[$ldq_lds]["host"];
            $ldq_Port = (isset($ldap_server[$ldq_lds]["port"]) ? $ldap_server[$ldq_lds]["port"] : 389);
            $ldq_base = $ldap_server[$ldq_lds]["base"];
            $ldq_Name = (isset($ldap_server[$ldq_lds]["name"]) ? $ldap_server[$ldq_lds]["name"] : $ldq_Server);

            // Get binddn and password (SM 1.5.0+ and 1.4.3+)
            if (isset($ldap_server[$ldq_lds]['binddn'])) {
                $ldq_binddn=$ldap_server[$ldq_lds]['binddn'];
                $ldq_bindpw= (isset($ldap_server[$ldq_lds]['bindpw']) ? $ldap_server[$ldq_lds]['bindpw'] : '');
                $ldq_internal_bind=true;
            } else {
                $ldq_internal_bind=false;
            }
            // Get bind protocol (SM 1.5.0+ and 1.4.3+)
            if (isset($ldap_server[$ldq_lds]['protocol']))
                $ldq_protocol = $ldap_server[$ldq_lds]['protocol'];

            // Get ldap charset
            $ldq_charset= (isset($ldap_server[$ldq_lds]['charset']) ? $ldap_server[$ldq_lds]['charset'] : 'utf-8');

            echo "<hr />\n";

            if ($ldq_debug) {
                echo '<i>';
                /*
                 * Used in debug mode
                 * Example output "Querying: ldap-server-address on port some-port with base ldap-base-dn"
                 * See http://www.php.net/sprintf if you want to rearrange order of arguments
                 */
                echo sprintf(_("Querying: %s on port %d with base %s"),$ldq_Server,$ldq_Port,$ldq_base);
                echo "</i><br />\n";
            }
            echo "<i>" . $ldq_Name . "</i><br /><br />\n";

            // connect to LDAP server
            if (!($ldq_ldap=@ldap_connect($ldq_Server,$ldq_Port))) {
                echo sprintf(_("Could not connect to LDAP server %s"),$ldq_Server);
                continue;
            }

            if (isset($ldq_protocol))
                @ldap_set_option($ldq_ldap, LDAP_OPT_PROTOCOL_VERSION, $ldq_protocol);

            //attempt to bind to LDAP server
            if ($ldq_internal_bind) {
                if (!@ldap_bind($ldq_ldap, $ldq_binddn, $ldq_bindpw)) {
                    echo _("Unable to bind to LDAP server") . "<br>\n";
                    continue;
                }
            } elseif ($ldq_authreqd) {
                if (!@ldap_bind($ldq_ldap, $ldq_rdn . ", " . $ldq_base, $ldq_pass)) {
                    echo _("Unable to bind to LDAP server") . "<br />\n";
                    continue;
                }
            } else {
                if (!@ldap_bind($ldq_ldap)) {
                    echo _("Unable to bind to LDAP server") . "<br />\n";
                    continue;
                }
            }

            // FIXME: do we need it?
            foreach ($ldq_attributes as $attr) {
                $ldq_tattr[] = $attr;
            }

            // perform search
            if (!($ldq_result = ldap_search($ldq_ldap, $ldq_base, $ldq_filter, $ldq_tattr))) {
                echo _("Nothing found!") . "<br />\n";
                continue;
            }

            // Get all the entries
            $ldq_entry = ldap_get_entries ($ldq_ldap, $ldq_result);
            
            if ($ldq_debug) {
                echo '<b>' . sprintf(_("output type is %s"),htmlspecialchars($ldapquery_output_type)) . "</b><br>\n";
                echo '<b>' . sprintf(_("output sorted by %s"),htmlspecialchars($ldq_sortby)) . "</b><br />\n";
            }

            switch ($ldapquery_output_type) {
            case "OneTable":
                ldapquery_dispresultsSingle ($ldq_attributes, $ldq_entry, $ldq_sortby, $ldq_charset);
                break;
            case "MultiTable":
            default:
                ldapquery_dispresultsMulti ($ldq_attributes, $ldq_entry, $ldq_sortby, $ldq_charset);
            }
 
            // close connection
            ldap_close($ldq_ldap);
        }
    }
}
?>
</body></html>
