<?php
/**
 * Contains translatable strings for LDAP core schema attributes.
 * Data source: OpenLDAP core.schema v.1.64.2.3
 * @copyright 2005-2006 The SquirrelMail Project Team
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License
 * @version $Id: core.php,v 1.6 2006/03/21 17:21:10 tokul Exp $
 * @package sm-plugins
 * @subpackage ldapquery
 */

/* Make sure that variables are arrays */
if (! is_array($ldq_attrib))
    $ldq_attrib=array();

if (! is_array($ldq_object))
    $ldq_object=array();

// openldap system schemas
$ldq_attrib['cn']['NAME']=_("Common Name");
$ldq_attrib['commonName']=$ldq_attrib['cn'];

$ldq_attrib['knowledgeInformation']['NAME']=_("Knowledge Information");

$ldq_attrib['sn']['NAME']=_("Surname");

$ldq_attrib['serialNumber']['NAME']=_("Serial Number");

$ldq_attrib['c']['NAME']=_("Country Name");

$ldq_attrib['l']['NAME']=_("Locality Name");

$ldq_attrib['st']['NAME']=_("State or Province Name");

$ldq_attrib['street']['NAME']=_("Street Address");

$ldq_attrib['o']['NAME']=_("Organisation Name");

$ldq_attrib['ou']['NAME']=_("Organisational Unit Name");

$ldq_attrib['title']['NAME']=_("Title");

$ldq_attrib['description']['NAME']=_("Description");

$ldq_attrib['searchGuide']['NAME']=_("Search Guide");

$ldq_attrib['businessCategory']['NAME']=_("Business Category");

$ldq_attrib['postalAddress']['NAME']=_("Postal Address");

$ldq_attrib['postalCode']['NAME']=_("Postal Code");

$ldq_attrib['postOfficeBox']['NAME']=_("Post Office Box");

$ldq_attrib['physicalDeliveryOfficeName']['NAME']=_("Physical Delivery Office Name");

$ldq_attrib['telephoneNumber']['NAME']=_("Telephone Number");

$ldq_attrib['telexNumber']['NAME']=_("Telex Number");

$ldq_attrib['teletexTerminalIdentifier']['NAME']=_("Teletex Terminal Identifier");

$ldq_attrib['facsimileTelephoneNumber']['NAME']=_("Facsimile (Fax) Telephone Number");
$ldq_attrib['fax']=$ldq_attrib['facsimileTelephoneNumber'];

$ldq_attrib['x121Address']['NAME']=_("X.121 Address");

$ldq_attrib['internationaliSDNNumber']['NAME']=_("International ISDN Number");

$ldq_attrib['registeredAddress']['NAME']=_("Registered Postal Address");

$ldq_attrib['destinationIndicator']['NAME']=_("Destination Indicator");

$ldq_attrib['preferredDeliveryMethod']['NAME']=_("Preferred Delivery Method");

$ldq_attrib['presentationAddress']['NAME']=_("Presentation Address");

$ldq_attrib['supportedApplicationContext']['NAME']=_("Supported Application Context");

$ldq_attrib['member']['NAME']=_("Member of a group");

$ldq_attrib['owner']['NAME']=_("Owner");

$ldq_attrib['roleOccupant']['NAME']=_("Occupant of role");

$ldq_attrib['seeAlso']['NAME']=_("See also");

$ldq_attrib['userCertificate']['NAME']=_("User Certificate");

$ldq_attrib['cACertificate']['NAME']=_("CA Certificate");

$ldq_attrib['authorityRevocationList']['NAME']=_("Authority Revocation List");

$ldq_attrib['certificateRevocationList']['NAME']=_("Certificate Revocation List");

$ldq_attrib['crossCertificatePair']['NAME']=_("Cross Certificate Pair");

$ldq_attrib['givenName']['NAME']=_("First Name");
$ldq_attrib['gn']=$ldq_attrib['givenName'];

$ldq_attrib['initials']['NAME']=_("Initials");

$ldq_attrib['generationQualifier']['NAME']=_("Generation Qualifier");

$ldq_attrib['x500UniqueIdentifier']['NAME']=_("X.500 unique identifier");

$ldq_attrib['dnQualifier']['NAME']=_("DN qualifier");

$ldq_attrib['enhancedSearchGuide']['NAME']=_("Enhanced Search Guide");

$ldq_attrib['protocolInformation']['NAME']=_("Protocol Information");

$ldq_attrib['uniqueMember']['NAME']=_("unique member of a group");

$ldq_attrib['houseIdentifier']['NAME']=_("House Identifier");

$ldq_attrib['supportedAlgorithms']['NAME']=_("Supported Algorithms");

$ldq_attrib['deltaRevocationList']['NAME']=_("Delta Revocation List");

// Attribute specifies a directory management domain (DMD), 
// the administrative authority which operates the directory server.
$ldq_attrib['dmdName']['NAME']=_("Name of DMD");

$ldq_attrib['labeledURI']['NAME']=_("Labelled URI");

$ldq_attrib['uid']['NAME']=_("User ID");
$ldq_attrib['userid']=$ldq_attrib['uid'];

$ldq_attrib['mail']['NAME']=_("Mail");
$ldq_attrib['rfc822Mailbox']=$ldq_attrib['mail'];

$ldq_attrib['dc']['NAME']=_("Domain Component");
$ldq_attrib['domainComponent']=$ldq_attrib['dc'];

$ldq_attrib['associatedDomain']['NAME']=_("Associated Domain");

$ldq_attrib['email']['NAME']=_("Email Address");
$ldq_attrib['emailAddress']=$ldq_attrib['email'];
$ldq_attrib['pkcs9email']=$ldq_attrib['email'];

/** Object Classes */
$ldq_object['country']['NAME']=_("Country");

$ldq_object['locality']['NAME']=_("Locality");

$ldq_object['organization']['NAME']=_("Organisation");

$ldq_object['organizationalUnit']['NAME']=_("Organisational Unit");

$ldq_object['person']['NAME']=_("Person");

$ldq_object['organizationalPerson']['NAME']=_("Organisational Person");

$ldq_object['organizationalRole']['NAME']=_("Organisational Role");

$ldq_object['groupOfNames']['NAME']=_("Group of Names");

$ldq_object['residentialPerson']['NAME']=_("Residential Person");

$ldq_object['applicationProcess']['NAME']=_("Application Process");

$ldq_object['applicationEntity']['NAME']=_("Application Entity");

/* RFC2256: a directory system agent (a server) */
$ldq_object['dSA']['NAME']=_("DSA");

$ldq_object['device']['NAME']=_("Device");

$ldq_object['strongAuthenticationUser']['NAME']=_("Strong Authentication User");

$ldq_object['certificationAuthority']['NAME']=_("Certificate Authority");

$ldq_object['groupOfUniqueNames']['NAME']=_("Group of Unique Names");

$ldq_object['userSecurityInformation']['NAME']=_("User Security Information");

$ldq_object['certificationAuthority-V2']['NAME']=_("Certificate Authority V2");

$ldq_object['cRLDistributionPoint']['NAME']=_("CRL Distribution Point");

/* a directory management domain object */
$ldq_object['dmd']['NAME']=_("dmd");

$ldq_object['pkiUser']['NAME']=_("PKI User");

$ldq_object['pkiCA']['NAME']=_("PKI CA");

$ldq_object['deltaCRL']['NAME']=_("Delta CRL");

$ldq_object['labeledURIObject']['NAME']=_("Labeled URI Object");

$ldq_object['simpleSecurityObject']['NAME']=_("Simple Security Object");

$ldq_object['dcObject']['NAME']=_("DC Object");

$ldq_object['uidObject']['NAME']=_("UID Object");
?>