<?php
/**
 * ldapquery plugin - setup script
 * @copyright 2001-2004 Brent Bice <bbice@persistence.com>
 * @copyright 2004-2005 SquirrelMail Project Team
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License
 * @version $Id: setup.php,v 1.7 2005/03/01 09:22:11 tokul Exp $
 * @package sm-plugins
 * @subpackage ldapquery
 */

/**
 * SM_PATH define
 * @ignore
 */
if (!defined('SM_PATH'))  {
    define('SM_PATH','../../');
}

/**
 * Init plugin
 */
function squirrelmail_plugin_init_ldapquery() {
  global $squirrelmail_plugin_hooks;

  $squirrelmail_plugin_hooks['menuline']['ldapquery'] = 'ldapquery_menuline';
  $squirrelmail_plugin_hooks['optpage_register_block']['ldapquery'] = 'ldapquery_options';
  $squirrelmail_plugin_hooks['options_save']['ldapquery'] = 'ldapquery_save';
  $squirrelmail_plugin_hooks['optpage_set_loadinfo']['ldapquery'] = 'ldapquery_set_loadinfo';
  $squirrelmail_plugin_hooks['loading_prefs']['ldapquery'] = 'ldapquery_prefs';
}

/**
 * Add meniu line
 */
function ldapquery_menuline () {
    include_once (SM_PATH . 'plugins/ldapquery/functions.php');
    ldapquery_menuline_function();
}

/**
 * Add options block
 */
function ldapquery_options() {
    include_once (SM_PATH . 'plugins/ldapquery/functions.php');
    ldapquery_options_function();
}

/**
 * Save options
 */
function ldapquery_save() {
    include_once (SM_PATH . 'plugins/ldapquery/functions.php');
    ldapquery_save_function();
}

/**
 * Set optpage_name displayed when settings are saved
 */
function ldapquery_set_loadinfo() {
    include_once (SM_PATH . 'plugins/ldapquery/functions.php');
    ldapquery_set_loadinfo_function();
}

/**
 * Load plugin preferences
 */
function ldapquery_prefs() {
    include_once (SM_PATH . 'plugins/ldapquery/functions.php');
    ldapquery_prefs_function();
}

/**
 * Displays plugin version
 * @return string version number
 */
function ldapquery_version() {
    include_once (SM_PATH . 'plugins/ldapquery/functions.php');
    return ldapquery_version_function();
}
?>