<?php
/**
 * Class that loads and provides ldap schema information
 * @copyright 2005 SquirrelMail Project Team
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License
 * @version $Id: class.schema.php,v 1.4 2005/03/01 09:22:10 tokul Exp $
 * @package sm-plugins
 * @subpackage ldapquery
 */

/**
 * class that is used to manage ldap attributes and objects
 * currently supports only translation of names
 * @package sm-plugins
 * @subpackage ldapquery
 */
class ldq_schemas {
    /**
     * @var array array that holds on ldap attribute data
     */
    var $attribs = array();
    /**
     * @var array array that holds on ldap object data
     */
    var $objects = array();
    /**
     * @var string class error messages
     */
    var $err = '';

    /**
     * add attribute data to array
     * @param array
     */
    function add_attrib($attribute,$data) {
        // lowercase attribute name
        $attribute=strtolower($attribute);

        if (! isset($this->attribs[$attribute]) ) {
            $this->attribs[$attribute] = $data;
            return true;
        } else {
            $this->err = sprintf(_("Dublicate ldap attribute definition: %s."),$attribute);
            return false;
        }
    }

    /**
     * Show attribute name translation
     * @param string $attribute ldap attribute name
     * @return string ldap attribute translation
     */
    function get_attrib_name($attribute) {
        // lowercase attribute name
        $attribute=strtolower($attribute);

        if (isset($this->attribs[$attribute]['NAME'])) {
            return $this->attribs[$attribute]['NAME'];
        } else {
            return $attribute;
        }
    }

    /**
     * add object data to array
     * @param array
     * @return bool true if added, false if error
     */
    function add_object($object,$data) {
        // lowercase object name
        $object=strtolower($object);

        if (! isset($this->objects[$object]) ) {
            $this->objects[$object] = $data;
            return true;
        } else {
            $this->err = sprintf(_("Dublicate ldap object definition: %s."),$object);
            return false;
        }
    }

    /**
     * show object name translation
     * @param string $object object name
     * @return string translated object name
     */
    function get_object_name($object) {
        // lowercase object name
        $object=strtolower($object);

        if ($object=='*') {
            return _("Any");
        } elseif (isset($this->objects[$object]['NAME'])) {
            return $this->objects[$object]['NAME'];
        } else {
            return $object;
        }
    }
}
?>