<?php
/**
 * ldapquery options
 * @copyright 2001-2004 Brent Bice <bbice@persistence.com>
 * @copyright 2004 SquirrelMail Development Team
 * @version $Id: options.php,v 1.4 2004/10/24 12:08:20 tokul Exp $
 * @package plugins
 * @subpackage ldapquery
 */

/** 
 * SM_PATH define
 * @ignore 
 */
define('SM_PATH','../../');

/** Including required squirrelmail files */
include_once (SM_PATH . 'include/validate.php');

/** Including site config */
include_once (SM_PATH . 'plugins/ldapquery/config.php');

/**
 * Create html option tags
 * @param string $Var
 * @param string $value
 * @param string $Desc
 */
function ldapquery_ShowOption($Var, $value, $Desc) {
    $Var = 'ldapquery_' . $Var;
       
    global $$Var;
       
    echo '<option value="' . $value . '"';
    if ($$Var == $value)
        {
            echo ' selected';
        }
    echo '>' . $Desc . "</option>\n";
}

/**
 * Create checkboxes
 * @param array $attributes
 */
function ldapquery_ShowCheckboxes($attributes) {
    foreach ($attributes as $attr_full=>$attr) {
        $Var = "ldapquery_showattr_" . $attr;
        global $$Var;
        echo "<tr><td>$attr_full</td><td><input type=\"checkbox\" name=" . $Var;
        if ($$Var == "on")
            echo ' checked';
        echo "></td></tr>\n";
    }
}

displayPageHeader($color, "None");

echo "<br />\n"
. '<table width="95%" align="center" border="0" cellpadding="2" cellspacing="0">'
. '<tr><td bgcolor="' . $color[0] . '">'
. '<center><b>' . _("Options - Directory Preferences") . '</b></center>'
. '</td></tr></table>';

echo '<p>' . _("Output types can be:") . "</p>\n";
   
echo '<dl>'
. '<dt><b>' . _("One Table") . "</b></dt>\n"
. '<dd>' . _("One big table with one row per record found and each selected attribute as a separate column.") . "</dd>\n"
. '<dt><b>' . _("Multiple Tables") . "</b></dt>\n"
. '<dd>' . _("One table per record found with 2 columns for each table. One column contains attribute names and the 2nd column shows values for each attribute.  This format is best if you have many attributes selected or if the values for some of the attributes you have selected can be very long with no spaces (like labeledurl).") . "</dd>\n"
. "</dl>\n";

echo '<form action="' . sqm_baseuri().'src/options.php' . '" method="post">';
echo '<table border="0" cellpadding="0" cellspacing="2">'
. '<tr><th align="right" nowrap>' . _("Select Output Type:") . '</th>'
. '<td><select name="ldapquery_output_type">';
ldapquery_ShowOption('output_type', 'OneTable', _("One Table"));
ldapquery_ShowOption('output_type', 'MultiTable', _("Multiple Tables"));
echo '</select>'
. '</td></tr>'
. '<tr><td colspan="2">&nbsp;</td></tr>'
. '<tr><th colspan="2" align="left">'
. _("Select Displayed Fields") . "</th></tr>\n";
ldapquery_ShowCheckboxes ($ldq_attributes);
echo '</td></tr>'
. '<tr>'
. '<td>&nbsp;</td>'
. '<td>'
. '<input type="hidden" name="optmode" value="submit">'
. '<input type="hidden" name="optpage" value="ldapquery">'
. '<input type="submit" value="' . _("Submit") . '" name="submit_ldapquery">'
. '</td>'
. '</tr>'
. '</table>'
. '</form>';
?>
</body></html>
