<?php

/**
 *
 * jsclock plugin for Squirellmail - setup.php  V0.6
 * Copyright (c) 2002-2003 Danny Chouinard
 * Licensed under the GNU GPL. For full terms see the file COPYING.
 * Displays a dynamic digital clock in the folders frame.
 *
 * Some inspiration from http://www.fortunecity.de/wolkenkratzer/westend/696/nixieclock/nixtime.htm
 * Nixie digit images (c) "Mike's electric stuff"
 *  http://www.electricstuff.co.uk
 * 
 */

// Hook into left_main (before & after for above & below), options,
// and preference loads.
function squirrelmail_plugin_init_jsclock() {
  global $squirrelmail_plugin_hooks;
  $squirrelmail_plugin_hooks['left_main_before']['jsclock'] = 'jsclock_show_clock_before';
  $squirrelmail_plugin_hooks['left_main_after']['jsclock'] = 'jsclock_show_clock_after';
  $squirrelmail_plugin_hooks['options_display_inside']['jsclock'] = 'jsclock_options';
  $squirrelmail_plugin_hooks['options_display_save']['jsclock'] = 'jsclock_save_options';
  $squirrelmail_plugin_hooks['loading_prefs']['jsclock'] = 'jsclock_load_options';
  return;
}

// Produce JavaScript code to pre-load images, follwed by HTML code to show
// the images, and another JavaScript block to animate them.
function jsclock_show_clock() {
	global $jsclock_face_name, $jsclock_hours, $jsclock_seconds, $jsclock_border;
  global $data_dir, $username, $toggle_jsclock_seconds, $toggle_jsclock_hours;
  global $set_jsclock_face, $jsclock_bgcolor, $jsclock_padding;
  global $set_jsclock_position, $set_jsclock_bgcolor, $set_jsclock_hours;
  global $set_jsclock_seconds, $set_jsclock_border, $set_jsclock_padding;
  if (isset($_SESSION['username'])) {
    $username = $_SESSION['username'];
  }
  if(isset($_GET['set_jsclock_face'])) {
    $set_jsclock_face=$_GET['set_jsclock_face'];
  }
  if(isset($set_jsclock_face)) {
    $jsclock_face_name=$set_jsclock_face;
    setPref($data_dir, $username, 'jsclock_face_name', $jsclock_face_name);
  }
  if(!isset($jsclock_face_name)) return;
  if($jsclock_face_name == 'None' || $jsclock_face_name == '' ) return;
  if(isset($_GET['set_jsclock_position'])) {
    $set_jsclock_position=$_GET['set_jsclock_position'];
  }
  if(isset($_GET['set_jsclock_seconds'])) {
    $set_jsclock_seconds=$_GET['set_jsclock_seconds'];
  }
  if(isset($_GET['set_jsclock_border'])) {
    $set_jsclock_border=$_GET['set_jsclock_border'];
  }
  if(isset($_GET['set_jsclock_padding'])) {
    $set_jsclock_padding=$_GET['set_jsclock_padding'];
  }
  if(isset($_GET['set_jsclock_hours'])) {
    $set_jsclock_hours=$_GET['set_jsclock_hours'];
  }
  if(isset($_GET['set_jsclock_bgcolor'])) {
    $set_jsclock_bgcolor=$_GET['set_jsclock_bgcolor'];
  }
  if(isset($set_jsclock_position)) {
    $jsclock_position=$set_jsclock_position;
    setPref($data_dir, $username, 'jsclock_position', $jsclock_position);
  }
  if(isset($set_jsclock_border)) {
    $jsclock_border=$set_jsclock_border;
    setPref($data_dir, $username, 'jsclock_border', $jsclock_border);
  }
  if(isset($set_jsclock_padding)) {
    $jsclock_padding=$set_jsclock_padding;
    setPref($data_dir, $username, 'jsclock_padding', $jsclock_padding);
  }
  if(isset($set_jsclock_hours)) {
    $jsclock_hours=$set_jsclock_hours;
    setPref($data_dir, $username, 'jsclock_hours', $jsclock_hours);
  }
  if(isset($set_jsclock_seconds)) {
    $jsclock_seconds=$set_jsclock_seconds;
    setPref($data_dir, $username, 'jsclock_seconds', $jsclock_seconds);
  }
  if(isset($set_jsclock_bgcolor)) {
    $jsclock_bgcolor=$set_jsclock_bgcolor;
    setPref($data_dir, $username, 'jsclock_bgcolor', "$jsclock_bgcolor");
  }
  if(isset($_GET['toggle_jsclock_hours'])) {
    $toggle_jsclock_hours=$_GET['toggle_jsclock_hours'];
  }
  if($toggle_jsclock_hours=='1') {
    if($jsclock_hours=='12') {
      $jsclock_hours=24;
    } else {
      $jsclock_hours=12;
    }
    setPref($data_dir, $username, 'jsclock_hours', $jsclock_hours);
  }
  if(isset($_GET['toggle_jsclock_seconds'])) {
    $toggle_jsclock_seconds=$_GET['toggle_jsclock_seconds'];
  }
  if($toggle_jsclock_seconds=='1') {
    $jsclock_seconds=1+$jsclock_seconds;
    if($jsclock_seconds > 3) {
      $jsclock_seconds=0;
    }
    setPref($data_dir, $username, 'jsclock_seconds', $jsclock_seconds);
  }
  $textfont=0;
  if(substr($jsclock_face_name,0,5)=='text_') {
    $textfont=1;
    $textfontsize=substr($jsclock_face_name,5,2);
  }
  $fprefix = "../plugins/jsclock/fonts/${jsclock_face_name}/";
  if($textfont=='0') {
    print '
<SCRIPT LANGUAGE="JavaScript">
<!--
var digits=new Array();
for (var i=0;i<10;i++){
  digits[i]=new Image();
  digits[i].src=';
  print "\"../plugins/jsclock/fonts/${jsclock_face_name}/\"+i+\".png\";\n}\n";
  if($jsclock_hours == '12') {
    print 'invis=new Image(); invis.src="../plugins/jsclock/fonts/misc/trans1x1.png";';
    print "\n";
  }
  print "iper=new Image(); icol=new Image();\n";
  print "iper.src=\"${fprefix}period.png\";\n";
  print "icol.src=\"${fprefix}colon.png\";\n";
  print '// -->
</SCRIPT>
';
    print "<center><table cellspacing=0 border=$jsclock_border";
    if(isset($jsclock_bgcolor)&&$jsclock_bgcolor!='') {
      if($jsclock_bgcolor!='None') {
        print " bgcolor=\"#$jsclock_bgcolor\"";
      }
    }
    if(isset($jsclock_padding)) {
      print " cellpadding=$jsclock_padding";
    }
    print '><tr><td><table border=0 cellspacing=0 cellpadding=0>';
    if(is_file("${fprefix}topmargin.png")) {
      print "<tr><td align=\"center\" nowrap><img src=\"${fprefix}topmargin.png\" border=0></td></tr>";
    }
    print '<tr><td align="center" nowrap>';
    if(is_file("${fprefix}leftmargin.png")) {
      print "<img src=\"${fprefix}leftmargin.png\" border=0>";
    }
    print '<a href="left_main.php?toggle_jsclock_hours=1">';
    switch($jsclock_seconds) {
      case 0: $e=4; break;
      case 1: $e=6; break;
      case 2: $e=7; break;
      case 3: $e=8; break;
    }
    for($i=0;$i<$e;$i++){
      switch($i) {
        case 2 : print '</a><a href="left_main.php?toggle_jsclock_seconds=1">'; /* No break here */
        case 4 : print "<img src=\"${fprefix}colon.png\" border=0>"; break;
        case 6 : print "<img src=\"${fprefix}period.png\" border=0>"; break;
      }
      print "<img src=\"${fprefix}${i}.png\" name=\"jd_${i}\" border=0>";
    }
    if(is_file("${fprefix}rightmargin.png")) {
      print "<img src=\"${fprefix}rightmargin.png\" border=0>";
    }
    print '</a></td></tr>';
    if(is_file("${fprefix}bottommargin.png")) {
      print "<tr><td align=\"center\" nowrap><img src=\"${fprefix}bottommargin.png\" border=0></td></tr>";
    }
    print '</table>';
  } else {
    print "<center><table border=$jsclock_border";
    if(isset($jsclock_bgcolor)&&$jsclock_bgcolor!='') {
      if($jsclock_bgcolor!='None') {
        print " bgcolor=\"#$jsclock_bgcolor\"";
      }
    }
    if(isset($jsclock_padding)) {
      print " cellpadding=\"$jsclock_padding\"";
    }
    print "><tr><td align=\"center\" nowrap><font size=$textfontsize><div id=\"jsclock_text\">No Browser support for this mode</div></font></td></tr></table>";
  }
  print '</td></tr></table></center>
<SCRIPT LANGUAGE="JavaScript">
<!--
function rc(){
  var n=new Date();
  var h=n.getHours();
  var m=n.getMinutes();
';
  if($jsclock_seconds > '0') print "  var s=n.getSeconds();\n";
  if($jsclock_seconds == '2') print "  var t=parseInt(n.getMilliseconds()/100);\n";
  if($jsclock_seconds == '3') print "  var c=parseInt(n.getMilliseconds()/10);\n";
  if($jsclock_hours == '12') {
    print "  h=(h>12)?h-12:h;\n";
    print "  h=(h==0)?12:h;\n";
  }
  if($textfont=='1' && $jsclock_hours == '12') {
    print '  var f=""+h';
  } else {
    print '  var f=""+((h<10)?"0"+h:h)';
  }
  if($textfont=='1') print '+":"';
  print '+((m<10)?"0"+m:m)';
  if($jsclock_seconds > '0') {
    if($textfont=='1') print '+":"';
    print '+((s<10)?"0"+s:s)';
  }
  if($textfont=='1' && $jsclock_seconds > '1') {
    print '+"."';
  }
  if($jsclock_seconds == '2') {
    print '+t';
  }
  if($jsclock_seconds == '3') print '+((c<10)?"0"+c:c)';
  print ";\n";
  if($textfont=='0') {
    print '  for (var i=f.length-1;i>=0;i--) {
    if (f.substring(i,i+1)!=l.substring(i,i+1)) {
      eval("document.jd_"+i+".src=digits[f.substring(i,i+1)].src");';
    if($jsclock_hours == '12') {
      print '
        if(i==0 && h<10) {
          document.jd_0.src=invis.src;
        }';
    }
    print '
    }
  }
  l=f;
';
  } else {
    print "  jsclock_text_obj=document.getElementById(\"jsclock_text\");\n";
    print "  jsclock_text_obj.innerHTML=\"\"+f;\n";
  }
  print '  setTimeout("rc()",';
  switch($jsclock_seconds) {
    case 0 : print '1010-n.getMilliseconds()+1000*(59-n.getSeconds())'; break;
    case 1 : print '1010-n.getMilliseconds()'; break;
    case 2 : print '101-(n.getMilliseconds()%100)'; break;
    case 3 : print '10'; break;
  }
  print ');
}
';
if($textfont=='0') print "var l=\"xxxxxxxx\";\n";
print 'rc();
// -->
</SCRIPT>
';
	return;
}

// Show clock depending on selected position.
function jsclock_show_clock_before() {
  global $jsclock_position;
  if($jsclock_position == 'below') return;
  jsclock_show_clock();
  return;
}

// Idem.
function jsclock_show_clock_after() {
  global $jsclock_position;
  if($jsclock_position != 'below') return;
  jsclock_show_clock();
  return;
}

// User folder preferences selectable options.
function jsclock_options() {
  global $jsclock_face_name, $jsclock_position, $jsclock_bgcolor;
  global $jsclock_hours, $jsclock_seconds, $jsclock_border, $jsclock_padding;
  global $faces;
  $fpath="../plugins/jsclock/fonts";
  $faces = array('None' => '   Disabled');
  for($i=1; $i<8;$i++) {
    $faces["text_$i"]="~  Text size $i  (Low Bandwidth)";
  }
  if(is_dir($fpath)) {
    $dir=@opendir($fpath);
    while (($dirent = readdir($dir)) !== false) {
      if($dirent!='.' && $dirent!='..' && $dirent!='misc') {
        if(is_dir($fpath . '/' . $dirent)) {
          $filepath=$fpath . '/' . $dirent . '/info.txt';
          if(is_readable($filepath)) {
            $file=fopen($filepath,'r');
            $info=fgets($file,128);
            fclose($file);
            $faces["$dirent"]="$info";
          }
        }
      }
    }
    closedir($dir);
  }
  asort($faces);
  if(!isset($jsclock_seconds) || $jsclock_seconds=='' ) $jsclock_seconds=1;
  print "\n<tr><td COLSPAN=\"2\">&nbsp;</td></tr>\n";
  print '<tr><td align=right><a href="../plugins/jsclock/userdoc.php">JavaScript clock face</a>:</td>';
  print "<td><select name=\"jsclock_face_name_in\">\n";
  foreach($faces as $key => $value) {
    print "<option value=\"$key\"";
    if($jsclock_face_name == $key)  print ' SELECTED';
    print ">$value</option>\n";
  }
  print '</select></td></tr>';
  print "\n<tr><td align=right>Position:</td>";
  print '<td><select name="jsclock_position_in"><option value=above';
  if( $jsclock_position != 'below' ) print ' SELECTED';
  print '>Above folder list<option value=below';
  if( $jsclock_position == 'below' ) print ' SELECTED';
  print '>Below folder list</select></td></tr>';
  print "\n<tr><td align=right>Hour format:</td>\n";
  print '<td><select name="jsclock_hours_in"><option value=24';
  if( $jsclock_hours == '24' ) print ' SELECTED';
  print '>24 hours<option value=12';
  if( $jsclock_hours == '12' ) print ' SELECTED';
  print '>12 hours</select></td></tr>';
  print "\n<tr><td align=right>Seconds display:</td>";
  print '<td><select name="jsclock_seconds_in"><option value=0';
  if( $jsclock_seconds == '0' ) print ' SELECTED';
  print '>Disabled<option value=1';
  if( $jsclock_seconds == '1' ) print ' SELECTED';
  print '>Enabled<option value=2';
  if( $jsclock_seconds == '2' ) print ' SELECTED';
  print '>Enabled, with tenths<option value=3';
  if( $jsclock_seconds == '3' ) print ' SELECTED';
  print ">Enabled, with hundredths</select></td><tr>\n";
  print '<td align=right>Border size:</td>';
  print '<td><select name="jsclock_border_in">';
  for( $i = 0 ; $i < 6 ; $i++ ) {
    print "<option value=$i";
    if( $jsclock_border == "$i" ) print ' SELECTED';
    print ">$i";
    if($i == 0) print '(None)';
  }
  print '</select></td></tr>';
  print '<td align=right>Padding:</td>';
  print '<td><select name="jsclock_padding_in">';
  for( $i = 0 ; $i < 21 ; $i++ ) {
    print "<option value=$i";
    if( $jsclock_padding == "$i" ) print ' SELECTED';
    print ">$i";
    if($i == 0) print '(None)';
  }
  print '</select></td></tr>';
  print '<td align=right>Background color:</td>';
  print "<td><input name=\"jsclock_bgcolor_in\" value=\"$jsclock_bgcolor\" size=7>";
  print '<tr><td COLSPAN="2">&nbsp;</td></tr>';
  return;
}

function jsclock_save_options() {
  global $data_dir, $username, $jsclock_face_name, $jsclock_face_name_in;
  global $jsclock_position_in, $jsclock_hours_in, $jsclock_seconds_in;
  global $jsclock_border_in, $jsclock_bgcolor_in, $jsclock_padding_in;
  if (isset($_SESSION['username'])) {
    $username = $_SESSION['username'];
  }
  if(isset($_POST['jsclock_face_name_in'])) {
    $jsclock_face_name_in = $_POST['jsclock_face_name_in'];
  }
  if(isset($_POST['jsclock_position_in'])) {
    $jsclock_position_in = $_POST['jsclock_position_in'];
  }
  if(isset($_POST['jsclock_hours_in'])) {
    $jsclock_hours_in = $_POST['jsclock_hours_in'];
  }
  if(isset($_POST['jsclock_seconds_in'])) {
    $jsclock_seconds_in = $_POST['jsclock_seconds_in'];
  }
  if(isset($_POST['jsclock_border_in'])) {
    $jsclock_border_in = $_POST['jsclock_border_in'];
  }
  if(isset($_POST['jsclock_bgcolor_in'])) {
    $jsclock_bgcolor_in = $_POST['jsclock_bgcolor_in'];
  }
  if(isset($_POST['jsclock_padding_in'])) {
    $jsclock_padding_in = $_POST['jsclock_padding_in'];
  }
  setPref($data_dir, $username, 'jsclock_face_name', $jsclock_face_name_in);
  setPref($data_dir, $username, 'jsclock_position', $jsclock_position_in);
  setPref($data_dir, $username, 'jsclock_hours', $jsclock_hours_in);
  setPref($data_dir, $username, 'jsclock_seconds', $jsclock_seconds_in);
  setPref($data_dir, $username, 'jsclock_border', $jsclock_border_in);
  setPref($data_dir, $username, 'jsclock_bgcolor', $jsclock_bgcolor_in);
  setPref($data_dir, $username, 'jsclock_padding', $jsclock_padding_in);
  return;
}

function jsclock_load_options()
{
    global $jsclock_face_name, $username, $data_dir;
    global $jsclock_position, $jsclock_hours, $jsclock_seconds;
    global $jsclock_border, $jsclock_bgcolor, $jsclock_padding;
    if (isset($_SESSION['username'])) {
      $username = $_SESSION['username'];
    }
    $jsclock_face_name = getPref($data_dir, $username, 'jsclock_face_name');
    $jsclock_position = getPref($data_dir, $username, 'jsclock_position');
    $jsclock_hours = getPref($data_dir, $username, 'jsclock_hours');
    $jsclock_seconds = getPref($data_dir, $username, 'jsclock_seconds');
    $jsclock_border = getPref($data_dir, $username, 'jsclock_border');
    $jsclock_bgcolor = getPref($data_dir, $username, 'jsclock_bgcolor');
    $jsclock_padding = getPref($data_dir, $username, 'jsclock_padding');
    if(!isset($jsclock_face_name)) $jsclock_face_name = 'None';
    if(!isset($jsclock_seconds)) $jsclock_seconds = '1';
    if(!isset($jsclock_border)) $jsclock_border = '0';
    if(!isset($jsclock_padding)) $jsclock_padding = '0';
    return;
}

?>
