<?php
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">
<html>
<head>
<title>Javascript Clock SquirrelMail plugin documentation</title>
</head>
<body TEXT="#000000" BGCOLOR="#FFFFFF" LINK="#0000CC" VLINK="#0000CC" ALINK="#0000CC">
<br>
<center><b>Javascript Clock SquirrelMail plugin documentation</b></center>
<p>
The Javascript Clock ("JSClock") is an extension to 
<a href="http://www.squirrelmail.org">SquirrelMail</a>
which displays a dynamic digital clock in the folders frame.  By default,
no clock is displayed until you choose a clock face.
</p>
<p>
If your browser doesn't have JavaScript enabled or isn't allowed to
"Change images", you'll get a static display reading "01:23:45".<br>
If your browser does not support PNG images, you'll not get a display
at all.
</p>
<p>
The JSClock plugin has the follwing options:<br>
<dl>
<dt><b>JavaScript clock face</b>
<dd>A number of different faces can be selected from this option.
    Choosing "Disabled" here disables the clock display completely and
    prevents the use of any JavaScript code.
    <p>
    Notice that some faces are pretty large and may require a wider
    folders frame.
    <p>
    Faces which have "ALPHA" in their description may not display
    properly in some browsers which do not implement standards
    correctly.  Internet Explorer users go <a href="http://www.petitiononline.com/msiepng/petition.html">here</a>.
    <br>Netscape 4.X users: Get 6 and up.
    <p>
    Entries named "Text" do not use images at all but an HTML-source changing
    trick that may be preferable for low-bandwidth links which may not work
    with some browsers, such as Opera; in that case you'll get a display
    which says "No Browser support for this mode".
    <p>
    You may click on these examples to make your selection:
<?php
$fpath="../../plugins/jsclock/fonts";
$faces = array('None' => '   Disabled');
$dir=@opendir($fpath);
while (($dirent = readdir($dir)) !== false) {
  if($dirent!='.' && $dirent!='..' && $dirent!='misc') {
    if(is_dir($fpath . '/' . $dirent)) { 
      $filepath=$fpath . '/' . $dirent . '/info.txt';
      if(is_readable($filepath)) {
        $file=fopen($filepath,'r');
        $info=fgets($file,128);
        fclose($file);
        $faces["$dirent"]="$info";
      }
    }
  }
}
closedir($dir);
asort($faces);
print '<br><br><table border=1 bgcolor="#A0B8C8">';
// print '<tr><td align=center bgcolor="#B8C8D8">Clock Face</td><td align=left bgcolor="#B8C8D8">Description</td></tr>';
for($i=1;$i<8;$i++) {
  $faces["text_$i"]="Text size $i";
}
$c=-1;
print '<tr>';
foreach($faces as $key => $value) {
  if($key != 'None') {
    if(++$c == 4) {
      $c=0;
      print '</tr><tr>';
    }
    print "<td border=0 align=\"center\" nowrap>";
    print "<a href=\"../../src/left_main.php?set_jsclock_face=$key\" target=left>";
    if(substr($key,0,5)=='text_') {
      print "$value";
    } else {
      if(is_file("${fpath}/${key}/leftmargin.png")) {
        print "<img src=\"${fpath}/${key}/leftmargin.png\" border=0>";
      }
      for($i=1;$i<7;$i++) {
        if($i==3 || $i==5) {
          print "<img src=\"${fpath}/${key}/colon.png\" border=0>";
        }
        print "<img src=\"${fpath}/${key}/${i}.png\" border=0>";
      }
      if(is_file("${fpath}/${key}/rightmargin.png")) {
        print "<img src=\"${fpath}/${key}/rightmargin.png\" border=0>";
      }
    }
    print "</a></td>";
  }
}
print '<td align="center" colspan=2><a href="../../src/left_main.php?set_jsclock_face=None" target=left>Click here to disable clock completely</a></td>';
print "</tr></table>\n";
?>
<p>
<dt><b>Position</b>
<dd>From this option you may select to display the clock either
    <a href="../../src/left_main.php?set_jsclock_position=above" target=left>above</a>
    or
    <a href="../../src/left_main.php?set_jsclock_position=below" target=left>below</a>
    the folder list.
<p>
<dt><b>Hour format</b>
<dd>Time can be displayed in either
    <a href="../../src/left_main.php?set_jsclock_hours=12" target=left>12</a>
    or
    <a href="../../src/left_main.php?set_jsclock_hours=24" target=left>24</a>
    hour format.  There is no AM/PM display (yet).
<p>
<dt><b>Seconds display</b>
<dd>Select
    <a href="../../src/left_main.php?set_jsclock_seconds=1" target=left>"Enabled"</a>
    or
    <a href="../../src/left_main.php?set_jsclock_seconds=0" target=left>"Disabled"</a>
    to toggle seconds display.<br>
    <a href="../../src/left_main.php?set_jsclock_seconds=2" target=left>"Enabled with tenths"</a>
    will also display tenths of seconds.<br>
    <a href="../../src/left_main.php?set_jsclock_seconds=3" target=left>"Enabled with hundredths"</a>
    will also display tenths and hundredths.
<p>
<dt><b>Border Size</b>
<dd>Select the size in pixels of the border around the clock face.<br>
<?php
for($i=0;$i<6;$i++) {
  print "<a href=\"../../src/left_main.php?set_jsclock_border=$i\" target=left>&nbsp $i &nbsp</a>\n";
}
?>
<p>
<dt><b>Padding</b>
<dd>Select the size in pixels for the spacing around the clock face.<br>
<?php
for($i=0;$i<21;$i++) {
    print "<a href=\"../../src/left_main.php?set_jsclock_padding=$i\" target=left>&nbsp $i &nbsp</a>\n";
}
?>
<p>
<dt><b>Background color</b>
<dd>Select the color for the face background.  An empty selection here<br>
    will use the theme's default background color.  The color is specified<br>
    by hexadecimal value ie: "B0E0E6", "FFDEAD", "4169E1", etc...<br>
    <br>
    Here are some standard web colors:
<?php
$colors = array(
'AliceBlue' => 'F0F8FF',
'AntiqueWhite' => 'FAEBD7',
'Aqua' => '00FFFF',
'Aquamarine' => '7FFFD4',
'Azure' => 'F0FFFF',
'Beige' => 'F5F5DC',
'Bisque' => 'FFE4C4',
'Black' => '000000',
'BlanchedAlmond' => 'FFEBCD',
'Blue' => '0000FF',
'BlueViolet' => '8A2BE2',
'Brown' => 'A52A2A',
'BurlyWood' => 'DEB887',
'CadetBlue' => '5F9EA0',
'Chartreuse' => '7FFF00',
'Chocolate' => 'D2691E',
'Coral' => 'FF7F50',
'CornflowerBlue' => '6495ED',
'Cornsilk' => 'FFF8DC',
'Crimson' => 'DC143C',
'Cyan' => '00FFFF',
'DarkBlue' => '00008B',
'DarkCyan' => '008B8B',
'DarkGoldenRod' => 'B8860B',
'DarkGray' => 'A9A9A9',
'DarkGreen' => '006400',
'DarkKhaki' => 'BDB76B',
'DarkMagenta' => '8B008B',
'DarkOliveGreen' => '556B2F',
'Darkorange' => 'FF8C00',
'DarkOrchid' => '9932CC',
'DarkRed' => '8B0000',
'DarkSalmon' => 'E9967A',
'DarkSeaGreen' => '8FBC8F',
'DarkSlateBlue' => '483D8B',
'DarkSlateGray' => '2F4F4F',
'DarkTurquoise' => '00CED1',
'DarkViolet' => '9400D3',
'DeepPink' => 'FF1493',
'DeepSkyBlue' => '00BFFF',
'DimGray' => '696969',
'DodgerBlue' => '1E90FF',
'Feldspar' => 'D19275',
'FireBrick' => 'B22222',
'FloralWhite' => 'FFFAF0',
'ForestGreen' => '228B22',
'Fuchsia' => 'FF00FF',
'Gainsboro' => 'DCDCDC',
'GhostWhite' => 'F8F8FF',
'Gold' => 'FFD700',
'GoldenRod' => 'DAA520',
'Gray' => '808080',
'Green' => '008000',
'GreenYellow' => 'ADFF2F',
'HoneyDew' => 'F0FFF0',
'HotPink' => 'FF69B4',
'IndianRed' => 'CD5C5C',
'Indigo' => '4B0082',
'Ivory' => 'FFFFF0',
'Khaki' => 'F0E68C',
'Lavender' => 'E6E6FA',
'LavenderBlush' => 'FFF0F5',
'LawnGreen' => '7CFC00',
'LemonChiffon' => 'FFFACD',
'LightBlue' => 'ADD8E6',
'LightCoral' => 'F08080',
'LightCyan' => 'E0FFFF',
'LightGoldenRodYellow' => 'FAFAD2',
'LightGrey' => 'D3D3D3',
'LightGreen' => '90EE90',
'LightPink' => 'FFB6C1',
'LightSalmon' => 'FFA07A',
'LightSeaGreen' => '20B2AA',
'LightSkyBlue' => '87CEFA',
'LightSlateBlue' => '8470FF',
'LightSlateGray' => '778899',
'LightSteelBlue' => 'B0C4DE',
'LightYellow' => 'FFFFE0',
'Lime' => '00FF00',
'LimeGreen' => '32CD32',
'Linen' => 'FAF0E6',
'Magenta' => 'FF00FF',
'Maroon' => '800000',
'MediumAquaMarine' => '66CDAA',
'MediumBlue' => '0000CD',
'MediumOrchid' => 'BA55D3',
'MediumPurple' => '9370D8',
'MediumSeaGreen' => '3CB371',
'MediumSlateBlue' => '7B68EE',
'MediumSpringGreen' => '00FA9A',
'MediumTurquoise' => '48D1CC',
'MediumVioletRed' => 'C71585',
'MidnightBlue' => '191970',
'MintCream' => 'F5FFFA',
'MistyRose' => 'FFE4E1',
'Moccasin' => 'FFE4B5',
'NavajoWhite' => 'FFDEAD',
'Navy' => '000080',
'OldLace' => 'FDF5E6',
'Olive' => '808000',
'OliveDrab' => '6B8E23',
'Orange' => 'FFA500',
'OrangeRed' => 'FF4500',
'Orchid' => 'DA70D6',
'PaleGoldenRod' => 'EEE8AA',
'PaleGreen' => '98FB98',
'PaleTurquoise' => 'AFEEEE',
'PaleVioletRed' => 'D87093',
'PapayaWhip' => 'FFEFD5',
'PeachPuff' => 'FFDAB9',
'Peru' => 'CD853F',
'Pink' => 'FFC0CB',
'Plum' => 'DDA0DD',
'PowderBlue' => 'B0E0E6',
'Purple' => '800080',
'Red' => 'FF0000',
'RosyBrown' => 'BC8F8F',
'RoyalBlue' => '4169E1',
'SaddleBrown' => '8B4513',
'Salmon' => 'FA8072',
'SandyBrown' => 'F4A460',
'SeaGreen' => '2E8B57',
'SeaShell' => 'FFF5EE',
'Sienna' => 'A0522D',
'Silver' => 'C0C0C0',
'SkyBlue' => '87CEEB',
'SlateBlue' => '6A5ACD',
'SlateGray' => '708090',
'Snow' => 'FFFAFA',
'SpringGreen' => '00FF7F',
'SquirrelBlue' => 'A4BACD',
'SteelBlue' => '4682B4',
'Tan' => 'D2B48C',
'Teal' => '008080',
'Thistle' => 'D8BFD8',
'Tomato' => 'FF6347',
'Turquoise' => '40E0D0',
'Violet' => 'EE82EE',
'VioletRed' => 'D02090',
'Wheat' => 'F5DEB3',
'White' => 'FFFFFF',
'WhiteSmoke' => 'F5F5F5',
'Yellow' => 'FFFF00',
'YellowGreen' => '9ACD32'
);
$c=-1;
print '<table border=0 cellpadding=1 bgcolor="#A4BACD"><tr><td><table border=0 bgcolor="#F0F0FF" ><tr>';
foreach($colors as $colorname => $colorvalue) {
  if(++$c == 18) {
    $c=0;
    print '</tr><tr>';
  }
  print "<td bgcolor=\"#$colorvalue\"><a href=\"../../src/left_main.php?set_jsclock_bgcolor=${colorvalue}&colorname=${colorname}\" target=left>&nbsp&nbsp&nbsp</a></td>";
}
print '</tr></table></td></tr></table>';
?>
<a href="../../src/left_main.php?set_jsclock_bgcolor=None" target=left>No color</a>.
</dl>
<p>
<dl>
<dt><b>Clicking on the face</b><br>
<dd>
You may also toggle between 12 and 24 hour format by clicking on the
hour part of the clock face.
Clicking on the minutes or seconds part of the face will toggle between
seconds display modes "Disabled", "Enabled", "Enabled with tenths", and
"Enabled with hundredths".
<br>Clicking on the face only works for image (non-text) faces.
</dl>
</p>
<br><br>
<center><a href="../../src/options.php?optpage=display">Click here to return to the preferences</a></center>

</body>
</html>

