<?php
/**
  * restrict_functions.php
  *
  * Copyright 2006 Jonathan Angliss <jon@squirrelmail.org>
  *
  * ip_restrict is an add-on to the SquirrelMail project.  This package is free software;
  * you can redistribute it and/or modify it under the terms of the GNU General Public
  * as published by the Free Software Foundation.
  *
  * ip_restrict is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
  * without even the implied warranty of MECHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  * See the GNU General Public License for more details.
  *
  * You should have received a copy of the GNU General Public License along with ip_restrict.
  * If you did not, write to:
  *
  *   Free Software Foundatio, Inc.
  *   59 Temple Place
  *   Suite 330
  *   Boston, MA
  *   02111-1307
  *   USA
  */

function matchCIDR($addr, $cidr) {
    $res = false;

    if (!is_array($cidr)) {
        $cidr = array( $cidr );
    }
    
    foreach($cidr as $subcidr) {
        if (stristr($subcidr, '/')) {
            list($network, $mask) = explode('/', $subcidr);
        
            $x = ip2long($mask);
            if ($mask == long2ip($x)) {
                $mask = $x;
            } else {
                $mask = 0xffffffff << (32 - $mask);
            }
        
            $res = ((ip2long($addr) & $mask) == (ip2long($network) & $mask));
            
            if ($res) {
                break;
            }
        }
    }
    
    return $res;
    
}

function do_restrict() {
    global $login_username, $force_username_lowercase, $vlogin_remap_username_completed;
    
    /**
     * Setup.php files are loaded by plugins.php as such the vlogin_version
     * function should be available.
     */
    if (function_exists('vlogin_version')) {

        if (file_exists(SM_PATH . 'plugins/vlogin/functions.php')) {
            
            $vlogin_ver = explode('.', vlogin_version());
            
            $vlogin_ok = false;

            if (isset($vlogin_ver[0]) && ($vlogin_ver[0] > 3)) {
                $vlogin_ok = true;
            } else if (isset($vlogin_ver[0]) && ($vlogin_ver[0] == 3)) {
                if (isset($vlogin_ver[1]) && ($vlogin_ver[1] > 8)) {
                    $vlogin_ok = true;
                } else if (isset($vlogin_ver[1]) && ($vlogin_ver[1] == 8)) {
                    if (isset($vlogin_ver[2]) && ($vlogin_ver[2] >= 1)) {
                        $vlogin_ok = true;
                    }
                }
            }
            
            if (!$vlogin_remap_username_completed && $vlogin_ok) {
                include_once(SM_PATH . 'plugins/vlogin/functions.php');
                vlogin_domain_do($args);
            }
        }
    }
        
    if (!empty($force_username_lowercase) && $force_username_lowercase) {
        $login_username = strtolower($login_username);
    }
    
    $tmp_data = @file(SM_PATH . 'plugins/ip_restrict/restrict.php');
    
    // No data //
    if (!$tmp_data) {
        logout_error( _("Unable to open restriction configuration file."));
        die();
    }
    
    $data = array();
    
    foreach($tmp_data as $record) {
        /**
          * Line format is:
          *    username=ip|ip|ip|ip
          */
        if (stristr($record, '=')) {
            list($user, $ips) = explode('=', $record);
            
            $data[trim($user)] = explode('|', trim($ips));
            
        }
    }
    
    // No Data //
    if (!count($data)) {
        logout_error( _("Corrupt or missing data in restriction configuration file."));
        die();
    }
    
    $grant = false;
    
    if (!sqgetGlobalVar('REMOTE_ADDR', $remote, SQ_SERVER)) {
        logout_error(_("Unable to establish remote connection address."));
        die();
    }
    
    
    if (isset($data[$login_username])) {
        // Exact Match //
        if (in_array($remote, $data[$login_username])) {
            $grant = true;
        } elseif (in_array('0', $data[$login_username])) {
            $grant = true;
        } else {
            $grant = matchCIDR($remote, $data[$login_username]);
        }
    } elseif (isset($data['*'])) {
        if (in_array($remote, $data['*'])) {
            $grant = true;
        } elseif (in_array('0', $data['*'])) {
            $grant = true;
        } else {
            $grant = matchCIDR($remote, $data['*']);
        }        
    }
    
    if (!$grant) {
        logout_error( _("Access for this account is restricted to trusted sites only.") );
        die();      
    }

}

?>