<?php

/**
 * signingkey.mod
 * ----------------
 * GPG module
 * Copyright (c) 1999-2002 The SquirrelMail development team
 * Licensed under the GNU GPL. For full terms see the file COPYING.
 *
 * Signing Key options page
 * Allow the user to specify a signing_key_id
 *
 *  $Id: signingkey.mod,v 1.11 2003/04/07 22:30:25 brian Exp $
 *
 */

//make the global $debug setting available here
global $debug;

$GPG_DIR="gpg";
if (file_exists('gpg_key_functions.php')){
	require_once('gpg_key_functions.php');
} elseif (file_exists('../gpg_key_functions.php')){
    require_once('../gpg_key_functions.php');
} elseif (file_exists('../plugins/gpg/gpg_key_functions.php')){
    require_once('../plugins/gpg/gpg_key_functions.php');
} else echo "include file not found, exiting abnormally";

// get the variables we need from the _POST without extract ($_POST);
$form = $_POST ['form'];
if ($form == 1) {
   $use_signing_key_id = $_POST ['use_signing_key_id'];
   $no_signing_passwd  = $_POST ['no_signing_passwd'];
   $key_id             = $_POST ['key_id'];
   $key_search_string  = $_POST ['key_search_string'];
}

/**
 * function gpg_format_key_list
 * This function takes the output provided by gpg_list_keys and takes only
 * those keys that a person can use to sign with and displays them for the user
 * to pick from
 *
 * @param $search_string, $msg, $debug
 * @return string with output containing HTML table+form bits
 *
 */

function gpg_format_key_list ($search_string, $msg, $debug){

   $list_text = gpg_list_keys($debug, $search_string, 'true', 'false', 'private');

   $signing_key_id = getPref ($data_dir, $username, 'signing_key_id');

   if ($debug) {
      $msg .= $search_string . 'Search String <br>';
      $msg .= '<p>'
           .'Using signing key: '.getPref ($data_dir, $username, 'use_signing_key_id').'<br>'
           ._("You current signing key: ") . $signing_key_id .'<br>Key Details:<br><br>';
      $msg .= htmlspecialchars(implode ('', $list_text));

   };

   $msg .= '<table>'
        . '<tr>'
        . ' <td></td>'
        . ' <td><b>Email Address</b></td>'
        . ' <td nowrap><b> Key Date </b></td>'
        . ' <td><b>Key Length</b></td>'
        . ' <td><b>Algorithm</b></td>'
        . ' <td><b>Key ID</b></td>'
        . '</tr>';
   foreach ($list_text as $line) {
      $checked='';
      if (eregi ("sec:", $line)) {
         $bits = explode (":", $line);
         $key_len = $bits[2];
         $key_alg = $bits[3];
	 	/* Algorithm
	 	 *  1 = RSA
     	 * 16 = ElGamal (encrypt only)
     	 * 17 = DSA (sometimes called DH, sign only)
     	 * 20 = ElGamal (sign and encrypt)
     	 */
          $signable=0;
	  switch ($key_alg) {
	     case 1:
            $signable=1;
	        $key_alg_str = 'RSA';
	        break;
	     case 16:
	        $key_alg_str = 'ElGamal (encrypt only)';
	        break;
	     case 17:
            $signable=1;
	        $key_alg_str = 'DSA/DH';
	        break;
	     case 20:
            $signable=1;
	        $key_alg_str = 'ElGamal (sign and encrypt)';
	        break;
	  }
	  $key_id = $bits[4];
	  $key_date = $bits[5];
	  eregi(".*(<.*>).*", $bits[9], $matches);
	  $email_str = htmlspecialchars($bits[9]);
	  $email_addr = htmlspecialchars($matches[1]);
          $checked=0;
	  if (($key_id != "") and ($signable)) {
             if ($key_id == $signing_key_id) {
                 $checked = "checked=checked";
             }
	     $msg .=   '<tr>'
                  . " <td><input type=radio $checked name=key_id value=$key_id></td>"
                  . " <td>$email_str [$email_addr]</td>"
                  . " <td nowrap>$key_date</td>"
                  . " <td>$key_len</td>"
                  . " <td>$key_alg_str</td>"
                  . " <td>$key_id</td>"
                  . '</tr>';
          };
	};
	$checked='';
   };
   $msg .= '</table>';

   return $msg;
};


if ($form != 1) {

   $use_signing_key_id = getPref ($data_dir, $username, 'use_signing_key_id');
   if ($use_signing_key_id=='true') {
      $checked = "checked=checked";
   };

   $no_signing_passwd = getPref ($data_dir, $username, 'no_signing_passwd');
   if ($no_signing_passwd=='true') {
      $pwchecked = "checked=checked";
   };

   $msg = '<p>'
	. _("Define the Key you want to use as your signing key.")
	. '<FORM METHOD="POST">'
	. '<input type="hidden" name="MOD" value="signingkey" >'
	. '<BR>'
	. '<p>'
	. 'Allow Secure GPG Signing of Messages: '
	. "<input type=checkbox $checked name=use_signing_key_id value='true'>"
	. '<p>'
	. 'Never ask for a passphrase when signing a message: '
	. "<input type=checkbox $pwchecked name=no_signing_passwd value='true'>";

   $msg .= '<hr>'
	. 'The list below contains all secret keys on your keyring that may be used for signing.';

   //create the radio button table
   $msg = gpg_format_key_list ($search_string, $msg, $debug);

   $msg .= '<input type=hidden name=form value=1>'
        . '<br><input type=submit value="Set your Signing Key ID">'
        . '</form>';


   gpg_makePage( _("GPG Options - Set Signing Key"), null, $msg);
   exit();
} else {

   if ($key_id != "") {
      //set the Preference and retrieve it
      setPref ($data_dir, $username, 'signing_key_id', $key_id);
      if ($use_signing_key_id==true) {
         setPref ($data_dir, $username, 'use_signing_key_id', 'true');
      } else {
         setPref ($data_dir, $username, 'use_signing_key_id', 'false');
      };
      if ($no_signing_passwd==true) {
	     setPref ($data_dir, $username, 'no_signing_passwd', 'true');
	  } else {
	     setPref ($data_dir, $username, 'no_signing_passwd', 'false');
      };
      $key_id = getPref ($data_dir, $username, 'signing_key_id');
      if ($debug) {
         $msg .= "Search String: $key_id"
              . '<br>';
      };

      $list_text = gpg_list_keys($debug, $key_id, 'false', 'false');
      $msg .= '<p>'
           .'Allow secure gpg signing of messages: '.getPref ($data_dir, $username, 'use_signing_key_id')
           .'<br>';
      if ($use_signing_key_id==true){
         $msg .= '<p>'
              ._("Signing key may be used without pass phrase: ") . getPref ($data_dir, $username, 'no_signing_passwd')
              ._("<br>You will now sign with key: ") . $key_id .'<br>Key Details:<br><br>'
              . htmlspecialchars(implode ('', $list_text));
      } else {
         $msg .= '<p>Your preference to not use the signing key ID feature has been recorded.';
      };

      gpg_makePage( _("Signing Key Results"), null, $msg);
      exit();
   } else {
      $msg = 'No signing key defined.';
      gpg_makePage( _("Signing Key Error Page"), null, $msg);
      exit();
   };
};

/**
 *
 * $Log: signingkey.mod,v $
 * Revision 1.11  2003/04/07 22:30:25  brian
 * modified file to not use extract $_POST
 * added extract for use_signing_key_id
 * Bug 5
 *
 * Revision 1.10  2003/04/07 22:21:59  brian
 * modified files to not use extract $_POST
 * Bug 5
 *
 * Revision 1.9  2003/04/01 18:06:42  brian
 * fixed includes to reflect different calling directories
 *
 * Revision 1.8  2003/03/13 15:07:13  tyler
 * - variable was spelled wrong causing auto_sign to fail
 *
 * Revision 1.7  2003/03/13 04:06:12  brian
 * - modified to correctly accept passphrase for message signing
 * - added checks for using the signing feature and
 *   needing passphrase for secret key
 *
 * Revision 1.6  2003/03/12 19:06:58  tyler
 * - cleaned up the code and added function comments
 *
 * Revision 1.5  2003/03/12 18:14:31  brian
 * manually merged $log revision history
 *
 * Revision 1.4  2003/03/12 18:10:22  brian
 * added $Log directive
 *
 *
 * Revision 1.3  2003/03/12 17:08:37  brian
 * use optional $keyring_type parameter to gpg__list_keys function
 * - allows listing of only private keys.
 *
 * Revision 1.2  2003/03/12 04:38:18  tyler
 * - added more debug params for bug hunting
 *
 * Revision 1.1  2003/03/12 03:57:58  tyler
 * Initial Revision
 * - added signingkey.mod
 * - add the signingkey.mod to the options window
 * - converted gpgsign.mod to honor the preferences
 */
?>
