<?php
/**
 * sign_init.mod
 *-----------
 * GPG plugin message signing module file,
 *
 * Copyright (c) 1999-2003 The SquirrelMail development team
 * Licensed under the GNU GPL. For full terms see the file COPYING.
 *
 * Copyright (c) 2002-2003 Braverock Ventures
 *
 * Initial Author: Tyler Allison
 *
 * $Id: sign_init.mod,v 1.13 2003/04/07 17:42:31 brian Exp $
 */
if (file_exists('gpg_sign_functions.php')){
	require_once('gpg_sign_functions.php');
} elseif (file_exists('../gpg_sign_functions.php')){
    require_once('../gpg_sign_functions.php');
} elseif (file_exists('../plugins/gpg/gpg_sign_functions.php')){
    require_once('../plugins/gpg/gpg_sign_functions.php');
} else echo "include file not found, exiting abnormally";

$use_signing_key_id = getPref ($data_dir, $username, 'use_signing_key_id');

$no_signing_passwd = getPref ($data_dir, $username, 'no_signing_passwd');

if ($debug) {
    $msg .= "use_signing_key_id = $use_signing_key_id<br>";
    $msg .= "no_signing_passwd = $no_signing_passwd<br>";
}

$msg .= '<form method="post">'
     . '<input type="hidden" name="MOD" value="gpgsign">'
     . '<input type="hidden" name="body_text">';

if ($no_signing_passwd == 'false') {

    if (gpg_https_connection ()) {
	   $msg .= 'Enter Passphrase:<input type="password" name="passphrase">';
	   $msg .= "<p align='center'><input type='submit' value='Submit' onclick='gpg_pop_submit()'></p>";
	} else {
	   $msg .= '<p>You are not connected using a secure SSL (HTTPS) connection!';
	   $msg .= '<br> Signing functions not allowed from an insecure connection.';
	   $msg .= "<p align='center'><input type='button' value='Close Window' onclick='window.close'></p>";
	}
}

$msg .='</form>';

if (file_exists('../plugins/gpg/js/gpgsign_init.js')){
   gpg_makePopWindow(_("GPG Signing Initiating"), "js/gpgsign_init.js", $msg, 'submit');
}elseif (file_exists('js/gpgsign_init.js')){
   gpg_makePopWindow(_("GPG Signing Initiating"), "js/gpgsign_init.js", $msg, 'submit');
} elseif (file_exists('../js/gpgsign_init.js')) {
   gpg_makePopWindow(_("GPG Signing Initiating"), "../js/gpgsign_init.js", $msg, 'submit');
} else echo "script file not found, exiting abnormally.";


/*
 * $Log: sign_init.mod,v $
 * Revision 1.13  2003/04/07 17:42:31  brian
 * added https test for signing with passphrase
 * bug 7 fixed
 *
 * Revision 1.12  2003/04/02 20:48:39  brian
 * fixed spelling errors using aspell
 * TODO - check grammer and sentence structure manually
 * Bug 18
 *
 * Revision 1.11  2003/04/01 17:45:02  brian
 * updated to remove the onsubmitp'return false' in the form tag
 *
 * Revision 1.10  2003/04/01 07:11:42  brian
 * fixed includes to reflect different calling directories
 *
 * Revision 1.9  2003/03/31 14:12:00  brian
 * added require_once statement to require signing functions file.
 * change needed to use generalized pop-up window function
 *
 * Revision 1.8  2003/03/28 13:29:34  brian
 * - changed functions from gpgsignsubmit and gpgsigninit to
 *   gpg_pop_init and gpg_pop_submit
 *   to better abstract them for use in decryption
 * - manually added header block and Log: entries to file
 * Bug 8
 *
 * Revision : 1.7 2003/3/13 20:29:25 'tyler'
 * - disabled the use of 'enter' or 'return' when entering passphrase. This
 * - follows the coding style of Squirrelspell and ensures an onclick()
 *
 * Revision : 1.6 2003/3/13 20:7:18 'tyler'
 * - building the <body> tag for onload() needs to be done in the makeWindow function otherwise we get two body tags and the onload() version doesnt work
 *
 * Revision : 1.5 2003/3/13 15:41:11 'tyler'
 * - onload() is for auto_sign...onclick() is for no auto_sign
 *
 * Revision : 1.4 2003/3/13 4:6:6 'brian'
 * - modified to correctly accept passphrase for message signing
 * - added checks for using the signing feature and
 *   needing passphrase for secret key
 *
 * Revision : 1.3 2003/3/12 4:53:53 'tyler'
 * - if autosign preference is set true then don't ask for passphrase
 *
 * Revision : 1.2 2003/3/11 22:0:40 'tyler'
 * - initial work to accept passphrase in the pop-up window
 *
 * Revision : 1.1 2003/3/11 4:10:34 'tyler'
 * - Main window we pop to grab the passphrase before signing
 */

?>
