<?php
/**
 * sign_init.mod
 *-----------
 * GPG plugin decrypt passphrase collecting module file,
 *
 * Copyright (c) 1999-2003 The SquirrelMail development team
 * Licensed under the GNU GPL. For full terms see the file COPYING.
 *
 * Copyright (c) 2002-2003 Braverock Ventures
 *
 * $Id: decrypt_init.mod,v 1.11 2003/04/02 20:48:39 brian Exp $
 */

if (file_exists('gpg_encrypt_functions.php')){
	require_once('gpg_encrypt_functions.php');
} elseif (file_exists('../gpg_encrypt_functions.php')){
    require_once('../gpg_encrypt_functions.php');
} elseif (file_exists('../plugins/gpg/gpg_encrypt_functions.php')){
    require_once('../plugins/gpg/gpg_encrypt_functions.php');
} else echo "include file not found, exiting abnormally";

$use_signing_key_id = getPref ($data_dir, $username, 'use_signing_key_id');

$no_signing_passwd = getPref ($data_dir, $username, 'no_signing_passwd');

//pull the variables we need from the submitted data
if (isset($_GET['passed_id'])) {
    $passed_id = (int) $_GET['passed_id'];
} elseif (isset($_POST['passed_id'])) {
    $passed_id = (int) $_POST['passed_id'];
}
if (isset($_GET['mailbox'])) {
    $mailbox = $_GET['mailbox'];
} elseif (isset($_POST['mailbox'])) {
    $mailbox = $_POST['mailbox'];
}


// should add test here to make sure we have a secret keyring,
// or place the test in setup.php

if ($debug) {
    $msg .= "<br>use_signing_key_id = $use_signing_key_id<br>"
         . "no_signing_passwd = $no_signing_passwd<br>"
         . "passed_id = $passed_id<br>"
         . "mailbox = $mailbox";
}

$msg .= '<form method=post>'
     . '<input type=hidden name=MOD value="gpgdecrypt">'
     . '<input type=hidden name=body_text>'
     . "<input type=hidden name=passed_id value='$passed_id'>"
     . "<input type=hidden name=mailbox   value='$mailbox'>";


$msg .= 'Enter Passphrase:<input type=password name=passphrase>';
$msg .= '<p align=center>';
$msg .= '<input type=submit value=Submit></p>';

$msg .= '</form>';

gpg_makePopWindow(_("GPG Decryption Initiating"), '', $msg);

/*
 * $Log: decrypt_init.mod,v $
 * Revision 1.11  2003/04/02 20:48:39  brian
 * fixed spelling errors using aspell
 * TODO - check grammer and sentence structure manually
 * Bug 18
 *
 * Revision 1.10  2003/04/02 18:25:31  brian
 * removed check for no_signing_password to account for the fact that user may have multiple keys.
 *
 * Revision 1.9  2003/04/02 17:40:30  brian
 * - removed size attribute because it did wacky stuff to the pop-up
 * - revisit later
 *
 * Revision 1.8  2003/04/02 17:32:41  brian
 * removed check for no_signing_password to account for the fact that user may have multiple keys.
 *
 * Revision 1.7  2003/04/01 17:50:41  brian
 * fixed includes to reflect different calling directories
 *
 * Revision 1.6  2003/04/01 17:38:20  brian
 * removed scriptsrc links, because decrypt doesn't use them
 *
 * Revision 1.5  2003/04/01 05:07:42  joelm
 * Fixed some paths to included files. Also removed carriage returns from
 * cyphertext in the decrypt module
 *
 * Revision 1.4  2003/03/31 23:19:14  brian
 * fixed typo on line 47 that incorrectly assigned value $passed-id instead of $passed_id
 *
 * Revision 1.3  2003/03/31 21:57:53  brian
 * modified to process passed_id and mailbox from submitted data
 *
 * Revision 1.2  2003/03/31 14:59:54  brian
 * updated decryption modules to use standardized gpg_pop_init.php methods
 * Bug 8
 *
 * Revision 1.1  2003/03/29 23:03:29  brian
 * Initial revision
 * Preparation for decrypt functionality
 * Bug 8
 *
 */

?>