<?php
/**
 * gpg_options.php
 * --------------------
 * Main wrapper for the options interface.
 *
 * Copyright (c) 1999-2002 The SquirrelMail development team
 * Licensed under the GNU GPL. For full terms see the file COPYING.
 *
 * Copyright (c) 2002 Braverock Ventures
 *
 * $Id: gpg_options.php,v 1.4 2003/03/07 00:12:52 brian Exp $
 *
 */

/**
 * Set a couple of constants and defaults. Don't change these,
 * the configurable stuff is in gpg_config.php
 */
$GPG_DIR='gpg';
$GPG_CRYPTO=TRUE;

/**
 * Load some necessary stuff from squirrelmail.
 */
require_once("gpg_functions.php");

/**
 * $MOD is the name of the module to invoke.
 * If $MOD is unspecified, assign "init" to it. Else check for
 * security breach attempts.
 */

if(isset($_POST['MOD'])) {
  $MOD = $_POST['MOD'];
} elseif (isset($_GET['MOD'])) {
  $MOD = $_GET['MOD'];
}

if(!isset($MOD) || !$MOD) {
  $MOD = 'options_main';
} else {
  gpg_ckMOD($MOD);
}

/**
 * Load the stuff already.
 */
require_once("modules/$MOD.mod");

/**
 *
 * $Log: gpg_options.php,v $
 * Revision 1.4  2003/03/07 00:12:52  brian
 * Removed superflous includes.
 *
 * Revision 1.3  2002/12/10 03:46:20  brian
 * updated to not require gpg_config, as it is required by gpg_functions
 *
 *
 */

?>
